/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.manager.MediaTableEntry;
import java.util.List;

public class MediaTableEntryPool {
    private MediaTableEntry first;
    private MediaTableEntry last;
    private int size;
    private int limit;
    private long total;

    public MediaTableEntryPool(int size, int limit) {
        this.limit = limit;
        this.size = 0;
        if (size > 0) {
            MediaTableEntry firstEntry;
            MediaTableEntry prevEntry = firstEntry = this.getEntry(null);
            for (int i = 1; i < size; ++i) {
                MediaTableEntry entry;
                prevEntry.next = entry = this.getEntry(null);
                prevEntry = entry;
            }
            this.first = firstEntry;
            this.last = prevEntry;
            this.size = size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MediaTableEntry getEntry(MediaCrateEntry crateEntry) {
        MediaTableEntry entry = this.first;
        if (entry != null) {
            MediaTableEntry next;
            this.first = next = entry.next;
            if (next == null) {
                this.last = null;
            }
            --this.size;
            entry.reset(crateEntry);
            return entry;
        }
        try {
            MediaTableEntry mediaTableEntry = new MediaTableEntry(crateEntry);
            return mediaTableEntry;
        }
        finally {
            ++this.total;
        }
    }

    public synchronized void recycle(MediaTableEntry entry) {
        if (this.size >= this.limit) {
            return;
        }
        entry.next = null;
        if (this.last == null) {
            this.first = entry;
        } else {
            this.last.next = entry;
        }
        this.last = entry;
        ++this.size;
    }

    protected synchronized void recycle(List entryList) {
        MediaTableEntry firstEntry;
        int num = Math.min(entryList.size(), this.limit - this.size);
        if (num < 1) {
            return;
        }
        MediaTableEntry lastEntry = firstEntry = (MediaTableEntry)entryList.get(0);
        for (int i = 1; i < num; ++i) {
            MediaTableEntry entry;
            lastEntry.next = entry = (MediaTableEntry)entryList.get(i);
            lastEntry = entry;
        }
        lastEntry.next = null;
        if (this.last == null) {
            this.first = firstEntry;
        } else {
            this.last.next = firstEntry;
        }
        this.last = lastEntry;
        this.size += num;
    }

    public int getSize() {
        return this.size;
    }

    public int getLimit() {
        return this.limit;
    }

    public long getTotal() {
        return this.total;
    }

    public String toString() {
        return super.toString() + "[size=" + this.size + ", limit=" + this.limit + ", total=" + this.total + "]";
    }
}

