/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.AbstractExecution;
import com.spacekiller.util.Execution;
import com.spacekiller.util.ExecutionManager;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.manager.MediaTableEntry;
import java.awt.Component;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class MediaTableEntryScanner
implements Runnable {
    private static final Logger logger = Logger.getLogger(MediaTableEntryScanner.class.getName());
    private final MediaLibrary library;
    private final List entryList;
    private final Component tableComponent;
    private int flags;
    private int batch;
    protected volatile double currentProgress;
    protected volatile Resource currentMediaResource;
    private boolean active;
    private volatile boolean cancel;
    protected final EntryUpdater entryUpdater = new EntryUpdater();
    protected volatile boolean entryUpdaterPending;

    public MediaTableEntryScanner(MediaLibrary library, List entryList, Component tableComponent, int flags, int batch) {
        this.library = library;
        this.entryList = entryList;
        this.tableComponent = tableComponent;
        this.flags = flags;
        this.batch = batch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MediaTableEntryScanner mediaTableEntryScanner;
        MediaScannerExecution mediaScannerExecution = null;
        ExecutionManager executionManager = null;
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("MediaScanner started: " + Thread.currentThread());
            }
            this.currentProgress = 0.0;
            executionManager = Platform.getInstance().getExecutionManager();
            if (executionManager != null) {
                mediaScannerExecution = new MediaScannerExecution();
                executionManager.addExecution((Execution)mediaScannerExecution);
                mediaScannerExecution.mediaScannerStarted();
            }
            mediaTableEntryScanner = this;
            synchronized (mediaTableEntryScanner) {
                this.active = true;
            }
            if (this.cancel) {
                return;
            }
            this.loadMediaEntries();
        }
        finally {
            mediaTableEntryScanner = this;
            synchronized (mediaTableEntryScanner) {
                this.active = false;
                this.currentMediaResource = null;
                this.notifyAll();
            }
            this.currentProgress = 1.0;
            if (mediaScannerExecution != null) {
                mediaScannerExecution.mediaScannerStopped();
                if (executionManager != null) {
                    executionManager.removeExecution((Execution)mediaScannerExecution);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                if (this.cancel) {
                    logger.fine("MediaScanner cancelled: " + Thread.currentThread());
                } else {
                    logger.fine("MediaScanner completed: " + Thread.currentThread());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMediaEntries() {
        long lastFireTime = System.currentTimeMillis();
        try {
            int count = this.entryList.size();
            if (count < 1) {
                return;
            }
            int index = 0;
            MediaEntryLoader mediaEntryLoader = new MediaEntryLoader(this.entryList);
            while (!this.cancel) {
                if (index >= count) {
                    break;
                }
                this.currentProgress = 1.0 * (double)index / (double)count;
                int len = Math.min(count - index, this.batch);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Loading media entry batch: index=" + index + ", count=" + len);
                }
                try {
                    mediaEntryLoader.reset(index, len);
                    this.library.getMediaEntries(this.entryList, index, len, this.flags, (Collection)mediaEntryLoader);
                    long time = System.currentTimeMillis();
                    if (time - lastFireTime > 1000L) {
                        if (!this.entryUpdaterPending) {
                            this.entryUpdaterPending = true;
                            SwingUtilities.invokeLater(this.entryUpdater);
                        }
                        lastFireTime = time;
                    }
                }
                finally {
                    index += len;
                }
                Thread.yield();
            }
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            this.currentProgress = 1.0;
            this.currentMediaResource = null;
            SwingUtilities.invokeLater(this.entryUpdater);
        }
    }

    public void cancel() {
        this.cancel = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        MediaTableEntryScanner mediaTableEntryScanner = this;
        synchronized (mediaTableEntryScanner) {
            while (this.active) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    protected class MediaEntryLoader
    extends AbstractCollection {
        private List crateEntryList;
        private int off;
        private int end;

        public MediaEntryLoader(List crateEntryList) {
            this.crateEntryList = crateEntryList;
        }

        public void reset(int off, int len) {
            this.off = off;
            this.end = off + len;
        }

        @Override
        public boolean add(Object e) {
            if (this.off < this.end) {
                MediaTableEntry mte = (MediaTableEntry)this.crateEntryList.get(this.off++);
                mte.setMediaEntry((MediaEntry)e);
                MediaTableEntryScanner.this.currentMediaResource = mte.getResource();
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator iterator() {
            throw new UnsupportedOperationException();
        }
    }

    protected class MediaScannerExecution
    extends AbstractExecution {
        public MediaScannerExecution() {
            this.setName("Media Scanner");
            this.setStopSupported(true);
            this.setPauseSupported(false);
            this.setDaemon(true);
        }

        protected void execute() throws Exception {
        }

        public void stop() {
            super.stop();
            MediaTableEntryScanner.this.cancel();
        }

        public double getProgress() {
            return MediaTableEntryScanner.this.currentProgress;
        }

        public String getDescription() {
            Resource res = MediaTableEntryScanner.this.currentMediaResource;
            if (res != null) {
                return "Scanning: " + res;
            }
            return null;
        }

        protected void mediaScannerStarted() {
            this.setStartMillis(System.currentTimeMillis());
            this.setRunning(true);
            this.fireExecutionStarted();
        }

        protected void mediaScannerStopped() {
            this.setRunning(false);
            this.fireExecutionStopped();
        }
    }

    protected class EntryUpdater
    implements Runnable {
        protected EntryUpdater() {
        }

        @Override
        public void run() {
            MediaTableEntryScanner.this.entryUpdaterPending = false;
            MediaTableEntryScanner.this.tableComponent.validate();
            MediaTableEntryScanner.this.tableComponent.repaint();
        }
    }
}

