/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.manager.MediaTableEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class MediaTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -8504918577237385401L;
    private List rows = new ArrayList();
    private MediaTableEntry activeEntry;

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.rows.get(rowIndex);
    }

    public MediaTableEntry getEntryAt(int rowIndex) {
        return (MediaTableEntry)this.rows.get(rowIndex);
    }

    public int getEntryIndex(Resource resource) {
        if (resource != null) {
            int num = this.rows.size();
            for (int i = 0; i < num; ++i) {
                MediaTableEntry mte = (MediaTableEntry)this.rows.get(i);
                if (!resource.equals(mte.getResource())) continue;
                return i;
            }
        }
        return -1;
    }

    public void insertEntryAt(int rowIndex, MediaTableEntry entry) {
        this.rows.add(rowIndex, entry);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public void insertEntryInterval(int rowIndex, MediaTableEntry[] entries, int off, int len) {
        int firstIndex = rowIndex;
        for (int i = 0; i < len; ++i) {
            MediaTableEntry entry = entries[off++];
            this.rows.add(rowIndex++, entry);
        }
        if (rowIndex > firstIndex) {
            this.fireTableRowsInserted(firstIndex, rowIndex - 1);
        }
    }

    public void insertEntryInterval(int rowIndex, Collection entries) {
        int lastIndex = rowIndex + entries.size() - 1;
        if (lastIndex < rowIndex) {
            return;
        }
        this.rows.addAll(rowIndex, entries);
        this.fireTableRowsInserted(rowIndex, lastIndex);
    }

    public void removeEntryAt(int rowIndex) {
        this.rows.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public int removeEntry(MediaTableEntry entry) {
        int index = this.rows.indexOf(entry);
        if (index < 0) {
            return -1;
        }
        this.removeEntryAt(index);
        return index;
    }

    public void removeEntryInterval(int firstRow, int lastRow) {
        for (int i = lastRow - 1; i >= firstRow; --i) {
            this.rows.remove(i);
        }
        this.fireTableRowsDeleted(firstRow, lastRow);
    }

    public void removeAllEntries() {
        int num = this.rows.size();
        if (num < 1) {
            return;
        }
        this.rows.clear();
        this.fireTableRowsDeleted(0, num - 1);
    }

    public MediaTableEntry updateEntryAt(int rowIndex, MediaTableEntry entry) {
        MediaTableEntry old = this.rows.set(rowIndex, entry);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
        return old;
    }

    public boolean isActiveEntry(MediaTableEntry entry) {
        return entry == this.activeEntry;
    }

    public MediaTableEntry getActiveEntry() {
        return this.activeEntry;
    }

    public void setActiveEntry(MediaTableEntry activeEntry) {
        this.activeEntry = activeEntry;
    }
}

