/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.DesktopManager;
import com.spacekiller.util.FileLocator;
import com.spacekiller.util.FileResource;
import com.spacekiller.util.Filter;
import com.spacekiller.util.Platform;
import com.spacekiller.util.Resource;
import com.spacekiller.util.Tools;
import com.spacekiller.util.URIResource;
import com.spacekiller.util.URLResource;
import com.spacekiller.util.beans.AbstractSelection;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.BeanProperty;
import com.spacekiller.util.beans.ClipSource;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.Property;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.media.DefaultMediaCrateEntry;
import com.spacekiller.util.media.DirectoryMediaCrate;
import com.spacekiller.util.media.EntryOrder;
import com.spacekiller.util.media.MediaAnalyzer;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.MediaPlayerContext;
import com.spacekiller.util.media.MediaResource;
import com.spacekiller.util.media.MutableMediaCrate;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.analyzer.duplicate.DuplicateDetectorImpl;
import com.spacekiller.util.media.analyzer.duplicate.DuplicateDetectorOptions;
import com.spacekiller.util.media.analyzer.duplicate.DuplicateDetectorPanel;
import com.spacekiller.util.media.library.BaseMediaContext;
import com.spacekiller.util.media.library.remote.RemoteMediaResourcePanel;
import com.spacekiller.util.media.manager.AbstractEntryPropertiesPanel;
import com.spacekiller.util.media.manager.AdvancedMediaFilter;
import com.spacekiller.util.media.manager.AdvancedSearchOptions;
import com.spacekiller.util.media.manager.AdvancedSearchPanel;
import com.spacekiller.util.media.manager.AudioEntryPropertiesPanel;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.EntryTableHeaderRenderer;
import com.spacekiller.util.media.manager.EntryTableSortModel;
import com.spacekiller.util.media.manager.MediaEntryDetailsPanel;
import com.spacekiller.util.media.manager.MediaEntryOverviewPanel;
import com.spacekiller.util.media.manager.MediaEntryTabbedPanel;
import com.spacekiller.util.media.manager.MediaManagerPanel;
import com.spacekiller.util.media.manager.MediaManagerPlugin;
import com.spacekiller.util.media.manager.MediaMarkerPropertiesPanel;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.media.manager.MediaTableEntryAnalyzer;
import com.spacekiller.util.media.manager.MediaTableEntryPool;
import com.spacekiller.util.media.manager.MediaTableEntryScanner;
import com.spacekiller.util.media.manager.MediaTableModel;
import com.spacekiller.util.media.manager.MediaTableToolContext;
import com.spacekiller.util.media.manager.MediaTableView;
import com.spacekiller.util.media.manager.MultiAndFilter;
import com.spacekiller.util.media.manager.NormalEntryOrder;
import com.spacekiller.util.media.manager.PictureEntryPropertiesPanel;
import com.spacekiller.util.media.manager.RegexSearchFilter;
import com.spacekiller.util.media.manager.ShuffledEntryOrder;
import com.spacekiller.util.media.manager.SubStringSearchFilter;
import com.spacekiller.util.media.manager.column.EntryAlbumArtistTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryAlbumTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryArtistTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryBitDepthTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryBitRateTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryBpmTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryChannelsTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryCodecTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryCorruptedTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryDurationTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryExistingTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryFileSizeTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryFirstScannedTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryFormatTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryFrameRateTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryGenreTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryImageAlphaTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryImageHeightTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryImageWidthTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryInfiniteTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryLastModifiedTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryMarkersTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryMaxAmplitudeTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryMinAmplitudeTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryNormalizedTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryPeakRmsTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryResourceTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryRmsTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryTitleTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryTrackNumberTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryUserCommentTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryUserRatingTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryYearTableColumnProvider;
import com.spacekiller.util.media.manager.column.EntryZeroCrossingsTableColumnProvider;
import com.spacekiller.util.swing.SwingTools;
import com.spacekiller.util.table.TableColumnProvider;
import com.spacekiller.util.table.TableViewPanel;
import com.spacekiller.util.thread.ThreadPool;
import com.spacekiller.util.tooling.AbstractToolContext;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.workbench.AbstractSelectionManager;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.SelectionCondition;
import com.spacekiller.util.workbench.SelectionManager;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewFocusCondition;
import com.spacekiller.util.workbench.Workbench;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextSupport;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class MediaTableViewPanel
extends TableViewPanel {
    private static final long serialVersionUID = -6161740735778503844L;
    private static final Logger logger = Logger.getLogger(MediaTableViewPanel.class.getName());
    public static final String PROPERTY_ENTRY_SELECTED = "entrySelected";
    public static final String PROPERTY_SINGLE_ENTRY_SELECTED = "singleEntrySelected";
    public static final String PROPERTY_ENTRY_MOVE_DOWN_ENABLED = "entryMoveDownEnabled";
    public static final String PROPERTY_ENTRY_MOVE_UP_ENABLED = "entryMoveUpEnabled";
    private static final int TABLE_INIT_CAPACITY = 1024;
    private static final String KEY_COLUMN_COUNT = "columnCount";
    private static final String KEY_COLUMN_NAME_PREFIX = "columnName.";
    private static final String KEY_COLUMN_WIDTH_PREFIX = "columnWidth.";
    private static final String KEY_FIT_COLUMNS_TO_WINDOW = "fitColumnsToWindow";
    public static final int DEFAULT_SCANNER_FLAGS = 7;
    public static final int DEFAULT_SCANNER_BATCH = 32;
    private MediaLibrary mediaLibrary;
    private MediaPlayer[] mediaPlayers;
    private MediaPlayer mediaPlayer;
    private MediaPlayerContextImpl playerContext = new MediaPlayerContextImpl();
    private ActiveEntryRefresher activeEntryRefresher = new ActiveEntryRefresher();
    private NavigateCrateTree navigateCrateTree = new NavigateCrateTree();
    private NavigatePlayList navigatePlayList = new NavigatePlayList();
    private NavigateBack navigateBack = new NavigateBack();
    private NavigateMove navigateMove = new NavigateMove();
    private MediaTableView mediaTableView;
    private MediaTableToolContext mediaTableToolContext;
    private MediaManagerPanel mediaManagerPanel;
    private MediaTableEntryPool tableEntryPool;
    private ThreadPool workerThreadPool;
    private ThreadPool pictureThreadPool;
    private ThreadPool scannerThreadPool;
    private int scannerBatchSize;
    private MediaCrate[] loadedCrates;
    private Filter loadFilter;
    private Filter searchFilter;
    private Comparator entryComparator;
    private EntryTableSortModel tableSortModel;
    private List loadedEntryList;
    private List filterEntryList;
    private MediaTableModel mediaTableModel;
    private MediaTableEntry activeEntry;
    private int activeRow = -1;
    private boolean followActiveEntry = true;
    private MediaTableEntry[] tableLoadArray;
    private MediaTableEntryScanner crateEntryScanner;
    private final Refresher refresher = new Refresher(false);
    private final Scanner scanner = new Scanner(null, 7, 32);
    private MediaTableEntryAnalyzer crateEntryAnalyzer;
    private boolean entrySelected;
    private boolean singleEntrySelected;
    private boolean entryMoveUpEnabled;
    private boolean entryMoveDownEnabled;
    private ActionListener entryActionListener;
    private List tableColumnProviders = new ArrayList();
    private List enabledColumnProviders = new ArrayList();
    private SelectionManager selectionManager;
    private SelectionImpl selection;
    private BeansToolkit beansToolkit;
    private ClipboardManager clipboardManager;
    private BeanDropSupport beanDropSupport;
    private UndoManager undoManager;
    private String simpleSearchText;
    private AdvancedSearchOptions advancedSearchOptions;
    private AdvancedSearchPanel advancedSearchPanel;
    private JDialog advancedSearchDialog;
    private ToolGroup showHideColumnMenuGroup;
    private Font normalFont;
    private Font activeFont;
    private boolean fitColumnsToWindow = true;
    private DuplicateDetectorOptions duplicateDetectorOptions;
    private JDialog entryPropertiesDialog;
    private MediaEntryTabbedPanel mediaEntryPropertiesPanel;
    private MediaEntryOverviewPanel mediaEntryOverviewPanel;
    private AudioEntryPropertiesPanel audioEntryPropertiesPanel;
    private PictureEntryPropertiesPanel pictureEntryPropertiesPanel;
    private MediaMarkerPropertiesPanel mediaMarkerPropertiesPanel;
    private MediaEntryDetailsPanel mediaEntryDetailsPanel;

    public MediaTableViewPanel() {
        this.tableLoadArray = new MediaTableEntry[256];
        this.initMediaTableViewPanel();
    }

    public synchronized void addTableColumnProvider(TableColumnProvider tcp) {
        if (tcp == null) {
            return;
        }
        this.tableColumnProviders.add(tcp);
    }

    public synchronized void removeTableColumnProvider(TableColumnProvider tcp) {
        this.tableColumnProviders.remove(tcp);
    }

    public synchronized void removeAllTableColumnProviders() {
        this.tableColumnProviders.clear();
    }

    protected void initMediaTableViewPanel() {
        this.activeFont = this.normalFont = this.getFont();
        this.layoutResultToFitWindow();
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.tableSortModel = new EntryTableSortModel();
        this.loadedEntryList = new ArrayList(1024);
        this.filterEntryList = new ArrayList(1024);
        this.mediaTableModel = new MediaTableModel();
        this.setEntryActionListener(new DefaultEntryActionHandler());
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                MediaTableViewPanel.this.handleEntrySelectionChanged();
            }
        });
        DropTargetHandler dropTargetHandler = new DropTargetHandler();
        this.setDropTarget(new DropTarget((Component)((Object)this), dropTargetHandler));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MediaTableViewPanel.this.handleEntryActionPerformed();
            }
        });
        this.addHeaderActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source != null && source instanceof TableColumn) {
                    TableColumn column = (TableColumn)source;
                    MediaTableViewPanel.this.handleTableColumnHeaderActionPerformed(column);
                }
            }
        });
        this.setAutoCreateColumnModel(false);
        this.getJTable().setColumnModel(new DefaultTableColumnModel());
        EntryTableColumnProvider[] defaultColumnProviders = new EntryTableColumnProvider[]{new EntryTitleTableColumnProvider(), new EntryAlbumTableColumnProvider(), new EntryArtistTableColumnProvider(), new EntryDurationTableColumnProvider(), new EntryBpmTableColumnProvider()};
        for (int i = 0; i < defaultColumnProviders.length; ++i) {
            EntryTableColumnProvider tcp = defaultColumnProviders[i];
            if (tcp == null) continue;
            this.addTableColumnProvider(tcp);
            this.setColumnProviderEnabled(tcp, true);
        }
        EntryTableColumnProvider[] optionalColumnProviders = new EntryTableColumnProvider[]{new EntryAlbumArtistTableColumnProvider(), new EntryTrackNumberTableColumnProvider(), new EntryGenreTableColumnProvider(), new EntryYearTableColumnProvider(), new EntryFormatTableColumnProvider(), new EntryResourceTableColumnProvider(), new EntryExistingTableColumnProvider(), new EntryFileSizeTableColumnProvider(), new EntryLastModifiedTableColumnProvider(), new EntryFirstScannedTableColumnProvider(), new EntryCorruptedTableColumnProvider(), new EntryInfiniteTableColumnProvider(), new EntryUserRatingTableColumnProvider(), new EntryUserCommentTableColumnProvider(), new EntryMarkersTableColumnProvider(), new EntryRmsTableColumnProvider(), new EntryPeakRmsTableColumnProvider(), new EntryCodecTableColumnProvider(), new EntryChannelsTableColumnProvider(), new EntryFrameRateTableColumnProvider(), new EntryBitDepthTableColumnProvider(), new EntryBitRateTableColumnProvider(), new EntryZeroCrossingsTableColumnProvider(), new EntryMinAmplitudeTableColumnProvider(), new EntryMaxAmplitudeTableColumnProvider(), new EntryNormalizedTableColumnProvider(), new EntryImageWidthTableColumnProvider(), new EntryImageHeightTableColumnProvider(), new EntryImageAlphaTableColumnProvider()};
        for (int i = 0; i < optionalColumnProviders.length; ++i) {
            EntryTableColumnProvider tcp = optionalColumnProviders[i];
            if (tcp == null) continue;
            this.addTableColumnProvider(tcp);
        }
        this.initActionMap();
        this.initInputMap();
        this.setTableModel(this.mediaTableModel);
    }

    protected void initActionMap() {
        ActionMap actionMap = this.getJTable().getActionMap();
        if (actionMap == null) {
            return;
        }
        actionMap.put("enter", new EnterAction());
        actionMap.put("space", new SpaceAction());
        actionMap.put("delete", new DeleteAction());
        actionMap.put("controlDelete", new ControlDeleteAction());
        actionMap.put("copy", new CopyAction());
        actionMap.put("cut", new CutAction());
        actionMap.put("paste", new PasteAction());
        actionMap.put("undo", new UndoAction());
        actionMap.put("redo", new RedoAction());
        actionMap.put("moveUp", new MoveUpAction());
        actionMap.put("moveDown", new MoveDownAction());
        actionMap.put("tabForward", new TabForwardAction());
        actionMap.put("tabBackward", new TabBackwardAction());
    }

    protected void initInputMap() {
        InputMap inputMap = this.getJTable().getInputMap(1);
        if (inputMap == null) {
            return;
        }
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "enter");
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "space");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "delete");
        inputMap.put(KeyStroke.getKeyStroke(127, 128), "controlDelete");
        inputMap.put(KeyStroke.getKeyStroke(67, 128), "copy");
        inputMap.put(KeyStroke.getKeyStroke(88, 128), "cut");
        inputMap.put(KeyStroke.getKeyStroke(86, 128), "paste");
        inputMap.put(KeyStroke.getKeyStroke(90, 128), "undo");
        inputMap.put(KeyStroke.getKeyStroke(89, 128), "redo");
        inputMap.put(KeyStroke.getKeyStroke(38, 128), "moveUp");
        inputMap.put(KeyStroke.getKeyStroke(40, 128), "moveDown");
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "tabForward");
        inputMap.put(KeyStroke.getKeyStroke(9, 64), "tabBackward");
    }

    public ToolGroup getShowHideColumnMenuGroup() {
        return this.showHideColumnMenuGroup;
    }

    public void setShowHideColumnMenuGroup(ToolGroup showHideColumnMenuGroup) {
        this.showHideColumnMenuGroup = showHideColumnMenuGroup;
    }

    public synchronized boolean isColumnProviderEnabled(EntryTableColumnProvider provider) {
        return this.enabledColumnProviders.contains(provider);
    }

    public synchronized TableColumn setColumnProviderEnabled(EntryTableColumnProvider provider, boolean enabled) {
        TableColumn col = null;
        if (enabled) {
            if (this.enabledColumnProviders.contains(provider)) {
                return null;
            }
            if (!this.enabledColumnProviders.add(provider)) {
                return null;
            }
            col = this.addTableColumn(provider);
        } else {
            if (!this.enabledColumnProviders.remove(provider)) {
                return null;
            }
            col = this.removeTableColumn(provider);
        }
        ToolGroup columnMenuGroup = this.showHideColumnMenuGroup;
        if (columnMenuGroup != null) {
            columnMenuGroup.refresh();
        }
        return col;
    }

    protected TableColumn addTableColumn(EntryTableColumnProvider tcp) {
        if (tcp == null) {
            return null;
        }
        TableModel tableModel = this.getJTable().getModel();
        TableColumnModel columnModel = this.getJTable().getColumnModel();
        TableColumn col = tcp.createTableColumn(tableModel);
        if (col == null) {
            return null;
        }
        col.setHeaderRenderer(new EntryTableHeaderRenderer(this.tableSortModel, tcp));
        this.applyTableColumnFont(col);
        columnModel.addColumn(col);
        return col;
    }

    protected TableColumn removeTableColumn(EntryTableColumnProvider tcp) {
        if (tcp == null) {
            return null;
        }
        Object headerValue = tcp.getHeaderValue();
        if (headerValue == null) {
            return null;
        }
        TableColumnModel columnModel = this.getJTable().getColumnModel();
        int num = columnModel.getColumnCount();
        if (num <= 1) {
            return null;
        }
        for (int i = 0; i < num; ++i) {
            TableColumn column = columnModel.getColumn(i);
            if (!headerValue.equals(column.getHeaderValue())) continue;
            columnModel.removeColumn(column);
            return column;
        }
        return null;
    }

    protected JTable getMediaEntryTable() {
        return super.getJTable();
    }

    public MediaLibrary getMediaLibrary() {
        return this.mediaLibrary;
    }

    public void setMediaLibrary(MediaLibrary mediaLibrary) {
        this.mediaLibrary = mediaLibrary;
    }

    public MediaTableView getMediaTableView() {
        return this.mediaTableView;
    }

    public void setMediaTableView(MediaTableView mediaTableView) {
        this.mediaTableView = mediaTableView;
    }

    public ThreadPool getWorkerThreadPool() {
        return this.workerThreadPool;
    }

    public void setWorkerThreadPool(ThreadPool workerThreadPool) {
        this.workerThreadPool = workerThreadPool;
    }

    public ThreadPool getScannerThreadPool() {
        return this.scannerThreadPool;
    }

    public void setScannerThreadPool(ThreadPool scannerThreadPool) {
        this.scannerThreadPool = scannerThreadPool;
    }

    public int getScannerBatchSize() {
        return this.scannerBatchSize;
    }

    public void setScannerBatchSize(int scannerBatchSize) {
        this.scannerBatchSize = scannerBatchSize;
    }

    public MediaTableEntryPool getTableEntryPool() {
        return this.tableEntryPool;
    }

    public void setTableEntryPool(MediaTableEntryPool tableEntryPool) {
        this.tableEntryPool = tableEntryPool;
    }

    protected SelectionManager createSelectionManager() {
        SelectionManagerImpl impl = new SelectionManagerImpl();
        impl.setSelection((Selection)this.getSelection());
        return impl;
    }

    public SelectionManager getSelectionManager() {
        if (this.selectionManager == null) {
            this.setSelectionManager(this.createSelectionManager());
        }
        return this.selectionManager;
    }

    protected void setSelectionManager(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public SelectionImpl getSelection() {
        if (this.selection == null) {
            this.setSelection(this.createSelection());
        }
        return this.selection;
    }

    protected void setSelection(SelectionImpl selection) {
        this.selection = selection;
    }

    protected SelectionImpl createSelection() {
        return new SelectionImpl((Object)this);
    }

    public MediaTableToolContext getMediaTableToolContext() {
        if (this.mediaTableToolContext == null) {
            this.setMediaTableToolContext(this.createMediaTableToolContext());
        }
        return this.mediaTableToolContext;
    }

    protected void setMediaTableToolContext(MediaTableToolContext mediaTableToolContext) {
        this.mediaTableToolContext = mediaTableToolContext;
    }

    protected MediaTableToolContext createMediaTableToolContext() {
        return new ToolContextImpl();
    }

    public void copySelectedPathsToClipboard() {
        try {
            ClipboardManager cm = this.clipboardManager;
            if (cm == null) {
                return;
            }
            String newLine = System.getProperty("line.separator");
            if (newLine == null || newLine.length() < 1) {
                newLine = "\n";
            }
            StringBuffer sb = new StringBuffer();
            int[] rows = this.getSelectedRows();
            if (rows != null) {
                int num = rows.length;
                for (int i = 0; i < num; ++i) {
                    Resource res;
                    int row;
                    MediaTableEntry entry;
                    if (i > 0) {
                        sb.append(newLine);
                    }
                    if ((entry = this.getMediaTableEntryAt(row = rows[i])) == null || (res = entry.getResource()) == null) continue;
                    sb.append(String.valueOf(res));
                }
            }
            String paths = sb.toString();
            StringSelection transferable = new StringSelection(paths);
            ClipboardOwner clipOwner = new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            };
            cm.setContents((Transferable)transferable, clipOwner);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void openSelectedFileLocation() {
        try {
            File dir;
            File file;
            int[] rows = this.getSelectedRows();
            if (rows.length != 1) {
                return;
            }
            int row = rows[0];
            MediaTableEntry entry = this.getMediaTableEntryAt(row);
            if (entry == null) {
                return;
            }
            Resource resource = entry.getResource();
            if (resource == null) {
                return;
            }
            if (resource.isFile() && (file = resource.getFile()) != null && (dir = file.getParentFile()) != null && dir.isDirectory()) {
                DesktopManager desktopManager = Platform.getInstance().getDesktopManager();
                if (desktopManager != null) {
                    if (desktopManager.isDesktopSupported()) {
                        if (logger.isLoggable(Level.INFO)) {
                            logger.info("Opening directory location: " + dir);
                        }
                        desktopManager.open(dir);
                    } else if (logger.isLoggable(Level.INFO)) {
                        logger.info("Desktop is not supported.");
                    }
                } else if (logger.isLoggable(Level.INFO)) {
                    logger.info("DesktopManager is not available.");
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected MediaTableEntry getMediaTableEntryAt(int row) {
        int rows = this.mediaTableModel.getRowCount();
        if (row < 0 || row >= rows) {
            return null;
        }
        return this.mediaTableModel.getEntryAt(row);
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public ClipboardManager getClipboardManager() {
        return this.clipboardManager;
    }

    public void setClipboardManager(ClipboardManager clipboardManager) {
        this.clipboardManager = clipboardManager;
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    protected void handleEntryActionPerformed() {
        ActionListener listener = this.getEntryActionListener();
        if (listener == null) {
            return;
        }
        listener.actionPerformed(new ActionEvent((Object)this, 0, "action"));
    }

    protected void handleEntrySelectionChanged() {
        int[] rows;
        int num;
        ListSelectionModel selModel = this.getSelectionModel();
        if (selModel.isSelectionEmpty()) {
            this.setEntrySelected(false);
            this.setSingleEntrySelected(false);
            this.setEntryMoveUpEnabled(false);
            this.setEntryMoveDownEnabled(false);
        } else {
            MediaTableEntry mte;
            MediaCrate leadCrate;
            int leadIndex;
            this.setEntrySelected(true);
            int min = selModel.getMinSelectionIndex();
            int max = selModel.getMaxSelectionIndex();
            this.setSingleEntrySelected(min == max);
            int totalRows = this.filterEntryList.size();
            boolean moveEnabled = false;
            if (this.entryComparator == null && (this.searchFilter == null || this.filterEntryList.size() == this.loadedEntryList.size()) && (leadIndex = selModel.getLeadSelectionIndex()) >= 0 && (leadCrate = (mte = (MediaTableEntry)this.filterEntryList.get(leadIndex)).getCrate()) != null && leadCrate instanceof MutableMediaCrate) {
                moveEnabled = true;
            }
            this.setEntryMoveUpEnabled(moveEnabled && min > 0);
            this.setEntryMoveDownEnabled(moveEnabled && max >= 0 && max < totalRows - 1);
        }
        JDialog propsDialog = this.entryPropertiesDialog;
        if (propsDialog != null && propsDialog.isShowing()) {
            this.refreshEntryPropertiesPanel();
        }
        if ((num = (rows = this.getSelectedRows()).length) < 1) {
            this.getSelection().entrySelectionChanged(null);
        } else {
            MediaCrateEntry[] entries = new MediaCrateEntry[num];
            for (int i = 0; i < num; ++i) {
                entries[i] = this.getMediaTableEntryAt(rows[i]);
            }
            this.getSelection().entrySelectionChanged(entries);
        }
    }

    public boolean isEntrySelected() {
        return this.entrySelected;
    }

    protected synchronized void setEntrySelected(boolean entrySelected) {
        if (this.entrySelected == entrySelected) {
            return;
        }
        this.entrySelected = entrySelected;
        this.firePropertyChange(PROPERTY_ENTRY_SELECTED, !entrySelected, entrySelected);
    }

    public boolean isSingleEntrySelected() {
        return this.singleEntrySelected;
    }

    protected synchronized void setSingleEntrySelected(boolean singleEntrySelected) {
        if (this.singleEntrySelected == singleEntrySelected) {
            return;
        }
        this.singleEntrySelected = singleEntrySelected;
        this.firePropertyChange(PROPERTY_SINGLE_ENTRY_SELECTED, !singleEntrySelected, singleEntrySelected);
    }

    public boolean isEntryMoveUpEnabled() {
        return this.entryMoveUpEnabled;
    }

    protected synchronized void setEntryMoveUpEnabled(boolean entryMoveUpEnabled) {
        if (this.entryMoveUpEnabled == entryMoveUpEnabled) {
            return;
        }
        this.entryMoveUpEnabled = entryMoveUpEnabled;
        this.firePropertyChange(PROPERTY_ENTRY_MOVE_UP_ENABLED, !entryMoveUpEnabled, entryMoveUpEnabled);
    }

    public boolean isEntryMoveDownEnabled() {
        return this.entryMoveDownEnabled;
    }

    protected synchronized void setEntryMoveDownEnabled(boolean entryMoveDownEnabled) {
        if (this.entryMoveDownEnabled == entryMoveDownEnabled) {
            return;
        }
        this.entryMoveDownEnabled = entryMoveDownEnabled;
        this.firePropertyChange(PROPERTY_ENTRY_MOVE_DOWN_ENABLED, !entryMoveDownEnabled, entryMoveDownEnabled);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public synchronized int removeSelectedEntries(boolean prompt) {
        int[] rows = this.getSelectedRows();
        if (rows.length < 1) {
            return 0;
        }
        LinkedList<EntryChange> changeList = new LinkedList<EntryChange>();
        int count = rows.length;
        int directoryCount = 0;
        int immutableCount = 0;
        for (int i = 0; i < count; ++i) {
            MediaCrate mc;
            MediaCrateEntry mce;
            int filterRow = rows[i];
            MediaTableEntry mte = this.getMediaTableEntryAt(filterRow);
            if (mte == null || (mce = mte.getCrateEntry()) == null || (mc = mte.getCrate()) == null) continue;
            if (mc instanceof DirectoryMediaCrate) {
                ++directoryCount;
                continue;
            }
            if (mc instanceof MutableMediaCrate) {
                int index;
                MutableMediaCrate mmc = (MutableMediaCrate)mc;
                int loadedRow = this.loadedEntryList.indexOf(mte);
                if (loadedRow < 0 || (index = mmc.getEntryIndex(mce)) < 0) continue;
                changeList.add(new EntryChange(mte, mmc, index, loadedRow));
                continue;
            }
            ++immutableCount;
        }
        if (directoryCount > 0 || immutableCount > 0) {
            String title = "Cannot Remove Entries";
            String message = "Cannot remove entries from an immutable directory crate !";
            int messageType = 2;
            JOptionPane.showMessageDialog((Component)((Object)this), message, title, messageType);
            return 0;
        }
        int entryCount = changeList.size();
        if (entryCount < 1) {
            return 0;
        }
        if (prompt) {
            int messageType;
            int optionType;
            String title = "Remove Entries ?";
            String message = "You are about to remove " + entryCount + " entries from the crate. Are you sure ?";
            int rc = JOptionPane.showConfirmDialog((Component)((Object)this), message, title, optionType = 2, messageType = 3);
            if (rc != 0) {
                return 0;
            }
        }
        EntryChange[] changeArray = changeList.toArray(new EntryChange[entryCount]);
        EntryRemoveEdit edit = new EntryRemoveEdit(changeArray);
        edit.execute();
        UndoManager um = this.getUndoManager();
        if (um != null) {
            um.addEdit(edit);
        }
        return entryCount;
    }

    public synchronized int cutSelectedEntries(boolean prompt) {
        this.copySelectedEntries();
        return this.removeSelectedEntries(prompt);
    }

    public synchronized int copySelectedEntries() {
        int[] rows = this.getSelectedRows();
        if (rows.length < 1) {
            return 0;
        }
        int num = rows.length;
        ArrayList<Serializable> beans = new ArrayList<Serializable>(num);
        for (int i = 0; i < num; ++i) {
            MediaTableEntry entry = this.mediaTableModel.getEntryAt(rows[i]);
            Resource resource = entry.getResource();
            if (resource == null) continue;
            if (resource instanceof FileResource) {
                beans.add(((FileResource)resource).getFile());
                continue;
            }
            if (resource instanceof URLResource) {
                beans.add(((URLResource)resource).getURL());
                continue;
            }
            if (resource instanceof URIResource) {
                beans.add(((URIResource)resource).getURI());
                continue;
            }
            if (!(resource instanceof MediaResource)) continue;
            beans.add((Serializable)resource);
        }
        if (beans.isEmpty()) {
            return 0;
        }
        ClipboardOwner clipOwner = new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        };
        ClipSourceImpl clipSource = new ClipSourceImpl();
        ClipboardManager cm = this.getClipboardManager();
        cm.setContents(beans, clipOwner, (ClipSource)clipSource);
        return beans.size();
    }

    protected MutableMediaCrate getTargetMediaCrate() {
        MediaCrate[] loaded = this.getLoadedCrates();
        int num = loaded == null ? 0 : loaded.length;
        for (int i = 0; i < num; ++i) {
            MediaCrate crate = loaded[i];
            if (crate == null || !(crate instanceof MutableMediaCrate)) continue;
            return (MutableMediaCrate)crate;
        }
        return null;
    }

    public synchronized int pasteEntries() {
        MediaTableEntry mte;
        ClipboardManager cm = this.getClipboardManager();
        if (cm == null) {
            return 0;
        }
        MutableMediaCrate target = null;
        int targetIndex = -1;
        int targetRow = -1;
        ListSelectionModel selModel = this.getJTable().getSelectionModel();
        int leadIndex = selModel.getLeadSelectionIndex();
        if (leadIndex >= 0 && !selModel.isSelectionEmpty() && (mte = this.getMediaTableEntryAt(leadIndex)) != null) {
            MediaCrate mc = mte.getCrate();
            MediaCrateEntry mce = mte.getCrateEntry();
            if (mce != null && mc != null && mc instanceof MutableMediaCrate) {
                target = (MutableMediaCrate)mc;
                targetIndex = target.getEntryIndex(mce);
                if (targetIndex >= 0) {
                    ++targetIndex;
                }
                if ((targetRow = this.loadedEntryList.indexOf(mte)) >= 0) {
                    ++targetRow;
                }
            }
        }
        if (target == null && (target = this.getTargetMediaCrate()) == null) {
            return 0;
        }
        if (targetIndex < 0) {
            targetIndex = target.getEntryCount();
            targetRow = this.loadedEntryList.size();
        }
        try {
            Collection beans = cm.getObjects();
            if (beans == null || beans.isEmpty()) {
                return 0;
            }
            return this.dropEntries(beans, target, targetIndex, targetRow);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return 0;
        }
    }

    protected synchronized int dropEntries(Collection beans, Point pos) {
        MediaTableEntry mte;
        if (beans == null || beans.isEmpty()) {
            return 0;
        }
        MutableMediaCrate target = null;
        int targetIndex = -1;
        int targetRow = -1;
        int leadIndex = this.getJTable().rowAtPoint(pos);
        if (leadIndex >= 0 && (mte = this.getMediaTableEntryAt(leadIndex)) != null) {
            MediaCrate mc = mte.getCrate();
            MediaCrateEntry mce = mte.getCrateEntry();
            if (mce != null && mc != null && mc instanceof MutableMediaCrate) {
                target = (MutableMediaCrate)mc;
                targetIndex = target.getEntryIndex(mce);
                targetRow = this.loadedEntryList.indexOf(mte);
            }
        }
        if (target == null && (target = this.getTargetMediaCrate()) == null) {
            return 0;
        }
        if (targetIndex < 0) {
            targetIndex = target.getEntryCount();
            targetRow = this.loadedEntryList.size();
        }
        try {
            return this.dropEntries(beans, target, targetIndex, targetRow);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return 0;
        }
    }

    public synchronized int dropEntries(Collection beans, MutableMediaCrate target, int targetIndex, int targetRow) {
        ArrayList resources = new ArrayList(beans.size());
        this.getResources(beans, resources);
        if (resources.isEmpty()) {
            return 0;
        }
        LinkedList<EntryChange> changeList = new LinkedList<EntryChange>();
        int num = resources.size();
        for (int i = 0; i < num; ++i) {
            Resource resource = (Resource)resources.get(i);
            DefaultMediaCrateEntry entry = new DefaultMediaCrateEntry((MediaCrate)target, resource);
            MediaTableEntry mte = this.tableEntryPool.getEntry((MediaCrateEntry)entry);
            changeList.add(new EntryChange(mte, target, targetIndex++, targetRow++));
        }
        int changeCount = changeList.size();
        if (changeCount < 1) {
            return 0;
        }
        EntryChange[] changeArray = changeList.toArray(new EntryChange[changeCount]);
        EntryInsertEdit edit = new EntryInsertEdit(changeArray);
        edit.execute();
        UndoManager um = this.getUndoManager();
        if (um != null) {
            um.addEdit(edit);
        }
        return num;
    }

    protected void getResources(Collection beans, List dstResources) {
        for (Object bean : beans) {
            if (bean == null) continue;
            if (bean instanceof Resource) {
                dstResources.add((Resource)bean);
                continue;
            }
            if (bean instanceof File) {
                File file = (File)bean;
                if (file.isDirectory()) {
                    this.getFileResources(file, dstResources, new HashSet());
                    continue;
                }
                dstResources.add(new FileResource(file));
                continue;
            }
            if (bean instanceof URL) {
                dstResources.add(new URLResource((URL)bean));
                continue;
            }
            if (bean instanceof URI) {
                dstResources.add(new URIResource((URI)bean));
                continue;
            }
            if (bean instanceof Collection) {
                this.getResources((Collection)bean, dstResources);
                continue;
            }
            logger.warning("Unsupported bean: " + bean.getClass() + " => " + bean);
        }
    }

    protected void getFileResources(File dir, List dstResources, Set doneDirs) {
        if (!doneDirs.add(dir)) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        int num = files.length;
        DefaultMediaCrateEntry mce = new DefaultMediaCrateEntry(null, null);
        Filter filter = this.loadFilter;
        for (int i = 0; i < num; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                this.getFileResources(f, dstResources, doneDirs);
                continue;
            }
            FileResource res = new FileResource(f);
            if (filter != null) {
                mce.setResource((Resource)res);
                if (!filter.accept((Object)mce)) continue;
            }
            dstResources.add(res);
        }
    }

    public MediaManagerPanel getMediaManagerPanel() {
        return this.mediaManagerPanel;
    }

    public void setMediaManagerPanel(MediaManagerPanel mediaManagerPanel) {
        this.mediaManagerPanel = mediaManagerPanel;
    }

    protected void setSelectedEntries(int[] modelRows, int off, int len) {
        this.setSelectedRows(modelRows);
        if (len < 1) {
            return;
        }
        int end = off + len;
        int lastSubRow = -1;
        for (int i = end - 1; i >= off && (lastSubRow = modelRows[i]) < 0; --i) {
        }
        if (lastSubRow >= 0) {
            this.scrollRowToVisible(lastSubRow);
        }
        int firstSubRow = -1;
        for (int i = off; i < end && (firstSubRow = modelRows[i]) < 0; ++i) {
        }
        if (firstSubRow >= 0) {
            this.scrollRowToVisible(firstSubRow);
        }
    }

    public ActionListener getEntryActionListener() {
        return this.entryActionListener;
    }

    public void setEntryActionListener(ActionListener entryActionListener) {
        this.entryActionListener = entryActionListener;
    }

    public MediaTableModel getMediaTableModel() {
        return this.mediaTableModel;
    }

    protected void setMediaTableModel(MediaTableModel mediaTableModel) {
        this.mediaTableModel = mediaTableModel;
    }

    public int getLoadedEntryCount() {
        return this.loadedEntryList.size();
    }

    public int getFilterEntryCount() {
        return this.filterEntryList.size();
    }

    protected boolean isLoadedCrate(MediaCrate crate) {
        MediaCrate[] arr = this.loadedCrates;
        if (arr == null) {
            return false;
        }
        int num = arr.length;
        while (crate != null) {
            for (int i = 0; i < num; ++i) {
                if (arr[i] != crate) continue;
                return true;
            }
            crate = crate.getParent();
        }
        return false;
    }

    protected MediaCrate[] getLoadedCrates() {
        return this.loadedCrates;
    }

    protected synchronized void setLoadedCrates(MediaCrate[] loadedCrates) {
        this.mediaTableModel.removeAllEntries();
        this.tableEntryPool.recycle(this.loadedEntryList);
        this.loadedEntryList.clear();
        this.filterEntryList.clear();
        this.loadedCrates = loadedCrates;
        this.mediaManagerPanel.updateEntryCount();
    }

    public synchronized void loadEntries(List entryList) {
        int num = entryList.size();
        if (num > this.tableLoadArray.length) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Increasing tableLoadArray size: " + this.tableLoadArray.length + " => " + num);
            }
            this.tableLoadArray = new MediaTableEntry[num];
        }
        Filter searchFilter = this.searchFilter;
        int insertCount = 0;
        for (int i = 0; i < num; ++i) {
            MediaCrateEntry crateEntry = (MediaCrateEntry)entryList.get(i);
            MediaTableEntry tableEntry = this.tableEntryPool.getEntry(crateEntry);
            this.loadedEntryList.add(tableEntry);
            if (searchFilter != null && !searchFilter.accept((Object)tableEntry)) continue;
            this.filterEntryList.add(tableEntry);
            this.tableLoadArray[insertCount++] = tableEntry;
        }
        if (insertCount > 0) {
            this.mediaTableModel.insertEntryInterval(this.mediaTableModel.getRowCount(), this.tableLoadArray, 0, insertCount);
        }
        this.mediaManagerPanel.updateEntryCount();
    }

    public void scanEntriesAsync(Scanner scanner) {
        ThreadPool pool = this.getScannerThreadPool();
        if (pool != null) {
            try {
                pool.start((Runnable)scanner);
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        new Thread(scanner).start();
    }

    public void scanEntries() {
        List scanEntryList = null;
        this.scanEntries(scanEntryList, 7, 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanEntries(List scanEntryList, int flags, int batch) {
        MediaTableViewPanel mediaTableViewPanel = this;
        synchronized (mediaTableViewPanel) {
            this.cancelMediaScanner();
            if (scanEntryList == null) {
                scanEntryList = new ArrayList(this.loadedEntryList);
            }
            this.crateEntryScanner = new MediaTableEntryScanner(this.mediaLibrary, scanEntryList, this.getJTable(), flags, batch);
        }
        if (this.crateEntryScanner != null) {
            this.crateEntryScanner.run();
        }
        if (this.searchFilter != null || this.entryComparator != null) {
            this.refreshLater();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelMediaScanner() {
        MediaTableEntryScanner oldScanner;
        MediaTableViewPanel mediaTableViewPanel = this;
        synchronized (mediaTableViewPanel) {
            oldScanner = this.crateEntryScanner;
        }
        if (oldScanner == null) {
            return;
        }
        oldScanner.cancel();
        oldScanner.join();
        mediaTableViewPanel = this;
        synchronized (mediaTableViewPanel) {
            if (this.crateEntryScanner == oldScanner) {
                this.crateEntryScanner = null;
            }
        }
    }

    public void analyzeEntriesAsync(Analyzer analyzer) {
        ThreadPool pool = this.getScannerThreadPool();
        if (pool != null) {
            try {
                pool.start((Runnable)analyzer);
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        new Thread(analyzer).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void analyzeEntries(MediaAnalyzer mediaAnalyzer, List analyzeEntryList, boolean forceRescan) {
        MediaTableViewPanel mediaTableViewPanel = this;
        synchronized (mediaTableViewPanel) {
            this.cancelMediaAnalyzer();
            this.crateEntryAnalyzer = new MediaTableEntryAnalyzer(this.mediaLibrary, analyzeEntryList, this.getJTable(), forceRescan);
        }
        if (this.crateEntryAnalyzer != null) {
            this.crateEntryAnalyzer.run();
        }
        if (this.searchFilter != null || this.entryComparator != null) {
            this.refreshLater();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelMediaAnalyzer() {
        MediaTableEntryAnalyzer oldScanner;
        MediaTableViewPanel mediaTableViewPanel = this;
        synchronized (mediaTableViewPanel) {
            oldScanner = this.crateEntryAnalyzer;
        }
        if (oldScanner == null) {
            return;
        }
        oldScanner.cancel();
        oldScanner.join();
        mediaTableViewPanel = this;
        synchronized (mediaTableViewPanel) {
            if (this.crateEntryAnalyzer == oldScanner) {
                this.crateEntryAnalyzer = null;
            }
        }
    }

    public Filter getLoadFilter() {
        return this.loadFilter;
    }

    public void setLoadFilter(Filter loadFilter) {
        this.loadFilter = loadFilter;
    }

    public Filter getSearchFilter() {
        return this.searchFilter;
    }

    public synchronized void setSearchFilter(Filter searchFilter) {
        this.searchFilter = searchFilter;
        this.refreshLater();
    }

    public Comparator getEntryComparator() {
        return this.entryComparator;
    }

    public synchronized void setEntryComparator(Comparator entryComparator) {
        this.entryComparator = entryComparator;
        this.refreshLater();
    }

    public void refreshLater() {
        SwingUtilities.invokeLater(this.refresher);
    }

    protected void refresh(boolean startScanner) {
        HashSet<MediaTableEntry> selEntries = null;
        int[] selRows = this.getSelectedRows();
        int numSel = selRows.length;
        if (numSel > 0) {
            selEntries = new HashSet<MediaTableEntry>();
            for (int i = 0; i < numSel; ++i) {
                selEntries.add(this.mediaTableModel.getEntryAt(selRows[i]));
            }
        }
        this.refresh(selEntries, startScanner);
    }

    protected void refresh(Set selEntries, boolean startScanner) {
        this.filterEntryList.clear();
        Filter searchFilter = this.searchFilter;
        if (searchFilter == null) {
            this.filterEntryList.addAll(this.loadedEntryList);
        } else {
            for (MediaTableEntry tableEntry : this.loadedEntryList) {
                if (!searchFilter.accept((Object)tableEntry)) continue;
                this.filterEntryList.add(tableEntry);
            }
        }
        Comparator comp = this.entryComparator;
        if (comp != null) {
            Collections.sort(this.filterEntryList, comp);
        }
        int[] selRows = null;
        int newSel = 0;
        if (selEntries != null && !selEntries.isEmpty()) {
            selRows = new int[selEntries.size()];
            int row = 0;
            for (MediaTableEntry tableEntry : this.filterEntryList) {
                if (selEntries.contains(tableEntry)) {
                    if (newSel >= selRows.length) {
                        int[] grow = new int[newSel * 2];
                        System.arraycopy(selRows, 0, grow, 0, selRows.length);
                        selRows = grow;
                    }
                    selRows[newSel++] = row;
                }
                ++row;
            }
        }
        this.mediaTableModel.removeAllEntries();
        this.mediaTableModel.insertEntryInterval(0, this.filterEntryList);
        if (newSel > 0) {
            this.setSelectedEntries(selRows, 0, newSel);
        }
        this.mediaManagerPanel.updateEntryCount();
        if (startScanner) {
            this.scanEntriesAsync(this.scanner);
        }
    }

    public void moveSelectedEntriesUp() {
        this.moveSelectedEntries(-1);
    }

    public void moveSelectedEntriesDown() {
        this.moveSelectedEntries(1);
    }

    public synchronized void moveSelectedEntries(int move) {
        int[] rows = this.getSelectedRows();
        int count = rows.length;
        if (count < 1) {
            return;
        }
        int loadedCount = this.loadedEntryList.size();
        LinkedList<EntryChange> removeList = new LinkedList<EntryChange>();
        LinkedList<EntryChange> insertList = new LinkedList<EntryChange>();
        for (int i = 0; i < count; ++i) {
            int index2;
            int index;
            int loadedRow2;
            int loadedRow;
            MutableMediaCrate mmc;
            int filterRow = rows[i];
            MediaTableEntry mte = this.getMediaTableEntryAt(filterRow);
            if (mte == null) {
                return;
            }
            MediaCrateEntry mce = mte.getCrateEntry();
            if (mce == null) {
                return;
            }
            MediaCrate mc = mce.getCrate();
            if (mc == null) {
                return;
            }
            if (mc instanceof MutableMediaCrate) {
                mmc = (MutableMediaCrate)mc;
                loadedRow = this.loadedEntryList.indexOf(mte);
                if (loadedRow < 0) {
                    return;
                }
                loadedRow2 = loadedRow + move;
                if (loadedRow2 < 0 || loadedRow2 >= loadedCount) {
                    return;
                }
                index = mmc.getEntryIndex(mce);
                if (index < 0) {
                    return;
                }
                index2 = index + move;
                if (index2 < 0 || index2 >= mmc.getEntryCount()) {
                    return;
                }
            } else {
                return;
            }
            removeList.add(new EntryChange(mte, mmc, index, loadedRow));
            insertList.add(new EntryChange(mte, mmc, index2, loadedRow2));
        }
        int entryCount = removeList.size();
        if (entryCount < 1) {
            return;
        }
        EntryChange[] entryRemoveArray = removeList.toArray(new EntryChange[removeList.size()]);
        EntryRemoveEdit removeEdit = new EntryRemoveEdit(entryRemoveArray);
        EntryChange[] entryInsertArray = insertList.toArray(new EntryChange[insertList.size()]);
        EntryInsertEdit insertEdit = new EntryInsertEdit(entryInsertArray);
        removeEdit.execute();
        insertEdit.execute();
        CompoundEdit edit = new CompoundEdit();
        edit.addEdit(removeEdit);
        edit.addEdit(insertEdit);
        edit.end();
        UndoManager um = this.getUndoManager();
        if (um != null) {
            um.addEdit(edit);
        }
    }

    public synchronized void detectDuplicateEntries() {
        try {
            int i;
            MediaEntry me;
            DuplicateDetectorOptions options = this.duplicateDetectorOptions;
            if (options != null) {
                options = options.cloneDuplicateDetectorOptions();
            }
            if (options == null) {
                options = new DuplicateDetectorOptions();
            }
            DuplicateDetectorPanel dudePanel = new DuplicateDetectorPanel();
            dudePanel.setOptions(options);
            Object message = dudePanel;
            String title = "Duplicate Detector";
            int optionType = 2;
            int messageType = -1;
            int rc = JOptionPane.showConfirmDialog((Component)((Object)this), message, title, optionType, messageType);
            if (rc != 0) {
                return;
            }
            options = dudePanel.getOptions();
            if (options == null) {
                return;
            }
            this.duplicateDetectorOptions = options;
            boolean selectedOnly = options.isCheckSelectedOnly();
            double threshold = options.getThreshold();
            DuplicateDetectorImpl dude = new DuplicateDetectorImpl(options);
            List entryList = this.filterEntryList;
            if (entryList == null || entryList.isEmpty()) {
                return;
            }
            ArrayList<MediaEntry> meList = new ArrayList<MediaEntry>();
            for (MediaTableEntry entry : entryList) {
                me = entry == null ? null : entry.getMediaEntry();
                meList.add(me);
            }
            int count = meList.size();
            if (count < 2) {
                return;
            }
            HashSet<MediaEntry> checkSet = new HashSet<MediaEntry>();
            if (selectedOnly) {
                int[] sel = this.getSelectedRows();
                int num = sel.length;
                if (num < 1) {
                    return;
                }
                for (i = 0; i < num; ++i) {
                    MediaTableEntry entry;
                    entry = this.getMediaTableEntryAt(sel[i]);
                    MediaEntry mediaEntry = me = entry == null ? null : entry.getMediaEntry();
                    if (me == null) continue;
                    checkSet.add(me);
                }
            }
            HashSet<MediaTableEntry> duplicateMediaTableEntries = new HashSet<MediaTableEntry>();
            block4: for (i = 0; i < count; ++i) {
                int z;
                me = (MediaEntry)meList.get(i);
                if (me == null) continue;
                if (selectedOnly) {
                    if (!checkSet.contains(me)) continue;
                    z = count;
                } else {
                    z = i;
                }
                for (int x = 0; x < z; ++x) {
                    MediaTableEntry mtx;
                    MediaTableEntry mte;
                    double v;
                    MediaEntry mx;
                    if (x == i || (mx = (MediaEntry)meList.get(x)) == null || !((v = dude.compareMediaEntry(me, mx)) < threshold)) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Dude! Duplicate detected: me=" + me + ", mx=" + mx + ", diff=" + v + " < " + threshold);
                    }
                    if ((mte = (MediaTableEntry)entryList.get(i)) != null) {
                        duplicateMediaTableEntries.add(mte);
                    }
                    if ((mtx = (MediaTableEntry)entryList.get(x)) == null) continue block4;
                    duplicateMediaTableEntries.add(mtx);
                    continue block4;
                }
            }
            int duplicateCount = duplicateMediaTableEntries.size();
            if (duplicateCount < 1) {
                message = "No duplicate entries detected.";
                messageType = 1;
                JOptionPane.showMessageDialog((Component)((Object)this), message, title, messageType);
                return;
            }
            ListSelectionModel selModel = this.getJTable().getSelectionModel();
            selModel.clearSelection();
            for (MediaTableEntry entry : duplicateMediaTableEntries) {
                int row;
                if (entry == null || (row = entryList.indexOf(entry)) < 0) continue;
                selModel.addSelectionInterval(row, row);
            }
            message = "Number of duplicates detected: " + duplicateCount;
            messageType = 1;
            JOptionPane.showMessageDialog((Component)((Object)this), message, title, messageType);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void removeMissingFileEntries() {
        try {
            List entryList = this.filterEntryList;
            int[] missingRows = new int[16];
            int missingCount = 0;
            int row = 0;
            for (MediaTableEntry entry : entryList) {
                FileResource fileRes;
                File file;
                Resource resource = entry.getResource();
                if (resource == null || resource instanceof FileResource && ((file = (fileRes = (FileResource)resource).getFile()) == null || !file.exists() || !file.isFile())) {
                    if (missingCount >= missingRows.length) {
                        int[] grow = new int[missingCount * 2];
                        System.arraycopy(missingRows, 0, grow, 0, missingCount);
                        missingRows = grow;
                    }
                    missingRows[missingCount++] = row;
                }
                ++row;
            }
            if (missingCount < 1) {
                String title = "Remove Missing Files";
                String message = "There are no missing file entries.";
                int messageType = 1;
                JOptionPane.showMessageDialog((Component)((Object)this), message, title, messageType);
                return;
            }
            int[] rows = new int[missingCount];
            System.arraycopy(missingRows, 0, rows, 0, missingCount);
            this.setSelectedRows(rows);
            this.removeSelectedEntries(true);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void openRelocateFilesDialog() {
        try {
            FileLocator fileLocator = Platform.getInstance().getFileLocator();
            if (fileLocator == null) {
                logger.warning("FileLocator is not available!");
                return;
            }
            int num = this.mediaTableModel.getRowCount();
            if (num < 1) {
                return;
            }
            LinkedList<EntryChange> entryRemoveList = new LinkedList<EntryChange>();
            LinkedList<EntryChange> entryInsertList = new LinkedList<EntryChange>();
            int missingCount = 0;
            int relocatedCount = 0;
            for (int i = 0; i < num; ++i) {
                int index;
                int loadedRow;
                FileResource fileRes;
                File file;
                MediaCrate crate;
                MediaCrateEntry entry;
                int modelRow = i;
                MediaTableEntry mtce = this.mediaTableModel.getEntryAt(modelRow);
                if (mtce == null || (entry = mtce.getCrateEntry()) == null || (crate = mtce.getCrate()) == null || !(crate instanceof MutableMediaCrate)) continue;
                MutableMediaCrate mutableCrate = (MutableMediaCrate)crate;
                Resource resource = mtce.getResource();
                if (resource == null || !(resource instanceof FileResource) || (file = (fileRes = (FileResource)resource).getFile()) == null || (loadedRow = this.loadedEntryList.indexOf(mtce)) < 0 || (index = mutableCrate.getEntryIndex(entry)) < 0) continue;
                File locatedFile = fileLocator.locateFile(file.getPath());
                if (locatedFile == null) {
                    int messageType;
                    int optionType;
                    ++missingCount;
                    if (i + 1 >= num) continue;
                    String title = "Continue ?";
                    String message = "Do you want to relocate the next " + (num - i - 1) + " selected file(s) ?";
                    int rc = JOptionPane.showConfirmDialog((Component)((Object)this), message, title, optionType = 2, messageType = 3);
                    if (rc == 0) continue;
                    break;
                }
                if (locatedFile.equals(file)) continue;
                FileResource newResource = new FileResource(locatedFile);
                DefaultMediaCrateEntry newCrateEntry = new DefaultMediaCrateEntry((MediaCrate)mutableCrate, (Resource)newResource);
                MediaTableEntry newTableEntry = this.tableEntryPool.getEntry((MediaCrateEntry)newCrateEntry);
                entryRemoveList.add(new EntryChange(mtce, mutableCrate, index, loadedRow));
                entryInsertList.add(new EntryChange(newTableEntry, mutableCrate, index, loadedRow));
                ++relocatedCount;
            }
            if (relocatedCount > 0) {
                EntryChange[] entryRemoveArray = entryRemoveList.toArray(new EntryChange[entryRemoveList.size()]);
                EntryRemoveEdit removeEdit = new EntryRemoveEdit(entryRemoveArray);
                EntryChange[] entryInsertArray = entryInsertList.toArray(new EntryChange[entryInsertList.size()]);
                EntryInsertEdit insertEdit = new EntryInsertEdit(entryInsertArray);
                removeEdit.execute();
                insertEdit.execute();
                CompoundEdit edit = new CompoundEdit();
                edit.addEdit(removeEdit);
                edit.addEdit(insertEdit);
                edit.end();
                UndoManager um = this.getUndoManager();
                if (um != null) {
                    um.addEdit(edit);
                }
            }
            String title = "Relocate Missing Files";
            StringBuffer message = new StringBuffer();
            if (relocatedCount < 1 && missingCount < 1) {
                message.append("There are no missing file entries.");
            } else {
                message.append("Number of relocated files: " + relocatedCount);
                if (missingCount > 0) {
                    message.append("\n");
                    message.append("Number of missing files: " + missingCount);
                }
            }
            int messageType = 1;
            JOptionPane.showMessageDialog((Component)((Object)this), message.toString(), title, messageType);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public MediaTableEntry getActiveEntry() {
        return this.activeEntry;
    }

    public void setActiveEntry(MediaTableEntry activeEntry) {
        this.setActiveEntry(activeEntry, -1);
    }

    public synchronized void setActiveEntry(MediaTableEntry activeEntry, int expectedRow) {
        if (this.activeEntry == activeEntry) {
            return;
        }
        this.activeEntry = activeEntry;
        this.activeRow = expectedRow;
        SwingUtilities.invokeLater(this.activeEntryRefresher);
    }

    protected void refreshActiveEntry() {
        this.mediaTableModel.setActiveEntry(this.activeEntry);
        JTable table = this.getJTable();
        int row = -1;
        if (this.followActiveEntry) {
            int maxSel;
            int minSel;
            boolean updateSelection = true;
            ListSelectionModel selModel = this.getSelectionModel();
            if (!selModel.isSelectionEmpty() && (minSel = selModel.getMinSelectionIndex()) != (maxSel = selModel.getMaxSelectionIndex())) {
                updateSelection = false;
            }
            if (updateSelection && (row = this.getFilterEntryRow(this.activeEntry, this.activeRow)) >= 0) {
                selModel.setSelectionInterval(row, row);
                this.scrollRowToVisible(row);
            }
        }
        this.activeRow = row;
        table.repaint();
    }

    public synchronized int getFilterEntryRow(MediaTableEntry entry, int expectedRow) {
        if (expectedRow >= 0 && expectedRow < this.filterEntryList.size() && this.filterEntryList.get(expectedRow) == entry) {
            return expectedRow;
        }
        return this.filterEntryList.indexOf(entry);
    }

    public boolean isFollowActiveEntry() {
        return this.followActiveEntry;
    }

    public void setFollowActiveEntry(boolean followActiveEntry) {
        this.followActiveEntry = followActiveEntry;
    }

    protected synchronized EntryTableColumnProvider[] getEntryTableColumnProviders() {
        return this.tableColumnProviders.toArray(new EntryTableColumnProvider[this.tableColumnProviders.size()]);
    }

    protected synchronized EntryTableColumnProvider getEntryTableColumnProvider(TableColumn column) {
        if (column == null) {
            return null;
        }
        Object headerValue = column.getHeaderValue();
        if (headerValue == null) {
            return null;
        }
        return this.getEntryTableColumnProvider(headerValue);
    }

    protected synchronized EntryTableColumnProvider getEntryTableColumnProvider(Object headerValue) {
        int num = this.tableColumnProviders.size();
        for (int i = 0; i < num; ++i) {
            EntryTableColumnProvider provider;
            TableColumnProvider tcp = (TableColumnProvider)this.tableColumnProviders.get(i);
            if (tcp == null || !(tcp instanceof EntryTableColumnProvider) || !headerValue.equals((provider = (EntryTableColumnProvider)tcp).getHeaderValue())) continue;
            return provider;
        }
        return null;
    }

    protected void handleTableColumnHeaderActionPerformed(TableColumn column) {
        EntryTableColumnProvider columnProvider = this.getEntryTableColumnProvider(column);
        if (columnProvider == null) {
            return;
        }
        this.tableSortModel.sortByColumn(columnProvider);
        this.setEntryComparator(this.tableSortModel.getEntryTableSortComparator());
        this.getJTable().getTableHeader().repaint();
    }

    public synchronized void resetSortingOrder() {
        this.tableSortModel.reset();
        this.setEntryComparator(null);
        this.getJTable().getTableHeader().repaint();
    }

    public synchronized void applySortingOrder() {
        logger.warning("TODO applySortingOrder...");
    }

    public void rescanSelectedEntries() {
        int[] rows = this.getSelectedRows();
        int num = rows.length;
        if (num < 1) {
            return;
        }
        ArrayList<MediaTableEntry> scanEntryList = new ArrayList<MediaTableEntry>(num);
        for (int i = 0; i < num; ++i) {
            MediaTableEntry mte = this.getMediaTableEntryAt(rows[i]);
            if (mte == null) continue;
            mte.setMediaEntry(null);
            scanEntryList.add(mte);
        }
        this.cancelMediaScanner();
        int flags = 15;
        int batch = 32;
        Scanner scanner = new Scanner(scanEntryList, flags, batch);
        this.scanEntriesAsync(scanner);
    }

    public void analyzeSelectedEntries(boolean forceRescan) {
        MediaAnalyzer mediaAnalyzer;
        try {
            mediaAnalyzer = MediaManagerPlugin.getInstance().getMediaAnalyzer();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return;
        }
        int[] rows = this.getSelectedRows();
        int num = rows.length;
        if (num < 1) {
            return;
        }
        ArrayList<MediaTableEntry> analyzeEntryList = new ArrayList<MediaTableEntry>(num);
        for (int i = 0; i < num; ++i) {
            MediaTableEntry mte = this.getMediaTableEntryAt(rows[i]);
            if (mte == null) continue;
            analyzeEntryList.add(mte);
        }
        this.cancelMediaAnalyzer();
        Analyzer analyzer = new Analyzer(mediaAnalyzer, analyzeEntryList, forceRescan);
        this.analyzeEntriesAsync(analyzer);
    }

    public void requestTableFocus() {
        this.getJTable().requestFocus();
    }

    public void requestEntryTableFocus() {
        this.getJTable().requestFocus();
    }

    public JTable getMediaTable() {
        return this.getJTable();
    }

    public synchronized void openAdvancedSearchDialog() {
        AdvancedSearchOptions o = this.getAdvancedSearchOptions();
        if (o == null) {
            o = new AdvancedSearchOptions();
        }
        if (this.advancedSearchPanel == null) {
            this.advancedSearchPanel = new AdvancedSearchPanel();
            this.advancedSearchPanel.setMediaTableToolContext(this.getMediaTableToolContext());
        }
        if (this.advancedSearchDialog == null) {
            this.advancedSearchDialog = SwingTools.createJDialog((Component)((Object)this));
            this.advancedSearchPanel.setOwner(this.advancedSearchDialog);
            this.advancedSearchDialog.setTitle("Advanced Search");
            this.advancedSearchDialog.setModal(false);
            this.advancedSearchDialog.setContentPane(this.advancedSearchPanel);
            this.advancedSearchDialog.pack();
            Tools.centerWindow((Component)((Object)this), (Window)this.advancedSearchDialog);
        }
        this.advancedSearchPanel.setOptions(o);
        this.advancedSearchDialog.setVisible(true);
        this.advancedSearchDialog.toFront();
    }

    public String getSimpleSearchText() {
        return this.simpleSearchText;
    }

    public void setSimpleSearchText(String text) {
        this.simpleSearchText = text;
        this.applySearchFilter();
    }

    public AdvancedSearchOptions getAdvancedSearchOptions() {
        return this.advancedSearchOptions;
    }

    public void setAdvancedSearchOptions(AdvancedSearchOptions options) {
        this.advancedSearchOptions = options;
        this.applySearchFilter();
    }

    public void resetSearchFilter() {
        this.simpleSearchText = null;
        this.advancedSearchOptions = null;
        this.applySearchFilter();
    }

    protected void applySearchFilter() {
        AdvancedSearchOptions options;
        LinkedList<Object> andList = new LinkedList<Object>();
        String simple = this.getSimpleSearchText();
        if (simple != null) {
            boolean ignoreCase = true;
            StringTokenizer tok = new StringTokenizer(simple);
            while (tok.hasMoreTokens()) {
                String sub = tok.nextToken();
                andList.add(new SubStringSearchFilter(sub, ignoreCase));
            }
        }
        if ((options = this.getAdvancedSearchOptions()) != null) {
            andList.add(new AdvancedMediaFilter(options));
            String regex = options.getRegex();
            if (regex != null && (regex = regex.trim()).length() > 0) {
                try {
                    int flags = 34;
                    Pattern pattern = Pattern.compile(regex, flags);
                    if (pattern != null) {
                        andList.add(new RegexSearchFilter(pattern));
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
        Filter filter = null;
        int num = andList.size();
        if (num > 0) {
            if (num == 1) {
                filter = (Filter)andList.get(0);
            } else {
                Filter[] andFilters = andList.toArray(new Filter[num]);
                filter = new MultiAndFilter(andFilters);
            }
        }
        this.setSearchFilter(filter);
    }

    protected void refreshEntryPropertiesPanel() {
        MediaEntryTabbedPanel mepp = this.mediaEntryPropertiesPanel;
        if (mepp == null) {
            return;
        }
        MediaEntry me = null;
        try {
            MediaTableEntry mte;
            int leadIndex;
            ListSelectionModel selModel = this.getSelectionModel();
            if (selModel != null && (leadIndex = selModel.getLeadSelectionIndex()) >= 0 && (mte = this.getMediaTableEntryAt(leadIndex)) != null) {
                me = this.getMediaEntry(mte);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (mepp.getMediaEntry() == me) {
            return;
        }
        mepp.setMediaEntry(me);
        mepp.refresh();
    }

    protected MediaEntry getMediaEntry(MediaTableEntry mte) {
        MediaEntry me = mte.getMediaEntry();
        if (me != null) {
            return me;
        }
        try {
            Resource res = mte.getResource();
            MediaLibrary lib = this.getMediaLibrary();
            if (res != null && lib != null && (me = lib.getMediaEntry(res)) != null) {
                mte.setMediaEntry(me);
                return me;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    public void showEntryPropertiesDialog() {
        try {
            if (this.mediaEntryPropertiesPanel == null) {
                this.mediaEntryPropertiesPanel = this.createMediaEntryTabbedPanel();
                this.mediaEntryPropertiesPanel.setMediaTableToolContext(this.mediaTableToolContext);
                this.mediaEntryPropertiesPanel.setPreferredSize(new Dimension(450, 320));
            }
            if (this.entryPropertiesDialog == null) {
                this.entryPropertiesDialog = SwingTools.createJDialog((Component)((Object)this));
                this.entryPropertiesDialog.setTitle("Media Properties");
                this.entryPropertiesDialog.setModal(false);
                this.entryPropertiesDialog.setContentPane(this.mediaEntryPropertiesPanel);
                this.entryPropertiesDialog.pack();
                Tools.centerWindow((Component)((Object)this), (Window)this.entryPropertiesDialog);
            }
            this.refreshEntryPropertiesPanel();
            this.entryPropertiesDialog.setVisible(true);
            this.entryPropertiesDialog.toFront();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected MediaEntryTabbedPanel createMediaEntryTabbedPanel() {
        MediaEntryTabbedPanel panel = new MediaEntryTabbedPanel();
        this.mediaEntryOverviewPanel = new MediaEntryOverviewPanel();
        this.audioEntryPropertiesPanel = new AudioEntryPropertiesPanel();
        this.pictureEntryPropertiesPanel = new PictureEntryPropertiesPanel();
        this.pictureEntryPropertiesPanel.setThreadPool(this.getPictureThreadPool());
        this.mediaMarkerPropertiesPanel = new MediaMarkerPropertiesPanel();
        this.mediaEntryDetailsPanel = new MediaEntryDetailsPanel();
        panel.setMediaEntryPropertiesPanels(new AbstractEntryPropertiesPanel[]{this.mediaEntryOverviewPanel, this.audioEntryPropertiesPanel, this.pictureEntryPropertiesPanel, this.mediaMarkerPropertiesPanel, this.mediaEntryDetailsPanel});
        return panel;
    }

    public boolean increaseSelectedUserRating() {
        int leadIndex = this.getSelectionModel().getLeadSelectionIndex();
        if (leadIndex < 0) {
            return false;
        }
        MediaTableEntry entry = this.getMediaTableEntryAt(leadIndex);
        if (entry == null) {
            return false;
        }
        MediaEntry me = entry.getMediaEntry();
        if (me != null && me instanceof MutableMediaEntry) {
            MutableMediaEntry ame = (MutableMediaEntry)me;
            this.increaseUserRating(ame, 0.1);
            return true;
        }
        return false;
    }

    protected MediaTableEntry getLeadSelectionEntry() {
        int leadIndex = this.getSelectionModel().getLeadSelectionIndex();
        if (leadIndex < 0) {
            return null;
        }
        return this.getMediaTableEntryAt(leadIndex);
    }

    public boolean decreaseSelectedUserRating() {
        MediaTableEntry entry = this.getLeadSelectionEntry();
        if (entry == null) {
            return false;
        }
        MediaEntry me = entry.getMediaEntry();
        if (me != null && me instanceof MutableMediaEntry) {
            MutableMediaEntry ame = (MutableMediaEntry)me;
            this.increaseUserRating(ame, -0.1);
            return true;
        }
        return false;
    }

    public boolean setSelectedUserRating(double newRating) {
        MediaTableEntry entry = this.getLeadSelectionEntry();
        if (entry == null) {
            return false;
        }
        MediaEntry me = entry.getMediaEntry();
        if (me != null && me instanceof MutableMediaEntry) {
            MutableMediaEntry ame = (MutableMediaEntry)me;
            return this.setUserRating(ame, newRating);
        }
        return false;
    }

    public double increaseUserRating(MutableMediaEntry entry, double amount) {
        double oldRating = entry.getUserRating();
        if (Double.isNaN(oldRating)) {
            oldRating = 0.0;
        }
        double newRating = oldRating + amount;
        this.setUserRating(entry, newRating);
        return newRating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUserRating(MutableMediaEntry entry, double newRating) {
        if (entry == null) {
            return false;
        }
        Resource resource = entry.getResource();
        if (resource == null) {
            return false;
        }
        MediaLibrary lib = this.mediaLibrary;
        if (lib == null) {
            return false;
        }
        if (Double.isNaN(newRating)) {
            if (Double.isNaN(entry.getUserRating())) {
                return false;
            }
        } else {
            if (newRating > 1.0) {
                newRating = 1.0;
            }
            if (newRating < -1.0) {
                newRating = -1.0;
            }
            if (newRating == entry.getUserRating()) {
                return false;
            }
        }
        try {
            lib.setUserRating(entry, newRating);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.getJTable().repaint();
        }
    }

    public double increaseUserRating(MediaCrateEntry entry, double amount) {
        MediaTableEntry mte;
        MediaEntry me;
        if (entry != null && entry instanceof MediaTableEntry && (me = (mte = (MediaTableEntry)entry).getMediaEntry()) != null && me instanceof MutableMediaEntry) {
            MutableMediaEntry ame = (MutableMediaEntry)me;
            return this.increaseUserRating(ame, amount);
        }
        return Double.NaN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateUserComment(MutableMediaEntry entry, String comment) {
        if (entry == null) {
            return false;
        }
        MediaLibrary lib = this.mediaLibrary;
        if (lib == null) {
            return false;
        }
        if ((comment == null || comment.length() < 1) && entry.getUserComment() == null) {
            return false;
        }
        try {
            lib.setUserComment(entry, comment);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.getJTable().repaint();
        }
    }

    public boolean putMediaMarker(MutableMediaEntry entry, MediaMarker marker) {
        if (entry == null || marker == null) {
            return false;
        }
        MediaMarker[] oldMarkers = entry.getMarkers();
        int oldCount = oldMarkers == null ? 0 : oldMarkers.length;
        MediaMarker[] newMarkers = new MediaMarker[oldCount + 1];
        if (oldCount > 0) {
            System.arraycopy(oldMarkers, 0, newMarkers, 0, oldCount);
        }
        newMarkers[oldCount] = marker;
        return this.updateMediaMarkers(entry, newMarkers);
    }

    public boolean updateMediaMarkers(MutableMediaEntry entry, MediaMarker[] markers) {
        if (entry == null) {
            return false;
        }
        entry.setMarkers(markers);
        MediaLibrary lib = this.mediaLibrary;
        if (lib == null) {
            return false;
        }
        Resource res = entry.getResource();
        if (res == null) {
            return false;
        }
        try {
            MediaEntry me;
            if (lib.containsMediaEntry(res) && (me = lib.getMediaEntry(res)) != null && me instanceof MutableMediaEntry) {
                entry = (MutableMediaEntry)me;
                entry.setMarkers(markers);
            }
            lib.putMediaEntry(res, (MediaEntry)entry);
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
    }

    public boolean isFitColumnsToWindow() {
        return this.fitColumnsToWindow;
    }

    public synchronized void setFitColumnsToWindow(boolean fitColumnsToWindow) {
        if (this.fitColumnsToWindow == fitColumnsToWindow) {
            return;
        }
        this.fitColumnsToWindow = fitColumnsToWindow;
        if (fitColumnsToWindow) {
            this.layoutResultToFitWindow();
        } else {
            this.layoutResultToFitColumns();
        }
    }

    public void saveViewPreferences(Properties props) {
        MediaTableEntry actEntry;
        MediaCrate[] loaded;
        props.setProperty(KEY_FIT_COLUMNS_TO_WINDOW, Boolean.toString(this.fitColumnsToWindow));
        TableColumnModel colModel = this.getJTable().getColumnModel();
        int colCount = colModel.getColumnCount();
        if (colCount > 0) {
            props.setProperty(KEY_COLUMN_COUNT, Integer.toString(colCount));
            for (int i = 0; i < colCount; ++i) {
                TableColumn col = colModel.getColumn(i);
                EntryTableColumnProvider tcp = this.getEntryTableColumnProvider(col);
                if (tcp == null) continue;
                props.setProperty(KEY_COLUMN_NAME_PREFIX + i, String.valueOf(tcp.getHeaderValue()));
                props.setProperty(KEY_COLUMN_WIDTH_PREFIX + i, Integer.toString(col.getWidth()));
            }
        }
        if ((loaded = this.getLoadedCrates()) != null) {
            // empty if block
        }
        if ((actEntry = this.getActiveEntry()) != null) {
            // empty if block
        }
    }

    public void loadViewPreferences(Properties props) {
        String s = props.getProperty(KEY_FIT_COLUMNS_TO_WINDOW);
        if (s != null) {
            this.setFitColumnsToWindow("true".equalsIgnoreCase(s));
        }
        if ((s = props.getProperty(KEY_COLUMN_COUNT)) != null) {
            try {
                int colCount = Integer.parseInt(s);
                if (colCount > 0) {
                    int i;
                    this.enabledColumnProviders.clear();
                    TableColumnModel columnModel = this.getJTable().getColumnModel();
                    int oldCount = columnModel.getColumnCount();
                    for (i = oldCount - 1; i >= 0; --i) {
                        columnModel.removeColumn(columnModel.getColumn(i));
                    }
                    for (i = 0; i < colCount; ++i) {
                        int width;
                        String colWidth;
                        TableColumn col;
                        String headerValue = props.getProperty(KEY_COLUMN_NAME_PREFIX + i);
                        EntryTableColumnProvider tcp = this.getEntryTableColumnProvider(headerValue);
                        if (tcp == null || (col = this.setColumnProviderEnabled(tcp, true)) == null || (colWidth = props.getProperty(KEY_COLUMN_WIDTH_PREFIX + i)) == null || (width = Integer.parseInt(colWidth)) <= 0) continue;
                        col.setPreferredWidth(width);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected MediaResource addRemoteResource() {
        try {
            MediaLibrary library;
            MediaTableEntry mte;
            MutableMediaCrate target = null;
            int targetIndex = -1;
            int targetRow = -1;
            ListSelectionModel selModel = this.getJTable().getSelectionModel();
            int leadIndex = selModel.getLeadSelectionIndex();
            if (leadIndex >= 0 && !selModel.isSelectionEmpty() && (mte = this.getMediaTableEntryAt(leadIndex)) != null) {
                MediaCrate mc = mte.getCrate();
                MediaCrateEntry mce = mte.getCrateEntry();
                if (mce != null && mc != null && mc instanceof MutableMediaCrate) {
                    target = (MutableMediaCrate)mc;
                    targetIndex = target.getEntryIndex(mce);
                    if (targetIndex >= 0) {
                        ++targetIndex;
                    }
                    if ((targetRow = this.loadedEntryList.indexOf(mte)) >= 0) {
                        ++targetRow;
                    }
                }
            }
            if (target == null && (target = this.getTargetMediaCrate()) == null) {
                return null;
            }
            if (targetIndex < 0) {
                targetIndex = target.getEntryCount();
                targetRow = this.loadedEntryList.size();
            }
            if ((library = this.getMediaLibrary()) == null) {
                return null;
            }
            BaseMediaContext context = null;
            MediaContext mc = library.getContext();
            if (mc != null && mc instanceof BaseMediaContext) {
                context = (BaseMediaContext)mc;
            }
            if (context == null) {
                return null;
            }
            RemoteMediaResourcePanel panel = new RemoteMediaResourcePanel();
            panel.setMediaContext(context);
            boolean confirm = panel.showRemoteMediaResourceDialog((Component)((Object)this));
            if (!confirm) {
                return null;
            }
            MediaResource mediaResource = panel.getMediaResource();
            if (mediaResource == null) {
                return null;
            }
            LinkedList<MediaResource> beans = new LinkedList<MediaResource>();
            beans.add(mediaResource);
            this.dropEntries(beans, target, targetIndex, targetRow);
            return mediaResource;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public void invokeDefaultEntryAction(MediaPlayer player) {
        try {
            MediaTableEntry entry;
            int leadIndex;
            ListSelectionModel selModel;
            MediaPlayer[] players;
            if (player == null) {
                player = this.getMediaPlayer();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("invokeDefaultEntryAction: " + (Object)((Object)this) + " => " + player);
            }
            if (player == null && (players = this.getMediaPlayers()) != null && players.length > 0 && (player = players[0]) != null) {
                this.getMediaManagerPanel().setMediaPlayer(player);
            }
            if (player != null && (selModel = this.getSelectionModel()) != null && (leadIndex = selModel.getLeadSelectionIndex()) >= 0 && (entry = this.getMediaTableEntryAt(leadIndex)) != null) {
                DefaultEntryActionWorker worker = new DefaultEntryActionWorker(player, entry, leadIndex);
                ThreadPool threadPool = this.workerThreadPool;
                if (threadPool != null) {
                    threadPool.start((Runnable)worker);
                } else {
                    worker.run();
                }
                return;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.showEntryPropertiesDialog();
    }

    public MediaPlayer getMediaPlayer() {
        return this.mediaPlayer;
    }

    public synchronized void setMediaPlayer(MediaPlayer mediaPlayer) {
        if (this.mediaPlayer == mediaPlayer) {
            return;
        }
        this.mediaPlayer = mediaPlayer;
        this.refreshPlayWithMenuGroup();
    }

    public MediaPlayer[] getMediaPlayers() {
        return this.mediaPlayers;
    }

    public synchronized void setMediaPlayers(MediaPlayer[] mediaPlayers) {
        this.mediaPlayers = mediaPlayers;
        this.refreshPlayWithMenuGroup();
    }

    protected synchronized void refreshPlayWithMenuGroup() {
        try {
            ToolGroup playWithMenuGroup;
            if (Platform.isInstanceAvailable() && (playWithMenuGroup = MediaManagerPlugin.getInstance().getPlayWithMenuGroup()) != null) {
                playWithMenuGroup.refresh();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public ThreadPool getPictureThreadPool() {
        return this.pictureThreadPool;
    }

    public void setPictureThreadPool(ThreadPool pictureThreadPool) {
        this.pictureThreadPool = pictureThreadPool;
        PictureEntryPropertiesPanel pepp = this.pictureEntryPropertiesPanel;
        if (pepp != null) {
            pepp.setThreadPool(pictureThreadPool);
        }
    }

    public void showTableExportWizard() {
        TableColumnProvider[] columns = this.enabledColumnProviders.toArray(new TableColumnProvider[this.enabledColumnProviders.size()]);
        this.showTableExportWizard(columns);
    }

    public void applyTableFont() {
        JTable table = this.getJTable();
        TableColumnModel columnModel = table.getColumnModel();
        int cols = columnModel.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            this.applyTableColumnFont(columnModel.getColumn(i));
        }
        FontMetrics fm = this.getFontMetrics(this.normalFont);
        int rowHeight = fm.getHeight();
        table.setRowHeight(rowHeight);
        table.getTableHeader().invalidate();
        this.validate();
        this.repaint();
    }

    protected void applyTableColumnFont(TableColumn tableColumn) {
        if (tableColumn == null) {
            return;
        }
        TableCellRenderer tcr = tableColumn.getCellRenderer();
        if (tcr != null && tcr instanceof EntryTableCellRenderer) {
            EntryTableCellRenderer etcr = (EntryTableCellRenderer)tcr;
            etcr.setNormalFont(this.normalFont);
            etcr.setActiveFont(this.activeFont);
        }
        if ((tcr = tableColumn.getHeaderRenderer()) != null && tcr instanceof EntryTableHeaderRenderer) {
            EntryTableHeaderRenderer ethr = (EntryTableHeaderRenderer)tcr;
            ethr.setFont(this.normalFont);
        }
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public void setNormalFont(Font normalFont) {
        this.normalFont = normalFont;
    }

    public Font getActiveFont() {
        return this.activeFont;
    }

    public void setActiveFont(Font activeFont) {
        this.activeFont = activeFont;
    }

    public String[] enumerateFileFormats() {
        TreeSet<String> fileFormats = new TreeSet<String>();
        for (MediaTableEntry entry : this.loadedEntryList) {
            String format;
            MediaEntry me = entry.getMediaEntry();
            if (me == null || (format = me.getFormat()) == null) continue;
            fileFormats.add(format);
        }
        return fileFormats.toArray(new String[fileFormats.size()]);
    }

    public boolean moveMediaCursor(int count) {
        int rows;
        JTable table = this.getJTable();
        int sel = table.getSelectedRow();
        int row = sel < 0 ? count - 1 : sel + count;
        if (row < 0) {
            row = 0;
        }
        if (row >= (rows = table.getRowCount())) {
            row = rows - 1;
        }
        if (row == sel) {
            return false;
        }
        table.changeSelection(row, -1, false, false);
        return true;
    }

    public boolean pushMediaCursor(MediaPlayer player) {
        this.invokeDefaultEntryAction(player);
        return true;
    }

    protected class NavigateMove
    implements Runnable {
        private int amount;

        protected NavigateMove() {
        }

        @Override
        public void run() {
            MediaTableViewPanel.this.getMediaManagerPanel().navigateMove(this.amount);
        }

        protected int getAmount() {
            return this.amount;
        }

        protected void setAmount(int amount) {
            this.amount = amount;
        }
    }

    protected class NavigateBack
    implements Runnable {
        protected NavigateBack() {
        }

        @Override
        public void run() {
            MediaTableViewPanel.this.getMediaManagerPanel().navigateBack();
        }
    }

    protected class NavigatePush
    implements Runnable {
        private MediaPlayer player;

        public NavigatePush(MediaPlayer player) {
            this.player = player;
        }

        @Override
        public void run() {
            MediaTableViewPanel.this.getMediaManagerPanel().navigatePush(this.player);
        }
    }

    protected class NavigatePlayList
    implements Runnable {
        protected NavigatePlayList() {
        }

        @Override
        public void run() {
            MediaTableViewPanel.this.getMediaManagerPanel().navigatePlayList();
        }
    }

    protected class NavigateCrateTree
    implements Runnable {
        protected NavigateCrateTree() {
        }

        @Override
        public void run() {
            MediaTableViewPanel.this.getMediaManagerPanel().navigateCrateTree();
        }
    }

    protected class ActiveEntryRefresher
    implements Runnable {
        protected ActiveEntryRefresher() {
        }

        @Override
        public void run() {
            MediaTableViewPanel.this.refreshActiveEntry();
        }
    }

    protected class MediaPlayerContextImpl
    implements MediaPlayerContext {
        protected MediaPlayerContextImpl() {
        }

        public int getEntryCount() {
            return MediaTableViewPanel.this.mediaTableModel.getRowCount();
        }

        public MediaCrateEntry getEntryAt(int index) {
            return MediaTableViewPanel.this.getMediaTableEntryAt(index);
        }

        public int getEntryIndex(MediaCrateEntry entry) {
            return this.getEntryIndex(entry, -1);
        }

        public int getEntryIndex(MediaCrateEntry entry, int expectedIndex) {
            MediaTableEntry mte;
            if (entry == null) {
                return -1;
            }
            Resource resource = entry.getResource();
            if (expectedIndex >= 0 && (mte = MediaTableViewPanel.this.getMediaTableEntryAt(expectedIndex)) != null) {
                if (mte == entry) {
                    return expectedIndex;
                }
                if (resource != null && resource.equals(mte.getResource())) {
                    return expectedIndex;
                }
            }
            if (resource == null) {
                return -1;
            }
            return MediaTableViewPanel.this.mediaTableModel.getEntryIndex(resource);
        }

        public MediaCrateEntry getSelectedEntry() {
            int index = this.getSelectedIndex();
            return index < 0 ? null : this.getEntryAt(index);
        }

        public int getSelectedIndex() {
            return MediaTableViewPanel.this.getSelectionModel().getLeadSelectionIndex();
        }

        public void setSelectedEntry(MediaCrateEntry activeEntry) {
            this.setSelectedEntry(activeEntry, -1);
        }

        public void setSelectedEntry(MediaCrateEntry activeEntry, int expectedIndex) {
            MediaTableEntry mte = null;
            if (activeEntry != null && activeEntry instanceof MediaTableEntry) {
                mte = (MediaTableEntry)activeEntry;
            }
            MediaTableViewPanel.this.setActiveEntry(mte, expectedIndex);
        }

        public void playerEntryChanged(MediaPlayer player, MediaCrateEntry activeEntry, int expectedIndex) {
            if (player != null && player == MediaTableViewPanel.this.mediaPlayer) {
                this.setSelectedEntry(activeEntry, expectedIndex);
            }
        }

        public MediaEntry getMediaEntry(MediaCrateEntry entry) {
            if (entry != null && entry instanceof MediaTableEntry) {
                MediaTableEntry mte = (MediaTableEntry)entry;
                return MediaTableViewPanel.this.getMediaEntry(mte);
            }
            return null;
        }

        public double increaseUserRating(MutableMediaEntry entry, double amount) {
            return MediaTableViewPanel.this.increaseUserRating(entry, amount);
        }

        public boolean updateUserRating(MutableMediaEntry entry, double rating) {
            return MediaTableViewPanel.this.setUserRating(entry, rating);
        }

        public boolean updateUserComment(MutableMediaEntry entry, String comment) {
            return MediaTableViewPanel.this.updateUserComment(entry, comment);
        }

        public boolean updateMediaMarkers(MutableMediaEntry entry, MediaMarker[] markers) {
            return MediaTableViewPanel.this.updateMediaMarkers(entry, markers);
        }

        public boolean putMediaMarker(MutableMediaEntry entry, MediaMarker marker) {
            return MediaTableViewPanel.this.putMediaMarker(entry, marker);
        }

        public EntryOrder createNormalEntryOrder() {
            return new NormalEntryOrder(this);
        }

        public EntryOrder createShuffledEntryOrder() {
            return new ShuffledEntryOrder(this);
        }

        public boolean navigateCrateTree(MediaPlayer player) {
            try {
                SwingUtilities.invokeAndWait(MediaTableViewPanel.this.navigateCrateTree);
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }

        public boolean navigatePlayList(MediaPlayer player) {
            try {
                SwingUtilities.invokeAndWait(MediaTableViewPanel.this.navigatePlayList);
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }

        public boolean navigateBack(MediaPlayer player) {
            try {
                SwingUtilities.invokeAndWait(MediaTableViewPanel.this.navigateBack);
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }

        public boolean navigateMove(MediaPlayer player, int amount) {
            try {
                MediaTableViewPanel.this.navigateMove.setAmount(amount);
                SwingUtilities.invokeLater(MediaTableViewPanel.this.navigateMove);
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }

        public boolean navigatePush(MediaPlayer player) {
            try {
                SwingUtilities.invokeLater(new NavigatePush(player));
                return true;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return false;
            }
        }
    }

    protected class DefaultEntryActionWorker
    implements Runnable {
        private MediaPlayer player;
        private MediaCrateEntry entry;
        private int index;

        public DefaultEntryActionWorker(MediaPlayer player, MediaCrateEntry entry, int index) {
            this.player = player;
            this.entry = entry;
            this.index = index;
        }

        @Override
        public void run() {
            this.player.setCurrentEntry(this.entry, (MediaPlayerContext)MediaTableViewPanel.this.playerContext, this.index);
        }
    }

    protected class DefaultEntryActionHandler
    implements ActionListener {
        protected DefaultEntryActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaPlayer player = null;
            MediaTableViewPanel.this.invokeDefaultEntryAction(player);
        }
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        private BeanContext beanContext = new BeanContextSupport();
        private Collection dropBeans = new ArrayList();

        protected DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (MediaTableViewPanel.this.beanDropSupport == null) {
                return;
            }
            this.dropBeans.clear();
            MediaTableViewPanel.this.beanDropSupport.enumerateDropBeans(this.beanContext, dtde, this.dropBeans);
            if (this.dropBeans.isEmpty()) {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.dropBeans.clear();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (MediaTableViewPanel.this.beanDropSupport == null) {
                return;
            }
            ArrayList temp = new ArrayList();
            boolean searchSuccess = MediaTableViewPanel.this.beanDropSupport.enumerateDropBeans(this.beanContext, dtde, temp);
            if (searchSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
                boolean accepted = false;
                for (Object o : this.dropBeans) {
                    if (o == null || !MediaTableViewPanel.this.beanDropSupport.acceptDropBean(this.beanContext, o) || !this.acceptDropBean(o)) continue;
                    accepted = true;
                    break;
                }
                if (accepted) {
                    dtde.acceptDrag(dtde.getDropAction());
                    return;
                }
                dtde.rejectDrag();
                return;
            }
            dtde.acceptDrag(dtde.getDropAction());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (MediaTableViewPanel.this.beanDropSupport == null) {
                return;
            }
            Transferable trans = dtde.getTransferable();
            int dropAction = dtde.getDropAction();
            Point pos = SwingUtilities.convertPoint((Component)((Object)MediaTableViewPanel.this), dtde.getLocation(), MediaTableViewPanel.this.getJTable());
            ArrayList temp = new ArrayList();
            boolean enumSuccess = MediaTableViewPanel.this.beanDropSupport.enumerateDropBeans(this.beanContext, trans, temp);
            if (enumSuccess) {
                this.dropBeans.clear();
                this.dropBeans.addAll(temp);
            }
            if (!this.dropBeans.isEmpty()) {
                dtde.acceptDrop(dropAction);
                try {
                    MediaTableViewPanel.this.beanDropSupport.dropBeans(this.dropBeans, this.beanContext, dropAction);
                    MediaTableViewPanel.this.dropEntries(this.dropBeans, pos);
                    dtde.dropComplete(true);
                    this.dropBeans.clear();
                    return;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                dtde.rejectDrop();
            }
            catch (InvalidDnDOperationException e) {
                // empty catch block
            }
            dtde.dropComplete(false);
            this.dropBeans.clear();
        }

        protected boolean acceptDropBean(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof File) {
                return true;
            }
            return o instanceof MediaCrateEntry;
        }
    }

    protected class ClipSourceImpl
    implements ClipSource {
        protected ClipSourceImpl() {
        }

        public int getClipAction() {
            return 4;
        }

        public boolean isClipActionSupported(int action) {
            return action == 4;
        }

        public void objectTransferred(Object object, int action) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("objectTransferred: " + object);
            }
        }
    }

    protected class EntryChange {
        protected MediaTableEntry entry;
        protected MutableMediaCrate crate;
        protected int index;
        protected int row;

        public EntryChange(MediaTableEntry entry, MutableMediaCrate crate, int index, int row) {
            this.entry = entry;
            this.crate = crate;
            this.index = index;
            this.row = row;
        }
    }

    protected class EntryInsertEdit
    extends AbstractEntryEdit {
        private static final long serialVersionUID = 5973510275768812838L;

        public EntryInsertEdit(EntryChange[] changes) {
            super(changes);
        }

        @Override
        protected void execute() {
            this.insertEntries(this.changes);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.removeEntries(this.changes);
        }
    }

    protected class EntryRemoveEdit
    extends AbstractEntryEdit {
        private static final long serialVersionUID = -5516295552630612605L;

        public EntryRemoveEdit(EntryChange[] changes) {
            super(changes);
        }

        @Override
        protected void execute() {
            this.removeEntries(this.changes);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.insertEntries(this.changes);
        }
    }

    protected abstract class AbstractEntryEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = -9092957339704860417L;
        protected EntryChange[] changes;

        public AbstractEntryEdit(EntryChange[] changes) {
            this.changes = changes;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        protected abstract void execute();

        protected void removeEntries(EntryChange[] changes) {
            int count = changes.length;
            block0: for (int i = count - 1; i >= 0; --i) {
                EntryChange change = changes[i];
                MutableMediaCrate mmc = change.crate;
                MediaTableEntry mmce = change.entry;
                MediaCrateEntry mce = mmce.getCrateEntry();
                int index = change.index;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Removing entry #" + index + " from crate " + mmc + ": " + mmce.getResource());
                }
                if (index >= 0 && index < mmc.getEntryCount() && mmc.getEntryAt(index) == mce) {
                    mmc.removeEntryAt(index);
                } else {
                    index = mmc.removeEntry(mce);
                    if (index < 0) continue;
                }
                if (MediaTableViewPanel.this.loadedEntryList.remove(mmce)) continue;
                Iterator iter = MediaTableViewPanel.this.loadedEntryList.iterator();
                while (iter.hasNext()) {
                    MediaTableEntry entry = (MediaTableEntry)iter.next();
                    if (entry.getCrateEntry() != mce) continue;
                    iter.remove();
                    continue block0;
                }
            }
            Set selEntries = null;
            MediaTableViewPanel.this.refresh(selEntries, false);
        }

        protected void insertEntries(EntryChange[] changes) {
            int count = changes.length;
            HashSet<MediaTableEntry> selEntries = new HashSet<MediaTableEntry>();
            for (int i = 0; i < count; ++i) {
                EntryChange change = changes[i];
                MutableMediaCrate mmc = change.crate;
                MediaTableEntry mmce = change.entry;
                MediaCrateEntry mce = mmce.getCrateEntry();
                int index = change.index;
                int row = change.row;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Inserting entry #" + index + " into crate " + mmc + ": " + mmce.getResource());
                }
                if (index >= 0 && index <= mmc.getEntryCount()) {
                    mmc.insertEntryAt(mce, index);
                } else {
                    mmc.addEntry(mce);
                }
                if (!MediaTableViewPanel.this.isLoadedCrate((MediaCrate)mmc)) continue;
                int entryCount = MediaTableViewPanel.this.loadedEntryList.size();
                if (row < 0 || row > entryCount) {
                    row = entryCount;
                }
                MediaTableViewPanel.this.loadedEntryList.add(row, mmce);
                selEntries.add(mmce);
            }
            MediaTableViewPanel.this.refresh(selEntries, true);
        }
    }

    protected class Analyzer
    implements Runnable {
        private MediaAnalyzer mediaAnalyzer;
        private List scanEntryList;
        private boolean forceRescan = false;

        public Analyzer(MediaAnalyzer mediaAnalyzer, List scanEntryList, boolean forceRescan) {
            this.mediaAnalyzer = mediaAnalyzer;
            this.scanEntryList = scanEntryList;
            this.forceRescan = forceRescan;
        }

        @Override
        public void run() {
            MediaTableViewPanel.this.analyzeEntries(this.mediaAnalyzer, this.scanEntryList, this.forceRescan);
        }
    }

    protected class Scanner
    implements Runnable {
        private List scanEntryList;
        private int flags;
        private int batch;

        public Scanner(List scanEntryList, int flags, int batch) {
            this.scanEntryList = scanEntryList;
            this.flags = flags;
            this.batch = batch;
        }

        @Override
        public void run() {
            MediaTableViewPanel.this.scanEntries(this.scanEntryList, this.flags, this.batch);
        }
    }

    protected class Refresher
    implements Runnable {
        private final boolean startScanner;

        public Refresher(boolean startScanner) {
            this.startScanner = startScanner;
        }

        @Override
        public void run() {
            MediaTableViewPanel.this.refresh(this.startScanner);
        }
    }

    protected class SelectionManagerImpl
    extends AbstractSelectionManager {
        protected SelectionManagerImpl() {
        }

        public View getView() {
            return MediaTableViewPanel.this.mediaTableView;
        }

        public Perspective getPerspective() {
            return this.getView().getPerspective();
        }

        public Workbench getWorkbench() {
            return this.getPerspective().getWorkbench();
        }

        public void addViewFocusCondition(ViewFocusCondition condition) {
            throw new UnsupportedOperationException();
        }

        public void removeViewFocusCondition(ViewFocusCondition condition) {
        }

        protected synchronized void setSelection(Selection sel) {
            super.setSelection(sel);
        }
    }

    protected class SelectionImpl
    extends AbstractSelection {
        public SelectionImpl(Object source) {
            super(source);
        }

        public TreePath getSelectionPathAt(int i) {
            return null;
        }

        public int removeSelectedObjects() {
            return MediaTableViewPanel.this.removeSelectedEntries(true);
        }

        public int cutSelectedObjects() {
            return MediaTableViewPanel.this.cutSelectedEntries(true);
        }

        public int copySelectedObjects() {
            return MediaTableViewPanel.this.copySelectedEntries();
        }

        public boolean isPasteSupported() {
            return true;
        }

        public int pasteObjects() {
            return MediaTableViewPanel.this.pasteEntries();
        }

        protected void entrySelectionChanged(MediaCrateEntry[] entries) {
            this.clearSelection();
            if (entries != null) {
                this.addSelectedObjects(entries);
            }
        }
    }

    protected class TabBackwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 6261924686961733075L;
        protected static final String ACTION_KEY = "tabBackward";

        protected TabBackwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            manager.focusPreviousComponent();
        }
    }

    protected class TabForwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 7823116515626991825L;
        protected static final String ACTION_KEY = "tabForward";

        protected TabForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            manager.focusNextComponent();
        }
    }

    protected class MoveDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -506375860263520213L;
        protected static final String ACTION_KEY = "moveDown";

        protected MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTableViewPanel.this.moveSelectedEntriesDown();
        }
    }

    protected class MoveUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 2168635371737370042L;
        protected static final String ACTION_KEY = "moveUp";

        protected MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTableViewPanel.this.moveSelectedEntriesUp();
        }
    }

    protected class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 7898931805307047763L;
        protected static final String ACTION_KEY = "redo";

        protected RedoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UndoManager um = MediaTableViewPanel.this.getUndoManager();
            if (um != null && um.canRedo()) {
                um.redo();
            }
        }
    }

    protected class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 5324286413372532505L;
        protected static final String ACTION_KEY = "undo";

        protected UndoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UndoManager um = MediaTableViewPanel.this.getUndoManager();
            if (um != null && um.canUndo()) {
                um.undo();
            }
        }
    }

    protected class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = 4855265781489527483L;
        protected static final String ACTION_KEY = "paste";

        protected PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTableViewPanel.this.pasteEntries();
        }
    }

    protected class CutAction
    extends AbstractAction {
        private static final long serialVersionUID = 8174359384871832609L;
        protected static final String ACTION_KEY = "cut";

        protected CutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean prompt = false;
            MediaTableViewPanel.this.cutSelectedEntries(prompt);
        }
    }

    protected class CopyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1630704627151125327L;
        protected static final String ACTION_KEY = "copy";

        protected CopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTableViewPanel.this.copySelectedEntries();
        }
    }

    protected class ControlDeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = -270312260863040028L;
        protected static final String ACTION_KEY = "controlDelete";

        protected ControlDeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTableViewPanel.this.removeSelectedEntries(false);
        }
    }

    protected class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = -4675379577980186044L;
        protected static final String ACTION_KEY = "delete";

        protected DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTableViewPanel.this.removeSelectedEntries(true);
        }
    }

    protected class SpaceAction
    extends AbstractAction {
        private static final long serialVersionUID = 3859750405677948929L;
        protected static final String ACTION_KEY = "space";

        protected SpaceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTableViewPanel.this.actionShowTablePopupMenu();
        }
    }

    protected class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = -7253927285646306194L;
        protected static final String ACTION_KEY = "enter";

        protected EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTableViewPanel.this.handleEntryActionPerformed();
        }
    }

    protected class ToolContextImpl
    extends AbstractToolContext
    implements MediaTableToolContext {
        public ToolContextImpl() {
            this.initToolContextImpl();
        }

        protected void initToolContextImpl() {
            try {
                BeanProperty entrySelectedProperty = BeanProperty.getBeanProperty((Object)((Object)MediaTableViewPanel.this), (String)MediaTableViewPanel.PROPERTY_ENTRY_SELECTED);
                this.setProperty(MediaTableViewPanel.PROPERTY_ENTRY_SELECTED, (Property)entrySelectedProperty);
                BeanProperty singleEntrySelectedProperty = BeanProperty.getBeanProperty((Object)((Object)MediaTableViewPanel.this), (String)MediaTableViewPanel.PROPERTY_SINGLE_ENTRY_SELECTED);
                this.setProperty(MediaTableViewPanel.PROPERTY_SINGLE_ENTRY_SELECTED, (Property)singleEntrySelectedProperty);
                BeanProperty entryMoveUpEnabledProperty = BeanProperty.getBeanProperty((Object)((Object)MediaTableViewPanel.this), (String)MediaTableViewPanel.PROPERTY_ENTRY_MOVE_UP_ENABLED);
                this.setProperty(MediaTableViewPanel.PROPERTY_ENTRY_MOVE_UP_ENABLED, (Property)entryMoveUpEnabledProperty);
                BeanProperty entryMoveDownEnabledProperty = BeanProperty.getBeanProperty((Object)((Object)MediaTableViewPanel.this), (String)MediaTableViewPanel.PROPERTY_ENTRY_MOVE_DOWN_ENABLED);
                this.setProperty(MediaTableViewPanel.PROPERTY_ENTRY_MOVE_DOWN_ENABLED, (Property)entryMoveDownEnabledProperty);
                SelectionCondition.ObjectsSelected objectsSelectedCondition = new SelectionCondition.ObjectsSelected();
                MediaTableViewPanel.this.getSelectionManager().addSelectionCondition((SelectionCondition)objectsSelectedCondition);
                this.setProperty("anyObjectSelected", (Property)objectsSelectedCondition);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public MediaTableView getMediaTableView() {
            return MediaTableViewPanel.this.mediaTableView;
        }

        @Override
        public MediaTableViewPanel getMediaTableViewPanel() {
            return MediaTableViewPanel.this;
        }

        public SelectionManager getSelectionManager() {
            return MediaTableViewPanel.this.selectionManager;
        }

        @Override
        public void removeSelectedEntries() {
            MediaTableViewPanel.this.removeSelectedEntries(true);
        }

        @Override
        public boolean isEntrySelected() {
            return !MediaTableViewPanel.this.getSelectionModel().isSelectionEmpty();
        }

        @Override
        public int[] getSelectedEntryRows() {
            return MediaTableViewPanel.this.getSelectedRows();
        }

        @Override
        public MediaCrateEntry getEntryAt(int row) {
            return MediaTableViewPanel.this.getMediaTableEntryAt(row);
        }

        @Override
        public void showEntryPropertiesDialog() {
            MediaTableViewPanel.this.showEntryPropertiesDialog();
        }

        @Override
        public void copySelectedPathsToClipboard() {
            MediaTableViewPanel.this.copySelectedPathsToClipboard();
        }

        @Override
        public void openSelectedFileLocation() {
            MediaTableViewPanel.this.openSelectedFileLocation();
        }

        @Override
        public void openRelocateFilesDialog() {
            MediaTableViewPanel.this.openRelocateFilesDialog();
        }

        @Override
        public void removeMissingFileEntries() {
            MediaTableViewPanel.this.removeMissingFileEntries();
        }

        @Override
        public void detectDuplicateEntries() {
            MediaTableViewPanel.this.detectDuplicateEntries();
        }

        @Override
        public void rescanSelectedEntries() {
            MediaTableViewPanel.this.rescanSelectedEntries();
        }

        @Override
        public void analyzeSelectedEntries() {
            boolean forceRescan = false;
            MediaTableViewPanel.this.analyzeSelectedEntries(forceRescan);
        }

        @Override
        public void openAdvancedSearchDialog() {
            MediaTableViewPanel.this.openAdvancedSearchDialog();
        }

        @Override
        public void moveSelectedEntriesUp() {
            MediaTableViewPanel.this.moveSelectedEntriesUp();
        }

        @Override
        public void moveSelectedEntriesDown() {
            MediaTableViewPanel.this.moveSelectedEntriesDown();
        }

        @Override
        public void setSimpleSearchText(String text) {
            MediaTableViewPanel.this.setSimpleSearchText(text);
        }

        @Override
        public void setAdvancedSearchOptions(AdvancedSearchOptions options) {
            MediaTableViewPanel.this.setAdvancedSearchOptions(options);
        }

        @Override
        public void resetSearchFilter() {
            MediaTableViewPanel.this.resetSearchFilter();
        }

        @Override
        public void resetSortingOrder() {
            MediaTableViewPanel.this.resetSortingOrder();
        }

        @Override
        public void applySortingOrder() {
            MediaTableViewPanel.this.applySortingOrder();
        }

        @Override
        public EntryTableColumnProvider[] getEntryTableColumnProviders() {
            return MediaTableViewPanel.this.getEntryTableColumnProviders();
        }

        @Override
        public boolean isEntryTableColumnProviderEnabled(EntryTableColumnProvider columnProvider) {
            return MediaTableViewPanel.this.isColumnProviderEnabled(columnProvider);
        }

        @Override
        public void setEntryTableColumnProviderEnabled(EntryTableColumnProvider columnProvider, boolean enabled) {
            MediaTableViewPanel.this.setColumnProviderEnabled(columnProvider, enabled);
        }

        @Override
        public boolean increaseSelectedUserRating() {
            return MediaTableViewPanel.this.increaseSelectedUserRating();
        }

        @Override
        public boolean decreaseSelectedUserRating() {
            return MediaTableViewPanel.this.decreaseSelectedUserRating();
        }

        @Override
        public boolean setSelectedUserRating(double newRating) {
            return MediaTableViewPanel.this.setSelectedUserRating(newRating);
        }

        @Override
        public boolean setUserRating(MutableMediaEntry entry, double newRating) {
            return MediaTableViewPanel.this.setUserRating(entry, newRating);
        }

        @Override
        public boolean setUserComment(MutableMediaEntry entry, String newComment) {
            return MediaTableViewPanel.this.updateUserComment(entry, newComment);
        }

        @Override
        public boolean setMediaMarkers(MutableMediaEntry entry, MediaMarker[] markers) {
            return MediaTableViewPanel.this.updateMediaMarkers(entry, markers);
        }

        @Override
        public boolean putMediaMarker(MutableMediaEntry entry, MediaMarker marker) {
            return MediaTableViewPanel.this.putMediaMarker(entry, marker);
        }

        @Override
        public void layoutTableToFitWindow() {
            MediaTableViewPanel.this.setFitColumnsToWindow(true);
        }

        @Override
        public void layoutTableToFitValues() {
            MediaTableViewPanel.this.setFitColumnsToWindow(false);
        }

        @Override
        public void addRemoteResource() {
            MediaTableViewPanel.this.addRemoteResource();
        }

        @Override
        public MediaPlayer[] getMediaPlayers() {
            return MediaTableViewPanel.this.getMediaPlayers();
        }

        @Override
        public MediaPlayer getSelectedMediaPlayer() {
            return MediaTableViewPanel.this.getMediaPlayer();
        }

        @Override
        public void setSelectedMediaPlayer(MediaPlayer player) {
            MediaTableViewPanel.this.getMediaManagerPanel().setMediaPlayer(player);
        }

        @Override
        public void invokeDefaultEntryAction() {
            MediaPlayer player = null;
            MediaTableViewPanel.this.invokeDefaultEntryAction(player);
        }

        @Override
        public void showTableExportWizard() {
            MediaTableViewPanel.this.showTableExportWizard();
        }

        @Override
        public void showTableFontDialog() {
            MediaManagerPanel mmp = MediaTableViewPanel.this.mediaManagerPanel;
            if (mmp != null) {
                mmp.showFontDialog();
            }
        }

        @Override
        public String[] enumerateFileFormats() {
            return MediaTableViewPanel.this.enumerateFileFormats();
        }
    }
}

