/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.BeansToolkit;
import com.spacekiller.util.Resource;
import com.spacekiller.util.Tools;
import com.spacekiller.util.beans.AbstractSelection;
import com.spacekiller.util.beans.BeanDropSupport;
import com.spacekiller.util.beans.BeanProperty;
import com.spacekiller.util.beans.ClipSource;
import com.spacekiller.util.beans.ClipboardManager;
import com.spacekiller.util.beans.Property;
import com.spacekiller.util.beans.Selection;
import com.spacekiller.util.media.DefaultMediaCrate;
import com.spacekiller.util.media.DefaultMediaCrateEntry;
import com.spacekiller.util.media.DirectoryMediaCrate;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaPlayer;
import com.spacekiller.util.media.MutableMediaCrate;
import com.spacekiller.util.media.library.BaseMediaContext;
import com.spacekiller.util.media.library.CrateFile;
import com.spacekiller.util.media.library.CrateFileMediaCrate;
import com.spacekiller.util.media.library.m3u.M3uCrateFile;
import com.spacekiller.util.media.library.m3u.M3uExport;
import com.spacekiller.util.media.library.m3u.M3uMediaCrate;
import com.spacekiller.util.media.library.remote.RemoteMediaCrate;
import com.spacekiller.util.media.library.remote.RemoteMediaCratePanel;
import com.spacekiller.util.media.library.serato.SeratoCrateFile;
import com.spacekiller.util.media.library.serato.SeratoExport;
import com.spacekiller.util.media.library.serato.SeratoMediaCrate;
import com.spacekiller.util.media.library.serato.SeratoUtil;
import com.spacekiller.util.media.manager.CrateTreeCellRenderer;
import com.spacekiller.util.media.manager.CrateTreeNode;
import com.spacekiller.util.media.manager.CratesFileFilter;
import com.spacekiller.util.media.manager.DefaultCrateTreeModel;
import com.spacekiller.util.media.manager.MediaCratePropertiesPanel;
import com.spacekiller.util.media.manager.MediaManagerPanel;
import com.spacekiller.util.media.manager.MediaManagerToolContext;
import com.spacekiller.util.media.manager.MediaTreeToolContext;
import com.spacekiller.util.media.manager.MediaTreeView;
import com.spacekiller.util.tooling.AbstractToolContext;
import com.spacekiller.util.workbench.AbstractSelectionManager;
import com.spacekiller.util.workbench.Perspective;
import com.spacekiller.util.workbench.SelectionCondition;
import com.spacekiller.util.workbench.SelectionManager;
import com.spacekiller.util.workbench.View;
import com.spacekiller.util.workbench.ViewFocusCondition;
import com.spacekiller.util.workbench.Workbench;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextSupport;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;

public class MediaTreeViewPanel
extends JPanel {
    private static final long serialVersionUID = -5452791252841257157L;
    private static final Logger logger = Logger.getLogger(MediaTreeViewPanel.class.getName());
    public static final String PROPERTY_CRATE_SELECTED = "crateSelected";
    public static final String PROPERTY_SINGLE_CRATE_SELECTED = "singleCrateSelected";
    private static final String PROPERTY_AUTO_LOAD_SELECTED_CRATES = "autoLoadSelectedCrates";
    private final CratesFileFilter cratesFileFilter = new CratesFileFilter();
    private MediaTreeView mediaTreeView;
    private MediaTreeToolContext mediaTreeToolContext;
    private MediaManagerToolContext mediaManagerToolContext;
    private MediaLibrary mediaLibrary;
    private MutableMediaCrate rootCrate;
    private DefaultCrateTreeModel crateTreeModel;
    private boolean autoLoadSelectedCrates = true;
    private boolean crateSelected;
    private boolean singleCrateSelected;
    private JPopupMenu cratePopupMenu;
    private SelectionManager selectionManager;
    private SelectionImpl selection;
    private File currentDirectory;
    private CrateMouseHandler crateMouseHandler = new CrateMouseHandler();
    private BeansToolkit beansToolkit;
    private ClipboardManager clipboardManager;
    private BeanDropSupport beanDropSupport;
    private UndoManager undoManager;
    private JTree treeCrates;
    private CrateTreeCellRenderer treeRenderer;
    private Font normalFont;
    private Font activeFont;

    public MediaTreeViewPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JScrollPane scrollPaneCrates = new JScrollPane();
        GridBagConstraints gbc_scrollPaneCrates = new GridBagConstraints();
        gbc_scrollPaneCrates.weightx = 1.0;
        gbc_scrollPaneCrates.weighty = 1.0;
        gbc_scrollPaneCrates.fill = 1;
        gbc_scrollPaneCrates.gridx = 0;
        gbc_scrollPaneCrates.gridy = 0;
        this.add((Component)scrollPaneCrates, gbc_scrollPaneCrates);
        this.treeCrates = new JTree();
        this.treeCrates.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                MediaTreeViewPanel.this.handleTreeExpanded(event);
            }
        });
        this.treeCrates.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) {
                MediaTreeViewPanel.this.handleTreeWillExpand(event);
            }
        });
        this.treeCrates.setShowsRootHandles(true);
        this.treeCrates.setRootVisible(false);
        this.treeCrates.setOpaque(false);
        this.treeCrates.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MediaTreeViewPanel.this.handleCrateSelected();
            }
        });
        scrollPaneCrates.setViewportView(this.treeCrates);
        this.initMediaTreeViewPanel();
    }

    protected void initMediaTreeViewPanel() {
        this.activeFont = this.normalFont = this.getFont();
        this.crateTreeModel = new DefaultCrateTreeModel();
        this.treeCrates.setModel(this.crateTreeModel);
        this.treeRenderer = new CrateTreeCellRenderer();
        this.treeRenderer.setNormalFont(this.normalFont);
        this.treeRenderer.setActiveFont(this.activeFont);
        this.treeRenderer.setDefaultCrateIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/media-crate_icon16.png"));
        this.treeRenderer.setDirectoryCrateIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/directory-crate_icon16.png"));
        this.treeRenderer.setCrateFileIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/crate-file_icon16.png"));
        this.treeRenderer.setRemoteCrateIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/remote_crate_icon16.png"));
        this.treeRenderer.setRemoteSubCrateIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/remote_subcrate_icon16.png"));
        this.treeRenderer.setSeratoCrateIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/serato-crate_icon16.png"));
        this.treeRenderer.setM3uCrateIcon(Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/m3u-crate_icon16.png"));
        this.treeCrates.setCellRenderer(this.treeRenderer);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this.treeCrates);
        this.treeCrates.addMouseListener(this.crateMouseHandler);
        this.treeCrates.setDropTarget(new DropTarget(this.treeCrates, new DropTargetHandler()));
        this.initActionMap();
        this.initInputMap();
        this.handleCrateSelected();
    }

    protected void initActionMap() {
        ActionMap actionMap = this.treeCrates.getActionMap();
        if (actionMap == null) {
            return;
        }
        actionMap.put("enter", new EnterAction());
        actionMap.put("space", new SpaceAction());
        actionMap.put("delete", new DeleteAction());
        actionMap.put("controlDelete", new ControlDeleteAction());
        actionMap.put("copy", new CopyAction());
        actionMap.put("cut", new CutAction());
        actionMap.put("paste", new PasteAction());
        actionMap.put("undo", new UndoAction());
        actionMap.put("redo", new RedoAction());
        actionMap.put("moveUp", new MoveUpAction());
        actionMap.put("moveDown", new MoveDownAction());
    }

    protected void initInputMap() {
        InputMap inputMap = this.treeCrates.getInputMap(1);
        if (inputMap == null) {
            return;
        }
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "enter");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "delete");
        inputMap.put(KeyStroke.getKeyStroke(127, 128), "controlDelete");
        inputMap.put(KeyStroke.getKeyStroke(67, 128), "copy");
        inputMap.put(KeyStroke.getKeyStroke(88, 128), "cut");
        inputMap.put(KeyStroke.getKeyStroke(86, 128), "paste");
        inputMap.put(KeyStroke.getKeyStroke(90, 128), "undo");
        inputMap.put(KeyStroke.getKeyStroke(89, 128), "redo");
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "space");
        inputMap.put(KeyStroke.getKeyStroke(38, 128), "moveUp");
        inputMap.put(KeyStroke.getKeyStroke(40, 128), "moveDown");
    }

    protected MutableMediaCrate getTargetSelectionCrate() {
        CrateTreeNode node;
        MediaCrate mc;
        Object comp;
        TreePath leadPath = this.treeCrates.getLeadSelectionPath();
        if (leadPath != null && (comp = leadPath.getLastPathComponent()) != null && comp instanceof CrateTreeNode && (mc = (node = (CrateTreeNode)comp).getCrate()) != null && mc instanceof MutableMediaCrate) {
            return (MutableMediaCrate)mc;
        }
        return this.rootCrate;
    }

    public MediaCrate addNewCrate() {
        MutableMediaCrate parent = this.getTargetSelectionCrate();
        if (parent == null) {
            return null;
        }
        MediaLibrary library = this.getMediaLibrary();
        MediaContext context = library.getContext();
        String id = null;
        String name = this.generateCrateName((MediaCrate)parent, "New Crate");
        MediaCrate crate = parent.newCrate(id, name);
        if (crate == null) {
            return null;
        }
        context.registerMediaCrate(crate);
        MutableMediaCrate[] parents = new MutableMediaCrate[]{parent};
        MediaCrate[] crates = new MediaCrate[]{crate};
        int[] indexes = new int[]{parent.getCrateCount()};
        CrateInsertEdit edit = new CrateInsertEdit(parents, crates, indexes);
        edit.execute();
        UndoManager um = this.getUndoManager();
        if (um != null) {
            um.addEdit(edit);
        }
        return crate;
    }

    protected String generateCrateName(MediaCrate parent, String namePrefix) {
        if (parent == null) {
            return namePrefix;
        }
        HashSet<String> names = new HashSet<String>();
        int num = parent.getCrateCount();
        for (int i = 0; i < num; ++i) {
            names.add(parent.getCrateAt(i).getName());
        }
        int max = 1000;
        for (int i = 1; i <= max; ++i) {
            String name = namePrefix;
            if (i > 1) {
                name = name + Integer.toString(i);
            }
            if (names.contains(name)) continue;
            return name;
        }
        return namePrefix + System.currentTimeMillis();
    }

    protected MediaCrate[] addDirectoryCrate() {
        try {
            MediaLibrary lib = this.mediaLibrary;
            if (lib == null) {
                return null;
            }
            MutableMediaCrate parent = this.getTargetSelectionCrate();
            if (parent == null) {
                return null;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Open Crate Directory");
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(true);
            int rc = chooser.showOpenDialog(this);
            if (rc != 0) {
                return null;
            }
            File[] files = chooser.getSelectedFiles();
            if (files == null || files.length < 1) {
                return null;
            }
            int num = files.length;
            MutableMediaCrate[] parents = new MutableMediaCrate[num];
            MediaCrate[] crates = new MediaCrate[num];
            int[] indexes = new int[num];
            int index = parent.getCrateCount();
            for (int i = 0; i < num; ++i) {
                String path;
                File dir = files[i];
                String name = path = dir.getPath();
                String id = path;
                boolean recursive = true;
                DirectoryMediaCrate crate = new DirectoryMediaCrate(id, name, path, recursive);
                parents[i] = parent;
                crates[i] = crate;
                indexes[i] = index++;
            }
            CrateInsertEdit edit = new CrateInsertEdit(parents, crates, indexes);
            edit.execute();
            UndoManager um = this.getUndoManager();
            if (um != null) {
                um.addEdit(edit);
            }
            return crates;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected MediaCrate[] addFileCrate() {
        try {
            int rc;
            MutableMediaCrate parent = this.getTargetSelectionCrate();
            if (parent == null) {
                return null;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Insert Crates File");
            chooser.setMultiSelectionEnabled(true);
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(this.cratesFileFilter);
            if (this.currentDirectory != null) {
                chooser.setCurrentDirectory(this.currentDirectory);
            }
            if ((rc = chooser.showOpenDialog(this)) != 0) {
                return null;
            }
            File[] files = chooser.getSelectedFiles();
            if (files == null || files.length < 1) {
                return null;
            }
            this.currentDirectory = chooser.getCurrentDirectory();
            int num = files.length;
            LinkedList<MediaCrate> crateList = new LinkedList<MediaCrate>();
            for (int i = 0; i < num; ++i) {
                File file = files[i];
                MediaCrate crate = this.prepareCrate(file);
                if (crate == null) {
                    throw new StreamCorruptedException("Invalid media crate file: " + file);
                }
                crateList.add(crate);
            }
            if (crateList.isEmpty()) {
                return null;
            }
            MediaCrate[] crates = crateList.toArray(new MediaCrate[crateList.size()]);
            num = crates.length;
            MutableMediaCrate[] parents = new MutableMediaCrate[num];
            int[] indexes = new int[num];
            int index = parent.getCrateCount();
            for (int i = 0; i < num; ++i) {
                parents[i] = parent;
                indexes[i] = index++;
            }
            CrateInsertEdit edit = new CrateInsertEdit(parents, crates, indexes);
            edit.execute();
            UndoManager um = this.getUndoManager();
            if (um != null) {
                um.addEdit(edit);
            }
            return crates;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    protected MediaCrate[] addRemoteCrate() {
        try {
            MutableMediaCrate parent = this.getTargetSelectionCrate();
            if (parent == null) {
                return null;
            }
            MediaLibrary parentLibrary = parent.getLibrary();
            if (parentLibrary == null) {
                return null;
            }
            BaseMediaContext context = null;
            MediaContext mc = parentLibrary.getContext();
            if (mc != null && mc instanceof BaseMediaContext) {
                context = (BaseMediaContext)mc;
            }
            if (context == null) {
                return null;
            }
            JPanel parentComponent = null;
            if (this.mediaManagerToolContext != null) {
                parentComponent = this.mediaManagerToolContext.getMediaManagerPanel();
            }
            if (parentComponent == null) {
                parentComponent = this;
            }
            RemoteMediaCratePanel panel = new RemoteMediaCratePanel();
            panel.setMediaContext(context);
            RemoteMediaCrate remoteCrate = panel.showRemoteMediaCrateDialog((Component)parentComponent);
            if (remoteCrate == null) {
                return null;
            }
            context.registerMediaCrate((MediaCrate)remoteCrate);
            MediaCrate[] crates = new MediaCrate[]{remoteCrate};
            int num = crates.length;
            MutableMediaCrate[] parents = new MutableMediaCrate[num];
            int[] indexes = new int[num];
            int index = parent.getCrateCount();
            for (int i = 0; i < num; ++i) {
                parents[i] = parent;
                indexes[i] = index++;
            }
            CrateInsertEdit edit = new CrateInsertEdit(parents, crates, indexes);
            edit.execute();
            UndoManager um = this.getUndoManager();
            if (um != null) {
                um.addEdit(edit);
            }
            return crates;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public synchronized int removeSelectedCrates(boolean prompt) {
        int messageType;
        int optionType;
        String message;
        int rc;
        String title;
        LinkedList crates = new LinkedList();
        this.getSelectedCrates(crates);
        if (crates.isEmpty()) {
            return 0;
        }
        LinkedList<MutableMediaCrate> parentList = new LinkedList<MutableMediaCrate>();
        LinkedList<MediaCrate> crateList = new LinkedList<MediaCrate>();
        int[] indexArray = new int[crates.size()];
        int crateCount = 0;
        int directoryCount = 0;
        int immutableCount = 0;
        for (MediaCrate crate : crates) {
            MediaCrate parent = crate.getParent();
            if (parent == null) continue;
            if (parent instanceof DirectoryMediaCrate) {
                ++directoryCount;
                continue;
            }
            int index = parent.getCrateIndex(crate);
            if (index < 0) continue;
            if (parent instanceof MutableMediaCrate) {
                MutableMediaCrate mutable = (MutableMediaCrate)parent;
                parentList.add(mutable);
                crateList.add(crate);
                indexArray[crateCount] = index;
                ++crateCount;
                continue;
            }
            ++immutableCount;
        }
        if (directoryCount > 0 || immutableCount > 0) {
            title = "Cannot Remove Crates";
            String message2 = "Cannot remove crates from an immutable directory parent crate !";
            int messageType2 = 2;
            JOptionPane.showMessageDialog(this, message2, title, messageType2);
            return 0;
        }
        if (crateCount < 1) {
            return 0;
        }
        if (prompt && (rc = JOptionPane.showConfirmDialog(this, message = "Are you sure to remove the selected crate(s) ?", title = "Remove selected crate(s)", optionType = 2, messageType = 3)) != 0) {
            return 0;
        }
        MutableMediaCrate[] parentArray = parentList.toArray(new MutableMediaCrate[parentList.size()]);
        MediaCrate[] crateArray = crateList.toArray(new MediaCrate[crateList.size()]);
        CrateRemoveEdit edit = new CrateRemoveEdit(parentArray, crateArray, indexArray);
        edit.execute();
        UndoManager um = this.getUndoManager();
        if (um != null) {
            um.addEdit(edit);
        }
        return crateCount;
    }

    public synchronized int cutSelectedCrates(boolean prompt) {
        LinkedList crates = new LinkedList();
        this.getSelectedCrates(crates);
        if (crates.isEmpty()) {
            return 0;
        }
        int num = crates.size();
        ArrayList<MediaCrate> beans = new ArrayList<MediaCrate>(num);
        for (MediaCrate crate : crates) {
            if (crate == null) continue;
            beans.add(crate);
        }
        ClipboardOwner clipOwner = new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        };
        ClipSourceImpl clipSource = new ClipSourceImpl();
        ClipboardManager cm = this.getClipboardManager();
        cm.setContents(beans, clipOwner, (ClipSource)clipSource);
        return this.removeSelectedCrates(prompt);
    }

    public synchronized int copySelectedCrates() {
        LinkedList crates = new LinkedList();
        this.getSelectedCrates(crates);
        if (crates.isEmpty()) {
            return 0;
        }
        int num = crates.size();
        ArrayList<MediaCrate> clones = new ArrayList<MediaCrate>(num);
        for (MediaCrate crate : crates) {
            if (crate == null) continue;
            try {
                MediaCrate clone = crate.cloneMediaCrate();
                if (clone == null) continue;
                clones.add(clone);
            }
            catch (CloneNotSupportedException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        ClipboardOwner clipOwner = new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        };
        ClipSourceImpl clipSource = new ClipSourceImpl();
        ClipboardManager cm = this.getClipboardManager();
        cm.setContents(clones, clipOwner, (ClipSource)clipSource);
        return clones.size();
    }

    public synchronized int pasteCrates() {
        ClipboardManager cm = this.getClipboardManager();
        if (cm == null) {
            return 0;
        }
        MutableMediaCrate parent = this.getTargetSelectionCrate();
        if (parent == null) {
            return 0;
        }
        try {
            Collection beans = cm.getObjects();
            if (beans == null || beans.isEmpty()) {
                return 0;
            }
            return this.dropCrates(beans, parent);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return 0;
        }
    }

    public synchronized int dropCrates(Collection beans, MutableMediaCrate target) {
        try {
            MediaCrate[] crateArray = this.prepareCrates(beans);
            int crateCount = crateArray.length;
            if (crateCount < 1) {
                return 0;
            }
            MutableMediaCrate[] parentArray = new MutableMediaCrate[crateCount];
            int[] indexArray = new int[crateCount];
            int index = target.getCrateCount();
            for (int i = 0; i < crateCount; ++i) {
                parentArray[i] = target;
                indexArray[i] = index++;
            }
            CrateInsertEdit edit = new CrateInsertEdit(parentArray, crateArray, indexArray);
            edit.execute();
            UndoManager um = this.getUndoManager();
            if (um != null) {
                um.addEdit(edit);
            }
            return crateCount;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return 0;
        }
    }

    protected MediaCrate[] prepareCrates(Collection beans) throws IOException {
        LinkedList crateList = new LinkedList();
        for (Object obj : beans) {
            if (obj == null) continue;
            this.prepareCrates(obj, crateList);
        }
        return crateList.toArray(new MediaCrate[crateList.size()]);
    }

    protected void prepareCrates(Object obj, Collection dstCrates) throws IOException {
        if (obj == null) {
            return;
        }
        if (obj instanceof MediaCrate) {
            MediaCrate crate = (MediaCrate)obj;
            if (crate.getParent() != null) {
                try {
                    crate = crate.cloneMediaCrate();
                }
                catch (CloneNotSupportedException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (crate != null) {
                dstCrates.add(crate);
            }
            return;
        }
        if (obj instanceof File) {
            File f = (File)obj;
            MediaCrate crate = this.prepareCrate(f);
            if (crate != null) {
                dstCrates.add(crate);
            }
            return;
        }
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            for (Object fileObj : coll) {
                File f;
                MediaCrate crate;
                if (fileObj == null || !(fileObj instanceof File) || (crate = this.prepareCrate(f = (File)fileObj)) == null) continue;
                dstCrates.add(crate);
            }
            return;
        }
        logger.warning("Unsupported crate object: (" + obj.getClass() + ") " + obj);
    }

    protected MediaCrate prepareCrate(File file) throws IOException {
        if (file.exists()) {
            String path = file.getPath();
            if (file.isDirectory()) {
                boolean recursive = true;
                String id = path;
                String name = path;
                return new DirectoryMediaCrate(id, name, path, recursive);
            }
            if (CrateFile.isMediaCrateFile((File)file)) {
                MediaLibrary library = this.getMediaLibrary();
                String id = path;
                return new CrateFileMediaCrate(id, (Component)this, library, file);
            }
            if (SeratoCrateFile.isSeratoCrateFile((File)file)) {
                String id = path;
                return new SeratoMediaCrate(id, file);
            }
            if (M3uCrateFile.isM3uCrateFile((File)file)) {
                String id = path;
                return new M3uMediaCrate(id, file);
            }
        }
        return null;
    }

    public void refreshSelectedCrates() {
        LinkedList crates = new LinkedList();
        this.getSelectedCrates(crates);
        if (crates.isEmpty()) {
            return;
        }
        for (MediaCrate crate : crates) {
            if (crate == null) continue;
            crate.refresh();
        }
    }

    public void actionExportCrateFile() {
        try {
            int messageType;
            int optionType;
            String title;
            String message;
            int rc;
            LinkedList crates = new LinkedList();
            this.getSelectedCrates(crates);
            if (crates.isEmpty()) {
                return;
            }
            MediaCrate[] selCrates = crates.toArray(new MediaCrate[crates.size()]);
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Export Crates");
            chooser.setDialogType(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(this.cratesFileFilter);
            String proposedName = "export.crates";
            if (proposedName != null) {
                chooser.setSelectedFile(new File(proposedName));
            }
            if (this.currentDirectory != null) {
                chooser.setCurrentDirectory(this.currentDirectory);
            }
            if ((rc = chooser.showSaveDialog(this)) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            this.currentDirectory = chooser.getCurrentDirectory();
            String path = file.getPath();
            if (!path.toLowerCase().endsWith(".crates".toLowerCase())) {
                path = path + ".crates";
                file = new File(path);
            }
            if (file.exists() && (rc = JOptionPane.showConfirmDialog(this, message = "Are you sure to overwrite the existing file ?", title = "Overwrite Existing File ?", optionType = 2, messageType = 3)) != 0) {
                return;
            }
            MediaLibrary library = this.getMediaLibrary();
            MediaContext context = library.getContext();
            CrateFile crateFile = new CrateFile(file, library, context, (Component)this);
            crateFile.writeMediaCrateFile(selCrates);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void actionImportCrateFile() {
        try {
            MediaContext context;
            MediaLibrary library;
            CrateFile crateFile;
            int rc;
            CrateTreeNode node;
            MediaCrate selCrate;
            MutableMediaCrate targetCrate = null;
            TreePath selCratePath = this.treeCrates.getSelectionPath();
            if (selCratePath != null && (selCrate = (node = (CrateTreeNode)selCratePath.getLastPathComponent()).getCrate()) != null && selCrate instanceof MutableMediaCrate) {
                targetCrate = (MutableMediaCrate)selCrate;
            }
            if (targetCrate == null) {
                targetCrate = this.rootCrate;
            }
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Import Crates");
            chooser.setDialogType(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(this.cratesFileFilter);
            if (this.currentDirectory != null) {
                chooser.setCurrentDirectory(this.currentDirectory);
            }
            if ((rc = chooser.showOpenDialog(this)) != 0) {
                return;
            }
            File file = chooser.getSelectedFile();
            if (file == null) {
                return;
            }
            this.currentDirectory = chooser.getCurrentDirectory();
            MediaCrate[] crates = null;
            if (CrateFile.isMediaCrateFile((File)file) && (crates = (crateFile = new CrateFile(file, library = this.getMediaLibrary(), context = library.getContext(), (Component)this)).readMediaCrateFile()) == null) {
                return;
            }
            if (crates == null) {
                throw new StreamCorruptedException("Invalid media crate file: " + file);
            }
            int num = crates.length;
            if (num < 1) {
                return;
            }
            MutableMediaCrate[] parents = new MutableMediaCrate[num];
            int[] indexes = new int[num];
            int index = targetCrate.getCrateCount();
            for (int i = 0; i < num; ++i) {
                parents[i] = targetCrate;
                indexes[i] = index++;
            }
            CrateInsertEdit edit = new CrateInsertEdit(parents, crates, indexes);
            edit.execute();
            UndoManager um = this.getUndoManager();
            if (um != null) {
                um.addEdit(edit);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void moveSelectedCratesUp() {
        this.moveSelectedCrates(-1);
    }

    public void moveSelectedCratesDown() {
        this.moveSelectedCrates(1);
    }

    public synchronized void moveSelectedCrates(int amount) {
        LinkedList crates = new LinkedList();
        this.getSelectedCrates(crates);
        if (crates.isEmpty()) {
            return;
        }
        int num = crates.size();
        MediaCrate[] crateArray = crates.toArray(new MediaCrate[num]);
        MutableMediaCrate[] parents = new MutableMediaCrate[num];
        int[] indexes = new int[num];
        int[] newIndexes = new int[num];
        for (int i = 0; i < num; ++i) {
            int newIndex;
            int index;
            block7: {
                block6: {
                    MediaCrate crate = crateArray[i];
                    MediaCrate parent = crate.getParent();
                    if (parent == null || !(parent instanceof MutableMediaCrate)) break block6;
                    parents[i] = (MutableMediaCrate)parent;
                    index = parent.getCrateIndex(crate);
                    if (index >= 0 && (newIndex = index + amount) >= 0 && newIndex <= parent.getCrateCount()) break block7;
                }
                return;
            }
            indexes[i] = index;
            newIndexes[i] = newIndex;
        }
        CrateMoveEdit edit = new CrateMoveEdit(parents, crateArray, indexes, parents, newIndexes);
        edit.execute();
        UndoManager um = this.getUndoManager();
        if (um != null) {
            um.addEdit(edit);
        }
    }

    protected void showCratePopupMenu(int x, int y) {
        TreePath path = this.treeCrates.getPathForLocation(x, y);
        if (path == null) {
            this.treeCrates.clearSelection();
        } else if (!this.treeCrates.isPathSelected(path)) {
            this.treeCrates.setSelectionPath(path);
        }
        this.cratePopupMenu.show(this.treeCrates, x, y);
    }

    public void getSelectedCrates(Collection dst) {
        TreePath[] sel = this.treeCrates.getSelectionPaths();
        if (sel == null) {
            return;
        }
        int num = sel.length;
        if (num < 1) {
            return;
        }
        for (int i = 0; i < num; ++i) {
            TreePath path = sel[i];
            Object comp = path.getLastPathComponent();
            if (comp == null || !(comp instanceof CrateTreeNode)) continue;
            CrateTreeNode node = (CrateTreeNode)comp;
            dst.add(node.getCrate());
        }
    }

    public void setSelectedCrates(MediaCrate[] crates) {
        if (crates == null) {
            this.treeCrates.clearSelection();
            return;
        }
        int num = crates.length;
        if (num < 1) {
            this.treeCrates.clearSelection();
            return;
        }
        LinkedList<TreePath> pathList = new LinkedList<TreePath>();
        for (int i = 0; i < num; ++i) {
            MediaCrate crate = crates[i];
            CrateTreeNode node = this.crateTreeModel.getCrateTreeNode(crate);
            if (node == null) continue;
            pathList.add(new TreePath(this.crateTreeModel.getPathToRoot(node)));
        }
        TreePath[] paths = pathList.toArray(new TreePath[pathList.size()]);
        this.treeCrates.setSelectionPaths(paths);
        if (paths.length > 0) {
            this.treeCrates.scrollPathToVisible(paths[0]);
        }
        this.treeCrates.requestFocus();
    }

    protected void setSelectedCratesLater(final MediaCrate[] crates) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MediaTreeViewPanel.this.setSelectedCrates(crates);
            }
        });
    }

    protected void handleCrateSelected() {
        LinkedList crates = new LinkedList();
        this.getSelectedCrates(crates);
        int num = crates.size();
        this.setCrateSelected(num > 0);
        this.setSingleCrateSelected(num == 1);
        this.getSelection().crateSelectionChanged(crates);
        if (this.autoLoadSelectedCrates && this.mediaManagerToolContext != null) {
            this.mediaManagerToolContext.loadSelectedCrates();
        }
    }

    public boolean isCrateSelected() {
        return this.crateSelected;
    }

    protected synchronized void setCrateSelected(boolean crateSelected) {
        if (this.crateSelected == crateSelected) {
            return;
        }
        this.crateSelected = crateSelected;
        this.firePropertyChange(PROPERTY_CRATE_SELECTED, !crateSelected, crateSelected);
    }

    public boolean isSingleCrateSelected() {
        return this.singleCrateSelected;
    }

    protected synchronized void setSingleCrateSelected(boolean singleCrateSelected) {
        if (this.singleCrateSelected == singleCrateSelected) {
            return;
        }
        this.singleCrateSelected = singleCrateSelected;
        this.firePropertyChange(PROPERTY_SINGLE_CRATE_SELECTED, !singleCrateSelected, singleCrateSelected);
    }

    public MutableMediaCrate getRootCrate() {
        return this.rootCrate;
    }

    public void setRootCrate(MutableMediaCrate rootCrate) {
        this.rootCrate = rootCrate;
        final MutableMediaCrate finalRoot = rootCrate;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MediaTreeViewPanel.this.crateTreeModel.setRootCrate((MediaCrate)finalRoot);
            }
        });
    }

    public MediaLibrary getMediaLibrary() {
        return this.mediaLibrary;
    }

    public void setMediaLibrary(MediaLibrary mediaLibrary) {
        this.mediaLibrary = mediaLibrary;
    }

    protected JTree getTreeCrates() {
        return this.treeCrates;
    }

    public JPopupMenu getCratePopupMenu() {
        return this.cratePopupMenu;
    }

    public void setCratePopupMenu(JPopupMenu cratePopupMenu) {
        this.cratePopupMenu = cratePopupMenu;
    }

    protected SelectionManager createSelectionManager() {
        SelectionManagerImpl impl = new SelectionManagerImpl();
        impl.setSelection((Selection)this.getSelection());
        return impl;
    }

    public SelectionManager getSelectionManager() {
        if (this.selectionManager == null) {
            this.setSelectionManager(this.createSelectionManager());
        }
        return this.selectionManager;
    }

    protected void setSelectionManager(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public SelectionImpl getSelection() {
        if (this.selection == null) {
            this.setSelection(this.createSelection());
        }
        return this.selection;
    }

    protected void setSelection(SelectionImpl selection) {
        this.selection = selection;
    }

    protected SelectionImpl createSelection() {
        return new SelectionImpl(this);
    }

    public MediaTreeView getMediaTreeView() {
        return this.mediaTreeView;
    }

    public void setMediaTreeView(MediaTreeView mediaTreeView) {
        this.mediaTreeView = mediaTreeView;
    }

    public MediaTreeToolContext getMediaTreeToolContext() {
        if (this.mediaTreeToolContext == null) {
            this.setMediaTreeToolContext(this.createMediaTreeToolContext());
        }
        return this.mediaTreeToolContext;
    }

    protected void setMediaTreeToolContext(MediaTreeToolContext mediaTreeToolContext) {
        this.mediaTreeToolContext = mediaTreeToolContext;
    }

    protected MediaTreeToolContext createMediaTreeToolContext() {
        return new ToolContextImpl();
    }

    public BeansToolkit getBeansToolkit() {
        return this.beansToolkit;
    }

    public void setBeansToolkit(BeansToolkit beansToolkit) {
        this.beansToolkit = beansToolkit;
    }

    public ClipboardManager getClipboardManager() {
        return this.clipboardManager;
    }

    public void setClipboardManager(ClipboardManager clipboardManager) {
        this.clipboardManager = clipboardManager;
    }

    public BeanDropSupport getBeanDropSupport() {
        return this.beanDropSupport;
    }

    public void setBeanDropSupport(BeanDropSupport beanDropSupport) {
        this.beanDropSupport = beanDropSupport;
    }

    public MediaManagerToolContext getMediaManagerToolContext() {
        return this.mediaManagerToolContext;
    }

    public void setMediaManagerToolContext(MediaManagerToolContext mediaManagerToolContext) {
        this.mediaManagerToolContext = mediaManagerToolContext;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    protected MediaCrate getMediaCrateForLocation(int x, int y) {
        TreePath treePath = this.treeCrates.getPathForLocation(x, y);
        if (treePath != null) {
            Object treeNode = treePath.getLastPathComponent();
            if (treeNode != null && treeNode instanceof CrateTreeNode) {
                CrateTreeNode crateNode = (CrateTreeNode)treeNode;
                return crateNode.getCrate();
            }
            return null;
        }
        return this.rootCrate;
    }

    public void showCrateConvertDialog() {
        int messageType;
        int optionType;
        LinkedList crates = new LinkedList();
        this.getSelectedCrates(crates);
        if (crates.isEmpty()) {
            return;
        }
        LinkedList<MediaCrate> dirCrates = new LinkedList<MediaCrate>();
        LinkedList<MutableMediaCrate> dirParents = new LinkedList<MutableMediaCrate>();
        for (MediaCrate crate : crates) {
            MediaCrate parent;
            if (crate == null || !(crate instanceof DirectoryMediaCrate) && !(crate instanceof SeratoMediaCrate) || !((parent = crate.getParent()) instanceof MutableMediaCrate)) continue;
            dirParents.add((MutableMediaCrate)parent);
            dirCrates.add(crate);
        }
        if (dirCrates.isEmpty()) {
            return;
        }
        int dirCount = dirCrates.size();
        String title = "Convert Crate(s)";
        String message = "You are about to convert " + dirCount + " crate(s). Are you sure ?";
        int rc = JOptionPane.showConfirmDialog(this, message, title, optionType = 2, messageType = 3);
        if (rc != 0) {
            return;
        }
        MediaLibrary library = this.getMediaLibrary();
        MediaContext context = library.getContext();
        MutableMediaCrate[] parents = dirParents.toArray(new MutableMediaCrate[dirCount]);
        MediaCrate[] dirCrateArray = dirCrates.toArray(new MediaCrate[dirCount]);
        int[] indexes = new int[dirCount];
        MediaCrate[] convCrates = new MediaCrate[dirCount];
        for (int i = 0; i < dirCount; ++i) {
            MediaCrate dirCrate = dirCrateArray[i];
            indexes[i] = parents[i].getCrateIndex(dirCrate);
            convCrates[i] = this.createMutableMediaCrate(dirCrate, context);
        }
        CrateRemoveEdit removeEdit = new CrateRemoveEdit(parents, dirCrateArray, indexes);
        CrateInsertEdit insertEdit = new CrateInsertEdit(parents, convCrates, indexes);
        CompoundEdit edits = new CompoundEdit();
        edits.addEdit(removeEdit);
        edits.addEdit(insertEdit);
        edits.end();
        removeEdit.execute();
        insertEdit.execute();
        UndoManager um = this.getUndoManager();
        if (um != null) {
            um.addEdit(edits);
        }
    }

    protected MutableMediaCrate createMutableMediaCrate(MediaCrate dirCrate, MediaContext context) {
        String id = null;
        String name = dirCrate.getName();
        DefaultMediaCrate newCrate = new DefaultMediaCrate(id, name);
        context.registerMediaCrate((MediaCrate)newCrate);
        LinkedList list = new LinkedList();
        dirCrate.getEntries(list);
        if (!list.isEmpty()) {
            for (MediaCrateEntry mce : list) {
                Resource resource;
                if (mce == null || (resource = mce.getResource()) == null) continue;
                newCrate.addEntry((MediaCrateEntry)new DefaultMediaCrateEntry((MediaCrate)newCrate, resource));
            }
        }
        list.clear();
        dirCrate.getCrates(list);
        if (!list.isEmpty()) {
            for (MediaCrate sub : list) {
                MutableMediaCrate newSubCrate;
                if (sub == null || (newSubCrate = this.createMutableMediaCrate(sub, context)) == null) continue;
                newCrate.addCrate((MediaCrate)newSubCrate);
            }
        }
        return newCrate;
    }

    public void showSeratoExportDialog() {
        try {
            LinkedList crates = new LinkedList();
            this.getSelectedCrates(crates);
            if (crates.isEmpty()) {
                return;
            }
            MediaCrate[] selCrates = crates.toArray(new MediaCrate[crates.size()]);
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Export Crate(s) to Serato Folder");
            chooser.setDialogType(1);
            chooser.setFileSelectionMode(1);
            chooser.setMultiSelectionEnabled(false);
            int rc = chooser.showSaveDialog(this);
            if (rc != 0) {
                return;
            }
            File targetDir = chooser.getSelectedFile();
            if (targetDir == null) {
                return;
            }
            String dirName = targetDir.getName();
            if (!"Subcrates".equalsIgnoreCase(dirName)) {
                int messageType;
                int optionType;
                String title = "Unexpected Folder Name";
                String message = "You are about to export crates to an unexpected folder: \n";
                message = message + targetDir.getPath() + "\n\n";
                message = message + "Expected folder name: _Serato_/Subcrates\n\n";
                int confirm = JOptionPane.showConfirmDialog(this, message = message + "Are you sure ?", title, optionType = 2, messageType = 2);
                if (confirm != 0) {
                    return;
                }
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Exporting " + selCrates.length + " crate(s) to serato folder: " + targetDir);
            }
            SeratoExport seratoExport = new SeratoExport(targetDir);
            seratoExport.exportCratesToSerato(selCrates);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Exported crate(s) to serato folder.");
            }
            JOptionPane.showMessageDialog(this, "Exported " + selCrates.length + " crate(s) to serato folder:\n" + targetDir);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void showSeratoLoadDialog() {
        try {
            int messageType;
            int optionType;
            CrateTreeNode node;
            MediaCrate selCrate;
            File[] seratoFolders = SeratoUtil.enumerateSeratoFolders();
            if (seratoFolders.length < 1) {
                JOptionPane.showMessageDialog(this, "No serato folders found! (e.g. _Serato_/)");
                return;
            }
            File[] seratoCrateFiles = SeratoUtil.enumerateSeratoRootCrateFiles((File[])seratoFolders);
            if (seratoCrateFiles.length < 1) {
                JOptionPane.showMessageDialog(this, "No serato crate files found! (e.g. _Serato_/Subcrates/...)");
                return;
            }
            MutableMediaCrate targetCrate = null;
            TreePath selCratePath = this.treeCrates.getSelectionPath();
            if (selCratePath != null && (selCrate = (node = (CrateTreeNode)selCratePath.getLastPathComponent()).getCrate()) != null && selCrate instanceof MutableMediaCrate) {
                targetCrate = (MutableMediaCrate)selCrate;
            }
            if (targetCrate == null) {
                targetCrate = this.rootCrate;
            }
            String title = "Load Serato Crates ?";
            String message = "Found " + seratoCrateFiles.length + " serato crate(s) in " + seratoFolders.length + " folder(s):\n\n";
            int rc = JOptionPane.showConfirmDialog(this, message = message + "Do you want to load the crate(s) ?", title, optionType = 2, messageType = 3);
            if (rc != 0) {
                return;
            }
            LinkedList<SeratoMediaCrate> crateList = new LinkedList<SeratoMediaCrate>();
            for (File crateFile : seratoCrateFiles) {
                String crateId = crateFile.getPath();
                crateList.add(new SeratoMediaCrate(crateId, crateFile));
            }
            MediaCrate[] crates = crateList.toArray(new MediaCrate[crateList.size()]);
            int numCrates = crates.length;
            MutableMediaCrate[] parents = new MutableMediaCrate[numCrates];
            int[] indexes = new int[numCrates];
            int index = targetCrate.getCrateCount();
            for (int i = 0; i < numCrates; ++i) {
                parents[i] = targetCrate;
                indexes[i] = index++;
            }
            CrateInsertEdit edit = new CrateInsertEdit(parents, crates, indexes);
            edit.execute();
            UndoManager um = this.getUndoManager();
            if (um != null) {
                um.addEdit(edit);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void showM3uExportDialog() {
        try {
            LinkedList crates = new LinkedList();
            this.getSelectedCrates(crates);
            if (crates.isEmpty()) {
                return;
            }
            MediaCrate[] selCrates = crates.toArray(new MediaCrate[crates.size()]);
            JFileChooser chooser = new JFileChooser();
            chooser.setDialogTitle("Export Crate(s) to M3U Playlist");
            chooser.setDialogType(1);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            int rc = chooser.showSaveDialog(this);
            if (rc != 0) {
                return;
            }
            File targetFile = chooser.getSelectedFile();
            if (targetFile == null) {
                return;
            }
            String targetPath = targetFile.getPath();
            if (!targetPath.toLowerCase().endsWith(".m3u")) {
                targetPath = targetPath + ".m3u";
                targetFile = new File(targetPath);
            }
            if (targetFile.exists()) {
                int messageType;
                int optionType;
                String title = "Overwrite File ?";
                String message = "Are you sure to overwrite the existing file ? \n" + targetFile;
                rc = JOptionPane.showConfirmDialog(this, message, title, optionType = 2, messageType = 2);
                if (rc != 0) {
                    return;
                }
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Exporting " + selCrates.length + " crate(s) to M3U playlist: " + targetFile);
            }
            M3uExport m3uExport = new M3uExport(targetFile);
            m3uExport.exportCratesToM3uFile(selCrates);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Exported crate(s) to M3U playlist.");
            }
            JOptionPane.showMessageDialog(this, "Exported " + selCrates.length + " crate(s) to M3U playlist:\n" + targetFile);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void showCratePropertiesDialog() {
        try {
            LinkedList crates = new LinkedList();
            this.getSelectedCrates(crates);
            if (crates.size() != 1) {
                return;
            }
            MediaCrate crate = (MediaCrate)crates.get(0);
            MediaCratePropertiesPanel propsPanel = new MediaCratePropertiesPanel();
            propsPanel.setMediaCrate(crate);
            MediaCratePropertiesPanel message = propsPanel;
            String title = "Crate Properties";
            int optionType = 2;
            int messageType = -1;
            int rc = JOptionPane.showConfirmDialog(this, message, title, optionType, messageType);
            if (rc != 0) {
                return;
            }
            String id = crate.getId();
            String oldName = crate.getName();
            String oldDescr = crate.getDescription();
            String newName = propsPanel.getNewName();
            String newDescr = propsPanel.getNewDescription();
            DefaultMediaCrate oldProps = new DefaultMediaCrate(id, oldName);
            oldProps.setDescription(oldDescr);
            DefaultMediaCrate newProps = new DefaultMediaCrate(id, newName);
            newProps.setDescription(newDescr);
            CratePropertiesEdit edit = new CratePropertiesEdit(crate, (MediaCrate)oldProps, (MediaCrate)newProps);
            edit.execute();
            UndoManager um = this.getUndoManager();
            if (um != null) {
                um.addEdit(edit);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public boolean isAutoLoadSelectedCrates() {
        return this.autoLoadSelectedCrates;
    }

    public synchronized void setAutoLoadSelectedCrates(boolean autoLoadSelectedCrates) {
        if (this.autoLoadSelectedCrates == autoLoadSelectedCrates) {
            return;
        }
        this.autoLoadSelectedCrates = autoLoadSelectedCrates;
        if (autoLoadSelectedCrates) {
            this.mediaManagerToolContext.loadSelectedCrates();
        }
        this.firePropertyChange(PROPERTY_AUTO_LOAD_SELECTED_CRATES, !autoLoadSelectedCrates, autoLoadSelectedCrates);
    }

    public void requestCrateTreeFocus() {
        this.treeCrates.requestFocus();
    }

    public void saveViewPreferences(Properties props) {
        props.setProperty(PROPERTY_AUTO_LOAD_SELECTED_CRATES, Boolean.toString(this.autoLoadSelectedCrates));
        LinkedList selCrates = new LinkedList();
        this.getSelectedCrates(selCrates);
        int selCount = selCrates.size();
        if (selCount > 0) {
            // empty if block
        }
    }

    public void loadViewPreferences(Properties props) {
        String s = props.getProperty(PROPERTY_AUTO_LOAD_SELECTED_CRATES);
        if (s != null) {
            this.setAutoLoadSelectedCrates(s.equalsIgnoreCase("true"));
        }
    }

    protected void handleTreeWillExpand(TreeExpansionEvent event) {
        CrateTreeNode node;
        MediaCrate crate;
        Object nodeObj;
        this.setCursor(Cursor.getPredefinedCursor(3));
        TreePath path = event.getPath();
        if (path != null && (nodeObj = path.getLastPathComponent()) != null && nodeObj instanceof CrateTreeNode && (crate = (node = (CrateTreeNode)nodeObj).getCrate()) != null) {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("treeWillExpand: " + crate);
                }
                crate.getCrates(null);
                int num = crate.getCrateCount();
                if (num > 0) {
                    for (int i = 0; i < num; ++i) {
                        MediaCrate subCrate = crate.getCrateAt(i);
                        subCrate.getCrates(null);
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    protected void handleTreeExpanded(TreeExpansionEvent event) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public boolean moveMediaCursor(int count) {
        int rows;
        JTree tree = this.treeCrates;
        int sel = tree.getLeadSelectionRow();
        int row = sel < 0 ? count - 1 : sel + count;
        if (row < 0) {
            row = 0;
        }
        if (row >= (rows = tree.getRowCount())) {
            row = rows - 1;
        }
        if (row == sel) {
            return false;
        }
        tree.setSelectionRow(row);
        tree.scrollRowToVisible(row);
        return true;
    }

    public boolean pushMediaCursor(MediaPlayer player) {
        CrateTreeNode node;
        TreePath path;
        Object comp;
        TreePath[] sel = this.treeCrates.getSelectionPaths();
        if (sel != null && sel.length == 1 && (comp = (path = sel[0]).getLastPathComponent()) != null && comp instanceof CrateTreeNode && !this.crateTreeModel.isLeaf(node = (CrateTreeNode)comp) && !this.treeCrates.isExpanded(path)) {
            this.treeCrates.expandPath(path);
            return true;
        }
        if (this.mediaManagerToolContext != null) {
            this.mediaManagerToolContext.loadSelectedCrates();
            this.mediaManagerToolContext.navigatePlayList(player);
        }
        return true;
    }

    public boolean backMediaCursor() {
        TreePath path;
        TreePath[] sel = this.treeCrates.getSelectionPaths();
        if (sel == null) {
            return false;
        }
        int num = sel.length;
        if (num < 1) {
            return false;
        }
        CrateTreeNode node = null;
        for (int i = 0; i < num; ++i) {
            path = sel[i];
            Object comp = path.getLastPathComponent();
            if (comp == null || !(comp instanceof CrateTreeNode)) continue;
            node = (CrateTreeNode)comp;
            break;
        }
        if (node == null) {
            return false;
        }
        path = new TreePath(this.crateTreeModel.getPathToRoot(node));
        if (!this.treeCrates.isCollapsed(path)) {
            this.treeCrates.collapsePath(path);
            this.treeCrates.scrollPathToVisible(path);
            return true;
        }
        TreeNode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        path = new TreePath(this.crateTreeModel.getPathToRoot(parent));
        this.treeCrates.scrollPathToVisible(path);
        if (parent.getParent() == null) {
            return false;
        }
        this.treeCrates.setSelectionPath(path);
        return true;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public void setNormalFont(Font normalFont) {
        this.normalFont = normalFont;
    }

    public Font getActiveFont() {
        return this.activeFont;
    }

    public void setActiveFont(Font activeFont) {
        this.activeFont = activeFont;
    }

    public void applyTreeFont() {
        JTree tree = this.getTreeCrates();
        this.treeRenderer.setNormalFont(this.normalFont);
        this.treeRenderer.setActiveFont(this.normalFont);
        FontMetrics fm = this.getFontMetrics(this.normalFont);
        int rowHeight = fm.getHeight();
        tree.setRowHeight(rowHeight);
        this.validate();
        this.repaint();
    }

    protected class DropTargetHandler
    implements DropTargetListener {
        private BeanContext beanContext = new BeanContextSupport();
        private Collection dropBeans = new ArrayList();

        protected DropTargetHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            if (MediaTreeViewPanel.this.beanDropSupport == null) {
                return;
            }
            this.dropBeans.clear();
            Point pos = dtde.getLocation();
            MediaCrate targetCrate = MediaTreeViewPanel.this.getMediaCrateForLocation(pos.x, pos.y);
            if (targetCrate != null && targetCrate instanceof MutableMediaCrate) {
                MediaTreeViewPanel.this.beanDropSupport.enumerateDropBeans(this.beanContext, dtde, this.dropBeans);
                return;
            }
            dtde.rejectDrag();
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            this.dropBeans.clear();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            if (MediaTreeViewPanel.this.beanDropSupport == null) {
                return;
            }
            Point pos = dtde.getLocation();
            MediaCrate targetCrate = MediaTreeViewPanel.this.getMediaCrateForLocation(pos.x, pos.y);
            if (targetCrate != null && targetCrate instanceof MutableMediaCrate) {
                ArrayList temp = new ArrayList();
                boolean searchSuccess = MediaTreeViewPanel.this.beanDropSupport.enumerateDropBeans(this.beanContext, dtde, temp);
                if (searchSuccess) {
                    this.dropBeans.clear();
                    this.dropBeans.addAll(temp);
                    boolean accepted = false;
                    for (Object o : this.dropBeans) {
                        if (o == null || !MediaTreeViewPanel.this.beanDropSupport.acceptDropBean(this.beanContext, o) || !this.acceptDropBean(o)) continue;
                        accepted = true;
                        break;
                    }
                    if (accepted) {
                        dtde.acceptDrag(dtde.getDropAction());
                        return;
                    }
                    dtde.rejectDrag();
                    return;
                }
                dtde.acceptDrag(dtde.getDropAction());
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            if (MediaTreeViewPanel.this.beanDropSupport == null) {
                return;
            }
            Transferable trans = dtde.getTransferable();
            int dropAction = dtde.getDropAction();
            Point pos = dtde.getLocation();
            MediaCrate targetCrate = MediaTreeViewPanel.this.getMediaCrateForLocation(pos.x, pos.y);
            if (targetCrate != null && targetCrate instanceof MutableMediaCrate) {
                ArrayList temp = new ArrayList();
                boolean enumSuccess = MediaTreeViewPanel.this.beanDropSupport.enumerateDropBeans(this.beanContext, trans, temp);
                if (enumSuccess) {
                    this.dropBeans.clear();
                    this.dropBeans.addAll(temp);
                }
                if (!this.dropBeans.isEmpty()) {
                    dtde.acceptDrop(dropAction);
                    try {
                        MediaTreeViewPanel.this.beanDropSupport.dropBeans(this.dropBeans, this.beanContext, dropAction);
                        MediaTreeViewPanel.this.dropCrates(this.dropBeans, (MutableMediaCrate)targetCrate);
                        dtde.dropComplete(true);
                        this.dropBeans.clear();
                        return;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            try {
                dtde.rejectDrop();
            }
            catch (InvalidDnDOperationException e) {
                // empty catch block
            }
            dtde.dropComplete(false);
            this.dropBeans.clear();
        }

        protected boolean acceptDropBean(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof MediaCrate) {
                return true;
            }
            if (o instanceof File) {
                File f = (File)o;
                return f.exists();
            }
            return false;
        }
    }

    protected class ClipSourceImpl
    implements ClipSource {
        protected ClipSourceImpl() {
        }

        public int getClipAction() {
            return 4;
        }

        public boolean isClipActionSupported(int action) {
            return action == 4;
        }

        public void objectTransferred(Object object, int action) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("objectTransferred: " + object);
            }
        }
    }

    protected class CratePropertiesEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = -6857249465884550907L;
        protected MediaCrate mediaCrate;
        protected MediaCrate oldProps;
        protected MediaCrate newProps;

        public CratePropertiesEdit(MediaCrate mediaCrate, MediaCrate oldProps, MediaCrate newProps) {
            this.mediaCrate = mediaCrate;
            this.oldProps = oldProps;
            this.newProps = newProps;
        }

        protected void execute() {
            String name = this.newProps.getName();
            String descr = this.newProps.getDescription();
            this.applyCrateProperties(this.mediaCrate, name, descr);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            String name = this.oldProps.getName();
            String descr = this.oldProps.getDescription();
            this.applyCrateProperties(this.mediaCrate, name, descr);
        }

        protected void applyCrateProperties(MediaCrate crate, String name, String descr) {
            DirectoryMediaCrate dirCrate;
            MediaCrate dirParent;
            if (crate instanceof MutableMediaCrate) {
                MutableMediaCrate mutableCrate = (MutableMediaCrate)crate;
                mutableCrate.setName(name);
                mutableCrate.setDescription(descr);
            } else if (crate instanceof DirectoryMediaCrate && ((dirParent = (dirCrate = (DirectoryMediaCrate)crate).getParent()) == null || dirParent instanceof MutableMediaCrate)) {
                dirCrate.setName(name);
                dirCrate.setDescription(descr);
            }
            MediaTreeViewPanel.this.setSelectedCratesLater(new MediaCrate[]{crate});
        }
    }

    protected class CrateMoveEdit
    extends AbstractCrateEdit {
        private static final long serialVersionUID = -311600688863422921L;
        protected MutableMediaCrate[] newParents;
        protected int[] newIndexes;

        public CrateMoveEdit(MutableMediaCrate[] parents, MediaCrate[] crates, int[] indexes, MutableMediaCrate[] newParents, int[] newIndexes) {
            super(parents, crates, indexes);
            this.newParents = newParents;
            this.newIndexes = newIndexes;
        }

        @Override
        protected void execute() {
            this.removeCrates(this.parents, this.crates, this.indexes);
            this.insertCrates(this.newParents, this.crates, this.newIndexes);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.removeCrates(this.newParents, this.crates, this.newIndexes);
            this.insertCrates(this.parents, this.crates, this.indexes);
        }
    }

    protected class CrateRemoveEdit
    extends AbstractCrateEdit {
        private static final long serialVersionUID = -7656046920236697895L;

        public CrateRemoveEdit(MutableMediaCrate[] parents, MediaCrate[] crates, int[] indexes) {
            super(parents, crates, indexes);
        }

        @Override
        protected void execute() {
            this.removeCrates(this.parents, this.crates, this.indexes);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.insertCrates(this.parents, this.crates, this.indexes);
        }
    }

    protected class CrateInsertEdit
    extends AbstractCrateEdit {
        private static final long serialVersionUID = 1029222895685473619L;

        public CrateInsertEdit(MutableMediaCrate[] parents, MediaCrate[] crates, int[] indexes) {
            super(parents, crates, indexes);
        }

        @Override
        protected void execute() {
            this.insertCrates(this.parents, this.crates, this.indexes);
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.removeCrates(this.parents, this.crates, this.indexes);
        }
    }

    protected abstract class AbstractCrateEdit
    extends AbstractUndoableEdit {
        private static final long serialVersionUID = -3809738136240230144L;
        protected MutableMediaCrate[] parents;
        protected MediaCrate[] crates;
        protected int[] indexes;

        public AbstractCrateEdit(MutableMediaCrate[] parents, MediaCrate[] crates, int[] indexes) {
            this.parents = parents;
            this.crates = crates;
            this.indexes = indexes;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        protected abstract void execute();

        protected void removeCrates(MutableMediaCrate[] parents, MediaCrate[] crates, int[] indexes) {
            int num = parents.length;
            for (int i = num - 1; i >= 0; --i) {
                MediaCrate crate2;
                MutableMediaCrate parent = parents[i];
                MediaCrate crate = crates[i];
                int index = indexes[i];
                int size = parent.getCrateCount();
                if (index >= 0 && index < size && parent.getCrateAt(index) == crate && (crate2 = parent.removeCrateAt(index)) == crate) continue;
                parent.removeCrate(crate);
            }
        }

        protected void insertCrates(MutableMediaCrate[] parents, MediaCrate[] crates, int[] indexes) {
            int num = parents.length;
            for (int i = 0; i < num; ++i) {
                MutableMediaCrate parent = parents[i];
                MediaCrate crate = crates[i];
                int index = indexes[i];
                if (index >= 0 && index <= parent.getCrateCount()) {
                    parent.insertCrateAt(crate, index);
                } else {
                    parent.addCrate(crate);
                }
                CrateTreeNode parentNode = MediaTreeViewPanel.this.crateTreeModel.getCrateTreeNode((MediaCrate)parent);
                if (parentNode == null) continue;
                Object[] path = MediaTreeViewPanel.this.crateTreeModel.getPathToRoot(parentNode);
                MediaTreeViewPanel.this.treeCrates.expandPath(new TreePath(path));
            }
            MediaTreeViewPanel.this.setSelectedCratesLater(crates);
        }
    }

    protected class SelectionManagerImpl
    extends AbstractSelectionManager {
        protected SelectionManagerImpl() {
        }

        public View getView() {
            return MediaTreeViewPanel.this.mediaTreeView;
        }

        public Perspective getPerspective() {
            return this.getView().getPerspective();
        }

        public Workbench getWorkbench() {
            return this.getPerspective().getWorkbench();
        }

        public void addViewFocusCondition(ViewFocusCondition condition) {
            throw new UnsupportedOperationException();
        }

        public void removeViewFocusCondition(ViewFocusCondition condition) {
        }

        protected synchronized void setSelection(Selection sel) {
            super.setSelection(sel);
        }
    }

    protected class SelectionImpl
    extends AbstractSelection {
        public SelectionImpl(Object source) {
            super(source);
        }

        public TreePath getSelectionPathAt(int i) {
            return null;
        }

        public int removeSelectedObjects() {
            return MediaTreeViewPanel.this.removeSelectedCrates(true);
        }

        public int cutSelectedObjects() {
            return MediaTreeViewPanel.this.cutSelectedCrates(true);
        }

        public int copySelectedObjects() {
            return MediaTreeViewPanel.this.copySelectedCrates();
        }

        public boolean isPasteSupported() {
            return true;
        }

        public int pasteObjects() {
            return MediaTreeViewPanel.this.pasteCrates();
        }

        protected void crateSelectionChanged(Collection crates) {
            this.clearSelection();
            this.addSelectedObjects(crates.toArray(new Object[crates.size()]));
        }
    }

    protected class CrateMouseHandler
    extends MouseAdapter {
        protected CrateMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (e.isPopupTrigger()) {
                MediaTreeViewPanel.this.showCratePopupMenu(e.getX(), e.getY());
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                MediaTreeViewPanel.this.showCratePopupMenu(e.getX(), e.getY());
                return;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                MediaTreeViewPanel.this.showCratePopupMenu(e.getX(), e.getY());
                return;
            }
        }
    }

    protected class MoveDownAction
    extends AbstractAction {
        private static final long serialVersionUID = 8503250548838783170L;
        protected static final String ACTION_KEY = "moveDown";

        protected MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTreeViewPanel.this.moveSelectedCratesDown();
        }
    }

    protected class MoveUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -2923569564250979913L;
        protected static final String ACTION_KEY = "moveUp";

        protected MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTreeViewPanel.this.moveSelectedCratesUp();
        }
    }

    protected class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = 6010760759077522796L;
        protected static final String ACTION_KEY = "redo";

        protected RedoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UndoManager um = MediaTreeViewPanel.this.getUndoManager();
            if (um != null && um.canRedo()) {
                um.redo();
            }
        }
    }

    protected class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -1068051200215265177L;
        protected static final String ACTION_KEY = "undo";

        protected UndoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UndoManager um = MediaTreeViewPanel.this.getUndoManager();
            if (um != null && um.canUndo()) {
                um.undo();
            }
        }
    }

    protected class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = 8539892197210458310L;
        protected static final String ACTION_KEY = "paste";

        protected PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTreeViewPanel.this.pasteCrates();
        }
    }

    protected class CutAction
    extends AbstractAction {
        private static final long serialVersionUID = -2588010229995646556L;
        protected static final String ACTION_KEY = "cut";

        protected CutAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTreeViewPanel.this.cutSelectedCrates(true);
        }
    }

    protected class CopyAction
    extends AbstractAction {
        private static final long serialVersionUID = -7663591321511363022L;
        protected static final String ACTION_KEY = "copy";

        protected CopyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTreeViewPanel.this.copySelectedCrates();
        }
    }

    protected class ControlDeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = -8282018265941497919L;
        protected static final String ACTION_KEY = "controlDelete";

        protected ControlDeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTreeViewPanel.this.removeSelectedCrates(false);
        }
    }

    protected class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = -1065956147186049753L;
        protected static final String ACTION_KEY = "delete";

        protected DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaTreeViewPanel.this.removeSelectedCrates(true);
        }
    }

    protected class SpaceAction
    extends AbstractAction {
        private static final long serialVersionUID = 3640353813664808835L;
        protected static final String ACTION_KEY = "space";

        protected SpaceAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            logger.info("SpaceAction...");
        }
    }

    protected class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = -5501815249086143413L;
        protected static final String ACTION_KEY = "enter";

        protected EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaPlayer player = null;
            MediaTreeViewPanel.this.pushMediaCursor(player);
        }
    }

    protected class ToolContextImpl
    extends AbstractToolContext
    implements MediaTreeToolContext {
        public ToolContextImpl() {
            this.initToolContextImpl();
        }

        protected void initToolContextImpl() {
            try {
                BeanProperty autoLoadSelectedCratesProperty = BeanProperty.getBeanProperty((Object)MediaTreeViewPanel.this, (String)MediaTreeViewPanel.PROPERTY_AUTO_LOAD_SELECTED_CRATES);
                this.setProperty(MediaTreeViewPanel.PROPERTY_AUTO_LOAD_SELECTED_CRATES, (Property)autoLoadSelectedCratesProperty);
                BeanProperty crateSelectedProperty = BeanProperty.getBeanProperty((Object)MediaTreeViewPanel.this, (String)MediaTreeViewPanel.PROPERTY_CRATE_SELECTED);
                this.setProperty(MediaTreeViewPanel.PROPERTY_CRATE_SELECTED, (Property)crateSelectedProperty);
                BeanProperty singleCrateSelectedProperty = BeanProperty.getBeanProperty((Object)MediaTreeViewPanel.this, (String)MediaTreeViewPanel.PROPERTY_SINGLE_CRATE_SELECTED);
                this.setProperty(MediaTreeViewPanel.PROPERTY_SINGLE_CRATE_SELECTED, (Property)singleCrateSelectedProperty);
                SelectionCondition.ObjectsSelected objectsSelectedCondition = new SelectionCondition.ObjectsSelected();
                MediaTreeViewPanel.this.getSelectionManager().addSelectionCondition((SelectionCondition)objectsSelectedCondition);
                this.setProperty("anyObjectSelected", (Property)objectsSelectedCondition);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public MediaTreeView getMediaTreeView() {
            return MediaTreeViewPanel.this.mediaTreeView;
        }

        @Override
        public MediaTreeViewPanel getMediaTreeViewPanel() {
            return MediaTreeViewPanel.this;
        }

        public SelectionManager getSelectionManager() {
            return MediaTreeViewPanel.this.selectionManager;
        }

        @Override
        public MediaCrate[] getSelectedCrates() {
            LinkedList crates = new LinkedList();
            MediaTreeViewPanel.this.getSelectedCrates(crates);
            return crates.toArray(new MediaCrate[crates.size()]);
        }

        @Override
        public void setSelectedCrate(MediaCrate crate) {
            MediaCrate[] mediaCrateArray;
            if (crate == null) {
                mediaCrateArray = null;
            } else {
                MediaCrate[] mediaCrateArray2 = new MediaCrate[1];
                mediaCrateArray = mediaCrateArray2;
                mediaCrateArray2[0] = crate;
            }
            MediaCrate[] crates = mediaCrateArray;
            MediaTreeViewPanel.this.setSelectedCrates(crates);
        }

        @Override
        public void setSelectedCrates(MediaCrate[] crates) {
            MediaTreeViewPanel.this.setSelectedCrates(crates);
        }

        @Override
        public void refreshSelectedCrates() {
            MediaTreeViewPanel.this.refreshSelectedCrates();
        }

        @Override
        public void removeSelectedCrates() {
            MediaTreeViewPanel.this.removeSelectedCrates(true);
        }

        @Override
        public void newDefaultCrate() {
            MediaTreeViewPanel.this.addNewCrate();
        }

        @Override
        public void newDirectoryCrate() {
            MediaTreeViewPanel.this.addDirectoryCrate();
        }

        @Override
        public void newFileCrate() {
            MediaTreeViewPanel.this.addFileCrate();
        }

        @Override
        public void newRemoteCrate() {
            MediaTreeViewPanel.this.addRemoteCrate();
        }

        @Override
        public void showCrateImportDialog() {
            MediaTreeViewPanel.this.actionImportCrateFile();
        }

        @Override
        public void showCrateExportDialog() {
            MediaTreeViewPanel.this.actionExportCrateFile();
        }

        @Override
        public void showSeratoLoadDialog() {
            MediaTreeViewPanel.this.showSeratoLoadDialog();
        }

        @Override
        public void showSeratoExportDialog() {
            MediaTreeViewPanel.this.showSeratoExportDialog();
        }

        @Override
        public void showM3uExportDialog() {
            MediaTreeViewPanel.this.showM3uExportDialog();
        }

        @Override
        public void moveSelectedCratesUp() {
            MediaTreeViewPanel.this.moveSelectedCratesUp();
        }

        @Override
        public void moveSelectedCratesDown() {
            MediaTreeViewPanel.this.moveSelectedCratesDown();
        }

        @Override
        public void showCrateConvertDialog() {
            MediaTreeViewPanel.this.showCrateConvertDialog();
        }

        @Override
        public void showCratePropertiesDialog() {
            MediaTreeViewPanel.this.showCratePropertiesDialog();
        }

        @Override
        public void loadSelectedCrates() {
            MediaTreeViewPanel.this.mediaManagerToolContext.loadSelectedCrates();
        }

        @Override
        public boolean isAutoLoadSelectedCrates() {
            return MediaTreeViewPanel.this.isAutoLoadSelectedCrates();
        }

        @Override
        public void setAutoLoadSelectedCrates(boolean enabled) {
            MediaTreeViewPanel.this.setAutoLoadSelectedCrates(enabled);
        }

        @Override
        public MediaManagerPanel getMediaManagerPanel() {
            return MediaTreeViewPanel.this.mediaManagerToolContext.getMediaManagerPanel();
        }

        @Override
        public void showOpenCrateDialog() {
            MediaTreeViewPanel.this.mediaManagerToolContext.showOpenCrateDialog();
        }

        @Override
        public void showSaveCrateDialog() {
            MediaTreeViewPanel.this.mediaManagerToolContext.showSaveCrateDialog();
        }

        @Override
        public void saveCrates() {
            MediaTreeViewPanel.this.mediaManagerToolContext.saveCrates();
        }

        public View getView() {
            return MediaTreeViewPanel.this.mediaManagerToolContext.getView();
        }

        public Perspective getPerspective() {
            return MediaTreeViewPanel.this.mediaManagerToolContext.getPerspective();
        }

        public Workbench getWorkbench() {
            return MediaTreeViewPanel.this.mediaManagerToolContext.getWorkbench();
        }

        @Override
        public boolean navigateCrateTree(MediaPlayer player) {
            return MediaTreeViewPanel.this.mediaManagerToolContext.navigateCrateTree(player);
        }

        @Override
        public boolean navigatePlayList(MediaPlayer player) {
            return MediaTreeViewPanel.this.mediaManagerToolContext.navigatePlayList(player);
        }

        @Override
        public boolean navigateMove(MediaPlayer player, int amount) {
            return MediaTreeViewPanel.this.mediaManagerToolContext.navigateMove(player, amount);
        }

        @Override
        public boolean navigatePush(MediaPlayer player) {
            return MediaTreeViewPanel.this.mediaManagerToolContext.navigatePush(player);
        }

        @Override
        public boolean navigateBack(MediaPlayer player) {
            return MediaTreeViewPanel.this.mediaManagerToolContext.navigateBack(player);
        }
    }
}

