/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Resource;
import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatDetector;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaFileFormat;
import com.spacekiller.util.media.MediaScanner;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiMediaScanner
implements MediaScanner {
    private static final Logger logger = Logger.getLogger(MultiMediaScanner.class.getName());
    private MediaScanner[] scanners;
    private FileFormatDetector detector;

    public MultiMediaScanner(MediaScanner[] scanners, FileFormatDetector detector) {
        this.scanners = scanners;
        this.detector = detector;
    }

    public MediaEntry scanMediaResource(Resource resource, MediaEntry entry) throws IOException {
        MediaEntry result;
        MediaFileFormat mff;
        MediaScanner scanner2;
        String path;
        FileFormat format;
        FileFormatDetector detector = this.detector;
        if (detector != null && (format = detector.detectExtension(path = resource.toString())) != null && format instanceof MediaFileFormat && (scanner2 = (mff = (MediaFileFormat)format).getMediaScanner()) != null && (result = this.invokeMediaScanner(scanner2, resource, entry)) != null) {
            return result;
        }
        for (MediaScanner scanner2 : this.scanners) {
            if (scanner2 == null || (result = this.invokeMediaScanner(scanner2, resource, entry)) == null) continue;
            return result;
        }
        return null;
    }

    protected MediaEntry invokeMediaScanner(MediaScanner scanner, Resource resource, MediaEntry entry) throws IOException {
        try {
            MediaEntry result;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Scanning media: scanner=" + scanner + ", resource=" + resource + ", entry=" + entry);
            }
            if ((result = scanner.scanMediaResource(resource, entry)).getFormat() == null) {
                return null;
            }
            return result;
        }
        catch (Throwable e) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Failed to scan media: scanner=" + scanner + ", resource=" + resource + ", message=" + e.getMessage());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, e.getMessage(), e);
                }
            }
            return null;
        }
    }
}

