/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaPlayerContext;
import com.spacekiller.util.media.manager.AbstractEntryOrder;

public class NormalEntryOrder
extends AbstractEntryOrder {
    private final MediaPlayerContext playerContext;

    public NormalEntryOrder(MediaPlayerContext playerContext) {
        if (playerContext == null) {
            throw new NullPointerException("playerContext");
        }
        this.playerContext = playerContext;
    }

    public MediaCrateEntry skipPrevEntry() {
        int count = this.playerContext.getEntryCount();
        if (count < 1) {
            this.currentEntry = null;
            this.currentIndex = -1;
            return null;
        }
        int index = this.currentIndex - 1;
        MediaCrateEntry entry = null;
        if (index < 0) {
            if (this.loopMode == 0) {
                this.currentEntry = null;
                this.currentIndex = -1;
                return null;
            }
            index = count - 1;
        }
        if (index >= 0 && index < count) {
            entry = this.playerContext.getEntryAt(index);
        }
        this.currentEntry = entry;
        this.currentIndex = index;
        return entry;
    }

    public MediaCrateEntry skipNextEntry() {
        int count = this.playerContext.getEntryCount();
        if (count < 1) {
            this.currentEntry = null;
            this.currentIndex = -1;
            return null;
        }
        int index = this.currentIndex + 1;
        MediaCrateEntry entry = null;
        if (index >= count) {
            if (this.loopMode == 0) {
                this.currentEntry = null;
                this.currentIndex = -1;
                return null;
            }
            index = 0;
        }
        if (index >= 0 && index < count) {
            entry = this.playerContext.getEntryAt(index);
        }
        this.currentEntry = entry;
        this.currentIndex = index;
        return entry;
    }
}

