/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.PictureEntry;
import com.spacekiller.util.media.manager.AbstractEntryPropertiesPanel;
import com.spacekiller.util.media.manager.PictureEntryViewerPanel;
import com.spacekiller.util.media.manager.column.EntryImageAlphaTableColumnProvider;
import com.spacekiller.util.thread.ThreadPool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class PictureEntryPropertiesPanel
extends AbstractEntryPropertiesPanel {
    private static final long serialVersionUID = -7734362578863804004L;
    private static final Logger logger = Logger.getLogger(PictureEntryPropertiesPanel.class.getName());
    private ThreadPool threadPool;
    private final ImageLoader imageLoader = new ImageLoader();
    private boolean imageLoaderPending;
    private Image image;
    private JTextField textFieldImageWidth;
    private JTextField textFieldImageHeight;
    private JTextField textFieldImageAlpha;
    private PictureEntryViewerPanel pictureEntryViewerPanel;
    private JPanel panelImageViewer;

    public PictureEntryPropertiesPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelImageProps = new JPanel();
        GridBagConstraints gbc_panelImageProps = new GridBagConstraints();
        gbc_panelImageProps.anchor = 11;
        gbc_panelImageProps.insets = new Insets(4, 4, 4, 5);
        gbc_panelImageProps.gridx = 0;
        gbc_panelImageProps.gridy = 0;
        this.add((Component)panelImageProps, gbc_panelImageProps);
        GridBagLayout gbl_panelImageProps = new GridBagLayout();
        gbl_panelImageProps.columnWidths = new int[]{0, 0, 0};
        gbl_panelImageProps.rowHeights = new int[]{0, 0, 0, 0};
        gbl_panelImageProps.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelImageProps.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        panelImageProps.setLayout(gbl_panelImageProps);
        JLabel lblWidth = new JLabel("Width:");
        GridBagConstraints gbc_lblWidth = new GridBagConstraints();
        gbc_lblWidth.anchor = 17;
        gbc_lblWidth.insets = new Insets(0, 0, 5, 5);
        gbc_lblWidth.gridx = 0;
        gbc_lblWidth.gridy = 0;
        panelImageProps.add((Component)lblWidth, gbc_lblWidth);
        this.textFieldImageWidth = new JTextField();
        this.textFieldImageWidth.setEditable(false);
        GridBagConstraints gbc_textFieldImageWidth = new GridBagConstraints();
        gbc_textFieldImageWidth.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldImageWidth.fill = 2;
        gbc_textFieldImageWidth.gridx = 1;
        gbc_textFieldImageWidth.gridy = 0;
        panelImageProps.add((Component)this.textFieldImageWidth, gbc_textFieldImageWidth);
        this.textFieldImageWidth.setColumns(6);
        JLabel lblHeight = new JLabel("Height:");
        GridBagConstraints gbc_lblHeight = new GridBagConstraints();
        gbc_lblHeight.anchor = 17;
        gbc_lblHeight.insets = new Insets(0, 0, 5, 5);
        gbc_lblHeight.gridx = 0;
        gbc_lblHeight.gridy = 1;
        panelImageProps.add((Component)lblHeight, gbc_lblHeight);
        this.textFieldImageHeight = new JTextField();
        this.textFieldImageHeight.setEditable(false);
        GridBagConstraints gbc_textFieldImageHeight = new GridBagConstraints();
        gbc_textFieldImageHeight.insets = new Insets(0, 0, 5, 0);
        gbc_textFieldImageHeight.fill = 2;
        gbc_textFieldImageHeight.gridx = 1;
        gbc_textFieldImageHeight.gridy = 1;
        panelImageProps.add((Component)this.textFieldImageHeight, gbc_textFieldImageHeight);
        this.textFieldImageHeight.setColumns(6);
        JLabel lblAlpha = new JLabel("Alpha:");
        GridBagConstraints gbc_lblAlpha = new GridBagConstraints();
        gbc_lblAlpha.anchor = 17;
        gbc_lblAlpha.insets = new Insets(0, 0, 0, 5);
        gbc_lblAlpha.gridx = 0;
        gbc_lblAlpha.gridy = 2;
        panelImageProps.add((Component)lblAlpha, gbc_lblAlpha);
        this.textFieldImageAlpha = new JTextField();
        this.textFieldImageAlpha.setEditable(false);
        GridBagConstraints gbc_textFieldImageAlpha = new GridBagConstraints();
        gbc_textFieldImageAlpha.fill = 2;
        gbc_textFieldImageAlpha.gridx = 1;
        gbc_textFieldImageAlpha.gridy = 2;
        panelImageProps.add((Component)this.textFieldImageAlpha, gbc_textFieldImageAlpha);
        this.textFieldImageAlpha.setColumns(6);
        this.panelImageViewer = new JPanel();
        this.panelImageViewer.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Image", 4, 2, null, null));
        GridBagConstraints gbc_panelImageViewer = new GridBagConstraints();
        gbc_panelImageViewer.weighty = 1.0;
        gbc_panelImageViewer.weightx = 1.0;
        gbc_panelImageViewer.fill = 1;
        gbc_panelImageViewer.gridx = 1;
        gbc_panelImageViewer.gridy = 0;
        this.add((Component)this.panelImageViewer, gbc_panelImageViewer);
        this.panelImageViewer.setLayout(new BorderLayout(0, 0));
        this.pictureEntryViewerPanel = new PictureEntryViewerPanel();
        this.panelImageViewer.add(this.pictureEntryViewerPanel);
        this.initPictureEntryPropertiesPanel();
    }

    protected JTextField getTextFieldImageWidth() {
        return this.textFieldImageWidth;
    }

    protected JTextField getTextFieldImageHeight() {
        return this.textFieldImageHeight;
    }

    protected JTextField getTextFieldImageAlpha() {
        return this.textFieldImageAlpha;
    }

    protected PictureEntryViewerPanel getPictureEntryViewerPanel() {
        return this.pictureEntryViewerPanel;
    }

    protected void initPictureEntryPropertiesPanel() {
        this.setTitle("Image");
        this.setTooltip("Picture Properties");
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        block14: {
            try {
                MediaEntry mediaEntry = this.getMediaEntry();
                PictureEntry picEntry = mediaEntry == null ? null : mediaEntry.getPictureEntry();
                int width = -1;
                int height = -1;
                boolean hasAlpha = false;
                int transparency = -1;
                Object object = this;
                synchronized (object) {
                    if (picEntry != null) {
                        width = picEntry.getWidth();
                        height = picEntry.getHeight();
                        hasAlpha = picEntry.isHasAlpha();
                        transparency = picEntry.getTransparency();
                    }
                    this.textFieldImageWidth.setText(width < 1 ? "" : Integer.toString(width));
                    this.textFieldImageHeight.setText(height < 1 ? "" : Integer.toString(height));
                    String alpha = EntryImageAlphaTableColumnProvider.getTransparencyString(transparency);
                    if (alpha == null && hasAlpha) {
                        alpha = "Alpha";
                    }
                    this.textFieldImageAlpha.setText(alpha == null ? "" : alpha);
                }
                if (mediaEntry != null) {
                    object = this.imageLoader;
                    synchronized (object) {
                        if (this.imageLoaderPending) {
                            return;
                        }
                        this.imageLoaderPending = true;
                        this.setImage(null, true);
                    }
                    ThreadPool pool = this.threadPool;
                    if (pool != null) {
                        pool.start((Runnable)this.imageLoader);
                    } else {
                        new Thread(this.imageLoader).start();
                    }
                    break block14;
                }
                this.setImage(null, false);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadImage() {
        Resource resource;
        MediaEntry mediaEntry;
        ImageLoader imageLoader = this.imageLoader;
        synchronized (imageLoader) {
            this.imageLoaderPending = false;
            mediaEntry = this.getMediaEntry();
        }
        PictureEntry picEntry = mediaEntry == null ? null : mediaEntry.getPictureEntry();
        Image image = null;
        if (picEntry != null && (resource = mediaEntry.getResource()) != null) {
            try {
                InputStream is = resource.createInputStream();
                try {
                    image = this.createImage(is);
                }
                finally {
                    is.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (mediaEntry != null) {
            MediaEntry me2 = null;
            ImageLoader imageLoader2 = this.imageLoader;
            synchronized (imageLoader2) {
                me2 = this.getMediaEntry();
            }
            if (me2 != mediaEntry) {
                if (image != null) {
                    image.flush();
                }
                return;
            }
        }
        this.setImage(image, false);
    }

    protected Image createImage(InputStream stream) throws IOException {
        return ImageIO.read(stream);
    }

    protected Image getImage() {
        return this.image;
    }

    protected synchronized void setImage(Image newImage, boolean loading) {
        Image oldImage = this.image;
        if (oldImage == newImage) {
            if (this.pictureEntryViewerPanel.isLoading() != loading) {
                this.pictureEntryViewerPanel.setLoading(loading);
                this.pictureEntryViewerPanel.repaint();
            }
            return;
        }
        this.image = newImage;
        this.pictureEntryViewerPanel.setImage(this.image);
        this.pictureEntryViewerPanel.setLoading(loading);
        this.pictureEntryViewerPanel.repaint();
        if (oldImage != null) {
            oldImage.flush();
        }
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    protected class ImageLoader
    implements Runnable {
        protected ImageLoader() {
        }

        @Override
        public void run() {
            PictureEntryPropertiesPanel.this.loadImage();
        }
    }
}

