/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.manager.PictureUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import javax.swing.JPanel;

public class PictureEntryViewerPanel
extends JPanel {
    private static final long serialVersionUID = 6903091582249539886L;
    private Image image;
    private boolean proportial = true;
    private boolean loading;

    public PictureEntryViewerPanel() {
        this.setOpaque(true);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        this.applyRenderingHints(g2d);
        int width = this.getWidth();
        int height = this.getHeight();
        Image img = this.image;
        if (img != null) {
            Color bgcolor = this.getBackground();
            PictureUtil.drawImage(img, this, g2d, width, height, bgcolor, this.proportial);
        } else {
            String msg = this.loading ? "Loading image..." : "No image available.";
            g.setColor(this.getForeground());
            FontMetrics fm = g.getFontMetrics();
            int x = width / 2 - fm.stringWidth(msg) / 2;
            int y = height / 2 + fm.getAscent() / 2;
            g.drawString(msg, x, y);
        }
    }

    protected void applyRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }
}

