/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class PictureUtil {
    private PictureUtil() {
    }

    public static BufferedImage createBufferedImage(InputStream stream) throws IOException {
        return ImageIO.read(stream);
    }

    public static void drawImage(Image img, ImageObserver obs, Graphics2D g, int width, int height, Color bgcolor, boolean proportial) {
        int iw = img.getWidth(obs);
        if (iw < 1) {
            return;
        }
        int ih = img.getHeight(obs);
        if (ih < 1) {
            return;
        }
        int sx1 = 0;
        int sy1 = 0;
        int sx2 = iw;
        int sy2 = ih;
        int dx1 = 0;
        int dy1 = 0;
        int dx2 = width;
        int dy2 = height;
        if (proportial) {
            double fw = (double)width / (double)iw;
            double fh = (double)height / (double)ih;
            double f = Math.min(fw, fh);
            dx2 = (int)Math.round((double)iw * f);
            dy2 = (int)Math.round((double)ih * f);
            if (dx2 > width) {
                dx2 = width;
            }
            if (dy2 > height) {
                dy2 = height;
            }
            dx1 = (width - dx2) / 2;
            dy1 = (height - dy2) / 2;
            dx2 += dx1;
            dy2 += dy1;
        }
        g.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, null);
    }
}

