/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Tools;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class RatingIcon
implements Icon {
    private boolean reverse;
    private Icon fullStarIcon;
    private Icon halfStarIcon;
    private Icon fullSadIcon;
    private Icon halfSadIcon;
    private double rating;
    private Icon[] icons;
    private int count;
    private int width;
    private int height;

    public RatingIcon(boolean reverse) {
        this.reverse = reverse;
        this.icons = new Icon[10];
        this.fullStarIcon = Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/star_full_icon.png");
        this.fullSadIcon = Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/sad_full_icon.png");
        if (reverse) {
            this.halfStarIcon = Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/star_half_right_icon.png");
            this.halfSadIcon = Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/sad_half_right_icon.png");
        } else {
            this.halfStarIcon = Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/star_half_left_icon.png");
            this.halfSadIcon = Tools.getIcon(this.getClass(), (String)"/com/spacekiller/util/media/manager/icons/sad_half_left_icon.png");
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int n = this.count;
        for (int i = 0; i < n; ++i) {
            Icon icon = this.icons[i];
            if (icon == null) continue;
            icon.paintIcon(c, g, x, y);
            x += icon.getIconWidth();
        }
    }

    public double getRating() {
        return this.rating;
    }

    public void setRating(double rating) {
        this.rating = rating;
        int newCount = 0;
        int newWidth = 0;
        int newHeight = 0;
        if (!Double.isNaN(rating)) {
            Icon fullIcon = null;
            Icon halfIcon = null;
            if (rating < 0.0) {
                rating = -rating;
                fullIcon = this.fullSadIcon;
                halfIcon = this.halfSadIcon;
            } else {
                fullIcon = this.fullStarIcon;
                halfIcon = this.halfStarIcon;
            }
            int halfCount = (int)Math.round(rating / 0.1);
            if (halfCount > 10) {
                halfCount = 10;
            }
            boolean half = halfCount % 2 > 0;
            int fullCount = halfCount / 2;
            if (fullCount + 1 > this.icons.length) {
                this.icons = new Icon[fullCount + 1];
            }
            Icon icon = fullIcon;
            int k = this.reverse && half ? 1 : 0;
            for (int i = 0; i < fullCount; ++i) {
                this.icons[k++] = icon;
            }
            if (icon != null) {
                newWidth = icon.getIconWidth() * fullCount;
                newHeight = icon.getIconHeight();
            }
            newCount = fullCount;
            if (half) {
                icon = halfIcon;
                if (this.reverse) {
                    this.icons[0] = icon;
                } else {
                    this.icons[fullCount] = icon;
                }
                if (icon != null) {
                    newWidth += icon.getIconWidth();
                    int h = icon.getIconHeight();
                    if (h > newHeight) {
                        newHeight = h;
                    }
                }
                ++newCount;
            }
        }
        this.count = newCount;
        this.width = newWidth;
        this.height = newHeight;
    }

    public Icon getFullStarIcon() {
        return this.fullStarIcon;
    }

    public void setFullStarIcon(Icon fullStarIcon) {
        this.fullStarIcon = fullStarIcon;
    }

    public Icon getHalfStarIcon() {
        return this.halfStarIcon;
    }

    public void setHalfStarIcon(Icon halfStarIcon) {
        this.halfStarIcon = halfStarIcon;
    }
}

