/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaPlayerContext;
import com.spacekiller.util.media.manager.AbstractEntryOrder;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class ShuffledEntryOrder
extends AbstractEntryOrder {
    private final MediaPlayerContext playerContext;
    private static final int MAX_RANDOM_BEST_COUNT = 10;
    private Random shuffleRandom;
    private Set processedResources;

    public ShuffledEntryOrder(MediaPlayerContext playerContext) {
        if (playerContext == null) {
            throw new NullPointerException("playerContext");
        }
        this.playerContext = playerContext;
        this.shuffleRandom = new Random();
        this.processedResources = new HashSet();
    }

    @Override
    public synchronized void setCurrentEntry(MediaCrateEntry entry) {
        Resource resource;
        super.setCurrentEntry(entry);
        if (entry != null && (resource = entry.getResource()) != null) {
            this.processedResources.add(resource);
        }
    }

    public MediaCrateEntry skipPrevEntry() {
        return this.skipShuffledEntry();
    }

    public MediaCrateEntry skipNextEntry() {
        return this.skipShuffledEntry();
    }

    protected synchronized MediaCrateEntry skipShuffledEntry() {
        for (int x = 0; x < 2; ++x) {
            int entryCount = this.playerContext.getEntryCount();
            if (entryCount < 1) {
                this.currentEntry = null;
                this.currentIndex = -1;
                return null;
            }
            int index = this.shuffleRandom.nextInt(entryCount);
            MediaCrateEntry bestEntry = null;
            Resource bestResource = null;
            int bestIndex = -1;
            int bestCount = 0;
            int bestRandom = this.shuffleRandom.nextInt(10) % entryCount;
            MediaCrateEntry entry = null;
            Resource resource = null;
            for (int i = 0; i < entryCount; ++i) {
                entry = this.playerContext.getEntryAt(index);
                if (entry != null && (resource = entry.getResource()) != null && !this.processedResources.contains(resource)) {
                    bestEntry = entry;
                    bestResource = resource;
                    bestIndex = index;
                    if (++bestCount > bestRandom) break;
                }
                index = (index + 1) % entryCount;
            }
            if (bestEntry != null) {
                this.processedResources.add(bestResource);
                this.currentEntry = bestEntry;
                this.currentIndex = bestIndex;
                return bestEntry;
            }
            this.processedResources.clear();
            if (this.loopMode == 0) break;
        }
        this.currentEntry = null;
        this.currentIndex = -1;
        return null;
    }
}

