/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager;

import com.spacekiller.util.media.manager.AbstractSearchFilter;

public class SubStringSearchFilter
extends AbstractSearchFilter {
    private final String sub;
    private final boolean ignoreCase;

    public SubStringSearchFilter(String sub, boolean ignoreCase) {
        if (ignoreCase) {
            sub = sub.toLowerCase();
        }
        this.sub = sub;
        this.ignoreCase = ignoreCase;
    }

    public String toString() {
        return super.toString() + "[ignoreCase=" + this.ignoreCase + ", sub=" + this.sub + "]";
    }

    @Override
    protected boolean acceptString(String s) {
        if (s != null) {
            if (this.ignoreCase) {
                s = s.toLowerCase();
            }
            return s.indexOf(this.sub) >= 0;
        }
        return false;
    }
}

