/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryAlbumArtistTableColumnProvider
extends EntryTableColumnProvider {
    public EntryAlbumArtistTableColumnProvider() {
        this.setHeaderValue("Album Artist");
        this.setTooltipText("Album Artist");
        this.setPreferredWidth(200);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public String getAlbumArtist(MediaTableEntry entry) {
        MediaEntry me = entry.getMediaEntry();
        return me == null ? null : me.getAlbumArtist();
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            return EntryAlbumArtistTableColumnProvider.this.getAlbumArtist(entry);
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            String s1 = EntryAlbumArtistTableColumnProvider.this.getAlbumArtist(e1);
            String s2 = EntryAlbumArtistTableColumnProvider.this.getAlbumArtist(e2);
            return this.compareStringIgnoreCase(s1, s2);
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = -2975930759451371106L;

        protected CellRendererImpl() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            if (value != null && value instanceof MediaTableEntry) {
                MediaTableEntry entry = (MediaTableEntry)value;
                text = EntryAlbumArtistTableColumnProvider.this.getAlbumArtist(entry);
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            return comp;
        }
    }
}

