/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryBitRateTableColumnProvider
extends EntryTableColumnProvider {
    protected double roundFactor = 1.0;

    public EntryBitRateTableColumnProvider() {
        this.setHeaderValue("Bit Rate");
        this.setTooltipText("Bit Rate (Kb/sec)");
        this.setPreferredWidth(70);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public double getRoundFactor() {
        return this.roundFactor;
    }

    public void setRoundFactor(double roundFactor) {
        this.roundFactor = roundFactor;
    }

    public double getBitRate(MediaTableEntry entry) {
        MediaEntry me = entry.getMediaEntry();
        return me == null ? -1.0 : EntryBitRateTableColumnProvider.getBitRate(me);
    }

    public static double getBitRate(MediaEntry me) {
        double bitRate;
        AudioEntry ae = me.getAudioEntry();
        if (ae != null && (bitRate = ae.getBitRate()) >= 0.0) {
            return bitRate;
        }
        double duration = me.getDuration();
        if (duration >= 0.0) {
            long fileSize = me.getFileSize();
            double bitRate2 = (double)fileSize / duration * 8.0;
            return bitRate2;
        }
        return -1.0;
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            double v = EntryBitRateTableColumnProvider.this.getBitRate(entry);
            if (v >= 0.0) {
                return Double.toString(v);
            }
            return null;
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            double v1 = EntryBitRateTableColumnProvider.this.getBitRate(e1);
            double v2 = EntryBitRateTableColumnProvider.this.getBitRate(e2);
            if (Double.isNaN(v1)) {
                v1 = Double.MIN_VALUE;
            }
            if (Double.isNaN(v2)) {
                v2 = Double.MIN_VALUE;
            }
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = -1062621327261787419L;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MediaTableEntry entry;
            double bitRate;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            if (value != null && value instanceof MediaTableEntry && (bitRate = EntryBitRateTableColumnProvider.this.getBitRate(entry = (MediaTableEntry)value)) >= 0.0) {
                double rate = Math.floor(bitRate / 1000.0);
                text = EntryBitRateTableColumnProvider.this.roundFactor == 1.0 ? Long.toString(Math.round(rate)) : Double.toString((double)Math.round(rate * EntryBitRateTableColumnProvider.this.roundFactor) / EntryBitRateTableColumnProvider.this.roundFactor);
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            return comp;
        }
    }
}

