/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryBpmTableColumnProvider
extends EntryTableColumnProvider {
    protected double roundFactor = 1.0;

    public EntryBpmTableColumnProvider() {
        this.setHeaderValue("BPM");
        this.setTooltipText("Tempo (Beats Per Minute)");
        this.setPreferredWidth(70);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public double getRoundFactor() {
        return this.roundFactor;
    }

    public void setRoundFactor(double roundFactor) {
        this.roundFactor = roundFactor;
    }

    public double getBpm(MediaTableEntry entry) {
        AudioEntry ae;
        MediaEntry me = entry.getMediaEntry();
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getBpm();
        }
        return 0.0;
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            double v = EntryBpmTableColumnProvider.this.getBpm(entry);
            if (v > 0.0) {
                return Double.toString(v);
            }
            return null;
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            double v1 = EntryBpmTableColumnProvider.this.getBpm(e1);
            double v2 = EntryBpmTableColumnProvider.this.getBpm(e2);
            if (Double.isNaN(v1)) {
                v1 = Double.MIN_VALUE;
            }
            if (Double.isNaN(v2)) {
                v2 = Double.MIN_VALUE;
            }
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = -1906265002389120479L;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MediaTableEntry entry;
            double bpm;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            if (value != null && value instanceof MediaTableEntry && (bpm = EntryBpmTableColumnProvider.this.getBpm(entry = (MediaTableEntry)value)) > 0.0) {
                text = EntryBpmTableColumnProvider.this.roundFactor == 1.0 ? Long.toString(Math.round(bpm)) : Double.toString((double)Math.round(bpm * EntryBpmTableColumnProvider.this.roundFactor) / EntryBpmTableColumnProvider.this.roundFactor);
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            return comp;
        }

        @Override
        public String getCurrentEntryToolTipText() {
            Object value = this.currentValue;
            if (value != null && value instanceof MediaTableEntry) {
                MediaTableEntry entry = (MediaTableEntry)value;
                double bpm = EntryBpmTableColumnProvider.this.getBpm(entry);
                if (bpm > 0.0) {
                    String sBPM = Double.toString((double)Math.round(bpm * 100.0) / 100.0);
                    return sBPM + " BPM";
                }
                return null;
            }
            return super.getCurrentEntryToolTipText();
        }
    }
}

