/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryCorruptedTableColumnProvider
extends EntryTableColumnProvider {
    public EntryCorruptedTableColumnProvider() {
        this.setHeaderValue("Corrupted");
        this.setTooltipText("File corrupted ?");
        this.setPreferredWidth(50);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public boolean isCorrupted(MediaTableEntry entry) {
        MediaEntry me = entry.getMediaEntry();
        return me == null ? false : me.isCorrupted();
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            return EntryCorruptedTableColumnProvider.this.isCorrupted(entry) ? "Y" : "N";
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            boolean v2;
            boolean v1 = EntryCorruptedTableColumnProvider.this.isCorrupted(e1);
            if (v1 != (v2 = EntryCorruptedTableColumnProvider.this.isCorrupted(e2))) {
                return v2 ? -1 : 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = -9031692842241230504L;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = "";
            if (value != null && value instanceof MediaTableEntry) {
                MediaTableEntry entry = (MediaTableEntry)value;
                boolean flag = EntryCorruptedTableColumnProvider.this.isCorrupted(entry);
                text = flag ? "X" : "";
            }
            this.label.setText(text);
            return comp;
        }
    }
}

