/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryDurationTableColumnProvider
extends EntryTableColumnProvider {
    public EntryDurationTableColumnProvider() {
        this.setHeaderValue("Time");
        this.setTooltipText("Duration");
        this.setPreferredWidth(70);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public double getDuration(MediaTableEntry entry) {
        MediaEntry me = entry.getMediaEntry();
        return me == null ? -1.0 : me.getDuration();
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            double v = EntryDurationTableColumnProvider.this.getDuration(entry);
            if (v >= 0.0) {
                return Double.toString(v);
            }
            return null;
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            double v1 = EntryDurationTableColumnProvider.this.getDuration(e1);
            double v2 = EntryDurationTableColumnProvider.this.getDuration(e2);
            if (Double.isNaN(v1)) {
                v1 = Double.MIN_VALUE;
            }
            if (Double.isNaN(v2)) {
                v2 = Double.MIN_VALUE;
            }
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = 4575900557905620758L;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MediaTableEntry entry;
            double duration;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            if (value != null && value instanceof MediaTableEntry && (duration = EntryDurationTableColumnProvider.this.getDuration(entry = (MediaTableEntry)value)) >= 0.0) {
                long secs = Math.round(Math.ceil(duration));
                long mins = secs / 60L;
                text = mins > 0L ? Long.toString(mins) + ":" + Long.toString(100L + (secs %= 60L)).substring(1) : "0:" + Long.toString(100L + secs).substring(1);
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            return comp;
        }
    }
}

