/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryExistingTableColumnProvider
extends EntryTableColumnProvider {
    public EntryExistingTableColumnProvider() {
        this.setHeaderValue("Exists");
        this.setTooltipText("File exists ?");
        this.setPreferredWidth(50);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public boolean isExisting(MediaTableEntry entry) {
        MediaEntry me = entry.getMediaEntry();
        return me == null ? false : me.isExisting();
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            return EntryExistingTableColumnProvider.this.isExisting(entry) ? "Y" : "N";
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            boolean v2;
            boolean v1 = EntryExistingTableColumnProvider.this.isExisting(e1);
            if (v1 != (v2 = EntryExistingTableColumnProvider.this.isExisting(e2))) {
                return v2 ? -1 : 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = -9031692842241230504L;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            if (value != null && value instanceof MediaTableEntry) {
                MediaTableEntry entry = (MediaTableEntry)value;
                boolean existing = EntryExistingTableColumnProvider.this.isExisting(entry);
                String string = text = existing ? "Y" : "N";
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            return comp;
        }
    }
}

