/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryFileSizeTableColumnProvider
extends EntryTableColumnProvider {
    private static final long KIB = 1024L;
    private static final long MIB = 0x100000L;
    private static final long GIB = 0x40000000L;

    public EntryFileSizeTableColumnProvider() {
        this.setHeaderValue("Size");
        this.setTooltipText("File Size");
        this.setPreferredWidth(70);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public long getFileSize(MediaTableEntry entry) {
        MediaEntry me = entry.getMediaEntry();
        return me == null ? -1L : me.getFileSize();
    }

    public static String getFileSizeString(long size) {
        if (size < 1024L) {
            return Long.toString(size) + " B";
        }
        if (size < 0x100000L) {
            double val = (double)Math.round((double)size / 1024.0 * 10.0) / 10.0;
            return Double.toString(val) + " K";
        }
        if (size < 0x40000000L) {
            double val = (double)Math.round((double)size / 1048576.0 * 10.0) / 10.0;
            return Double.toString(val) + " M";
        }
        double val = (double)Math.round((double)size / 1.073741824E9 * 10.0) / 10.0;
        return Double.toString(val) + " G";
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            long v = EntryFileSizeTableColumnProvider.this.getFileSize(entry);
            if (v >= 0L) {
                return Long.toString(v);
            }
            return null;
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            long v2;
            long v1 = EntryFileSizeTableColumnProvider.this.getFileSize(e1);
            if (v1 < (v2 = EntryFileSizeTableColumnProvider.this.getFileSize(e2))) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = -6770750543089593201L;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MediaTableEntry entry;
            long size;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            if (value != null && value instanceof MediaTableEntry && (size = EntryFileSizeTableColumnProvider.this.getFileSize(entry = (MediaTableEntry)value)) >= 0L) {
                text = EntryFileSizeTableColumnProvider.getFileSizeString(size);
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            return comp;
        }
    }
}

