/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryFrameRateTableColumnProvider
extends EntryTableColumnProvider {
    protected double roundFactor = 1.0;

    public EntryFrameRateTableColumnProvider() {
        this.setHeaderValue("Frame Rate");
        this.setTooltipText("Audio Sample Rate");
        this.setPreferredWidth(70);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public float getFrameRate(MediaTableEntry entry) {
        AudioEntry ae;
        MediaEntry me = entry.getMediaEntry();
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getFrameRate();
        }
        return -1.0f;
    }

    public double getRoundFactor() {
        return this.roundFactor;
    }

    public void setRoundFactor(double roundFactor) {
        this.roundFactor = roundFactor;
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            float v = EntryFrameRateTableColumnProvider.this.getFrameRate(entry);
            if (v > 0.0f) {
                return Float.toString(v);
            }
            return null;
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            float v2;
            float v1 = EntryFrameRateTableColumnProvider.this.getFrameRate(e1);
            if (v1 < (v2 = EntryFrameRateTableColumnProvider.this.getFrameRate(e2))) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = -7207611935323940393L;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MediaTableEntry entry;
            float rate;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            if (value != null && value instanceof MediaTableEntry && (rate = EntryFrameRateTableColumnProvider.this.getFrameRate(entry = (MediaTableEntry)value)) > 0.0f) {
                text = EntryFrameRateTableColumnProvider.this.roundFactor == 1.0 ? Long.toString(Math.round(rate)) : Double.toString((double)Math.round((double)rate * EntryFrameRateTableColumnProvider.this.roundFactor) / EntryFrameRateTableColumnProvider.this.roundFactor);
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            return comp;
        }
    }
}

