/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.PictureEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryImageAlphaTableColumnProvider
extends EntryTableColumnProvider {
    public EntryImageAlphaTableColumnProvider() {
        this.setHeaderValue("Alpha");
        this.setTooltipText("Transparency");
        this.setPreferredWidth(70);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public int getTransparency(MediaTableEntry entry) {
        PictureEntry pe;
        MediaEntry me = entry.getMediaEntry();
        if (me != null && (pe = me.getPictureEntry()) != null) {
            return pe.getTransparency();
        }
        return -1;
    }

    public static String getTransparencyString(int transparency) {
        switch (transparency) {
            case 1: {
                return "Opaque";
            }
            case 2: {
                return "Bitmask";
            }
            case 3: {
                return "Translucent";
            }
        }
        if (transparency > 0) {
            return "#" + transparency;
        }
        return null;
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            int v = EntryImageAlphaTableColumnProvider.this.getTransparency(entry);
            if (v >= 0) {
                return Integer.toString(v);
            }
            return null;
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            int v1 = EntryImageAlphaTableColumnProvider.this.getTransparency(e1);
            int v2 = EntryImageAlphaTableColumnProvider.this.getTransparency(e2);
            if (v1 < 0) {
                v1 = 0;
            }
            if (v2 < 0) {
                v2 = 0;
            }
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = 8728346064533434480L;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MediaTableEntry entry;
            int trans;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            if (value != null && value instanceof MediaTableEntry && (trans = EntryImageAlphaTableColumnProvider.this.getTransparency(entry = (MediaTableEntry)value)) > 0) {
                text = EntryImageAlphaTableColumnProvider.getTransparencyString(trans);
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            return comp;
        }
    }
}

