/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryMaxAmplitudeTableColumnProvider
extends EntryTableColumnProvider {
    public EntryMaxAmplitudeTableColumnProvider() {
        this.setHeaderValue("MaxAmp");
        this.setTooltipText("Maximum Amplitude");
        this.setPreferredWidth(50);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public double getMaxAmplitude(MediaTableEntry entry) {
        AudioEntry ae;
        MediaEntry me = entry.getMediaEntry();
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getMaxAmplitude();
        }
        return Double.NaN;
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            double v = EntryMaxAmplitudeTableColumnProvider.this.getMaxAmplitude(entry);
            if (Double.isNaN(v)) {
                return null;
            }
            return Double.toString(v);
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            double v1 = EntryMaxAmplitudeTableColumnProvider.this.getMaxAmplitude(e1);
            double v2 = EntryMaxAmplitudeTableColumnProvider.this.getMaxAmplitude(e2);
            if (Double.isNaN(v1)) {
                v1 = 0.0;
            }
            if (Double.isNaN(v2)) {
                v2 = 0.0;
            }
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = 539092657758343312L;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MediaTableEntry entry;
            double amp;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = "";
            if (value != null && value instanceof MediaTableEntry && !Double.isNaN(amp = EntryMaxAmplitudeTableColumnProvider.this.getMaxAmplitude(entry = (MediaTableEntry)value))) {
                text = Long.toString(Math.round(amp * 100.0));
                text = text + "%";
            }
            this.label.setText(text);
            return comp;
        }
    }
}

