/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.sound.AudioMath;
import com.spacekiller.util.sound.AudioMathImpl;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryRmsTableColumnProvider
extends EntryTableColumnProvider {
    private final AudioMath audioMath = new AudioMathImpl();
    protected double roundFactor = 10.0;

    public EntryRmsTableColumnProvider() {
        this.setHeaderValue("dB");
        this.setTooltipText("Decibel (RMS)");
        this.setPreferredWidth(70);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public double getRoundFactor() {
        return this.roundFactor;
    }

    public void setRoundFactor(double roundFactor) {
        this.roundFactor = roundFactor;
    }

    public double getRms(MediaTableEntry entry) {
        AudioEntry ae;
        MediaEntry me = entry.getMediaEntry();
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getRms();
        }
        return Double.NaN;
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            double v = EntryRmsTableColumnProvider.this.getRms(entry);
            if (Double.isNaN(v)) {
                return null;
            }
            return Double.toString(v);
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            double v1 = EntryRmsTableColumnProvider.this.getRms(e1);
            double v2 = EntryRmsTableColumnProvider.this.getRms(e2);
            if (Double.isNaN(v1)) {
                v1 = Double.MIN_VALUE;
            }
            if (Double.isNaN(v2)) {
                v2 = Double.MIN_VALUE;
            }
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = 466192278188874740L;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MediaTableEntry entry;
            double rms;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            if (value != null && value instanceof MediaTableEntry && !Double.isNaN(rms = EntryRmsTableColumnProvider.this.getRms(entry = (MediaTableEntry)value))) {
                double dB = EntryRmsTableColumnProvider.this.audioMath.rms2Decibel(rms);
                text = EntryRmsTableColumnProvider.this.roundFactor == 1.0 ? Long.toString(Math.round(dB)) : Double.toString((double)Math.round(dB * EntryRmsTableColumnProvider.this.roundFactor) / EntryRmsTableColumnProvider.this.roundFactor);
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            return comp;
        }
    }
}

