/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.media.manager.RatingIcon;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryTitleTableColumnProvider
extends EntryTableColumnProvider {
    private RatingIcon ratingIcon;
    private JLabel ratingLabel;

    public EntryTitleTableColumnProvider() {
        this.setHeaderValue("Title");
        this.setTooltipText("Track Title");
        this.setPreferredWidth(300);
        this.setRatingIcon(new RatingIcon(true));
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public String getTitle(MediaTableEntry entry) {
        String s;
        MediaEntry me = entry.getMediaEntry();
        if (me != null) {
            return me.getTitle();
        }
        Resource res = entry.getResource();
        if (res != null && (s = res.toString()) != null) {
            int x = s.lastIndexOf(47);
            if (x >= 0) {
                s = s.substring(x + 1);
            }
            if ((x = s.lastIndexOf(92)) >= 0) {
                s = s.substring(x + 1);
            }
            return s;
        }
        return null;
    }

    public RatingIcon getRatingIcon() {
        return this.ratingIcon;
    }

    public void setRatingIcon(RatingIcon ratingIcon) {
        this.ratingIcon = ratingIcon;
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            return EntryTitleTableColumnProvider.this.getTitle(entry);
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            String s1 = EntryTitleTableColumnProvider.this.getTitle(e1);
            String s2 = EntryTitleTableColumnProvider.this.getTitle(e2);
            return this.compareStringIgnoreCase(s1, s2);
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = 1270783860843573207L;

        public CellRendererImpl() {
            EntryTitleTableColumnProvider.this.ratingLabel = new JLabel();
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add(this.label, "Center");
            this.add(EntryTitleTableColumnProvider.this.ratingLabel, "East");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            RatingIcon eastIcon = null;
            if (value != null && value instanceof MediaTableEntry) {
                RatingIcon ri;
                double rating;
                MediaTableEntry entry = (MediaTableEntry)value;
                text = EntryTitleTableColumnProvider.this.getTitle(entry);
                MediaEntry me = entry.getMediaEntry();
                if (me != null && !Double.isNaN(rating = me.getUserRating()) && (ri = EntryTitleTableColumnProvider.this.ratingIcon) != null) {
                    ri.setRating(rating);
                    eastIcon = ri;
                }
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            EntryTitleTableColumnProvider.this.ratingLabel.setIcon(eastIcon);
            return comp;
        }
    }
}

