/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryUserRatingTableColumnProvider
extends EntryTableColumnProvider {
    public EntryUserRatingTableColumnProvider() {
        this.setHeaderValue("Rating");
        this.setTooltipText("User Rating");
        this.setPreferredWidth(50);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public double getUserRating(MediaTableEntry entry) {
        MediaEntry me = entry.getMediaEntry();
        return me == null ? Double.NaN : me.getUserRating();
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            double v = EntryUserRatingTableColumnProvider.this.getUserRating(entry);
            if (Double.isNaN(v)) {
                return null;
            }
            return Double.toString(v);
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            double v1 = EntryUserRatingTableColumnProvider.this.getUserRating(e1);
            double v2 = EntryUserRatingTableColumnProvider.this.getUserRating(e2);
            if (Double.isNaN(v1)) {
                v1 = 0.0;
            }
            if (Double.isNaN(v2)) {
                v2 = 0.0;
            }
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = 5390925701747234642L;
        private Color positiveColor = Color.BLACK;
        private Color negativeColor = Color.RED;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(4);
            this.positiveColor = this.label.getForeground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MediaTableEntry entry;
            double rating;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = "";
            Color col = this.positiveColor;
            if (value != null && value instanceof MediaTableEntry && !Double.isNaN(rating = EntryUserRatingTableColumnProvider.this.getUserRating(entry = (MediaTableEntry)value)) && rating != 0.0) {
                text = Long.toString(Math.round(rating * 100.0));
                text = text + "%";
                if (rating < 0.0) {
                    col = this.negativeColor;
                }
            }
            this.label.setForeground(col);
            this.label.setText(text);
            return comp;
        }
    }
}

