/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.manager.column;

import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.manager.EntryTableCellFormatter;
import com.spacekiller.util.media.manager.EntryTableCellRenderer;
import com.spacekiller.util.media.manager.EntryTableColumnComparator;
import com.spacekiller.util.media.manager.EntryTableColumnProvider;
import com.spacekiller.util.media.manager.MediaTableEntry;
import com.spacekiller.util.table.TableCellFormatter;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class EntryZeroCrossingsTableColumnProvider
extends EntryTableColumnProvider {
    public EntryZeroCrossingsTableColumnProvider() {
        this.setHeaderValue("Zero~");
        this.setTooltipText("Number of zero crossings");
        this.setPreferredWidth(80);
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new CellRendererImpl();
    }

    @Override
    protected EntryTableColumnComparator createColumnComparator(boolean ascending) {
        return new EntryComparatorImpl(ascending);
    }

    public TableCellFormatter createCellFormatter(TableModel model) {
        return new CellFormatterImpl();
    }

    public long getZeroCrossings(MediaTableEntry entry) {
        AudioEntry ae;
        MediaEntry me = entry.getMediaEntry();
        if (me != null && (ae = me.getAudioEntry()) != null) {
            return ae.getZeroCrossings();
        }
        return -1L;
    }

    protected class CellFormatterImpl
    extends EntryTableCellFormatter {
        protected CellFormatterImpl() {
        }

        @Override
        protected String getValueAsString(MediaTableEntry entry) {
            long v = EntryZeroCrossingsTableColumnProvider.this.getZeroCrossings(entry);
            if (v >= 0L) {
                return Long.toString(v);
            }
            return null;
        }
    }

    protected class EntryComparatorImpl
    extends EntryTableColumnComparator {
        public EntryComparatorImpl(boolean ascending) {
            super(ascending);
        }

        @Override
        protected int compareEntry(MediaTableEntry e1, MediaTableEntry e2) {
            long v1 = EntryZeroCrossingsTableColumnProvider.this.getZeroCrossings(e1);
            long v2 = EntryZeroCrossingsTableColumnProvider.this.getZeroCrossings(e2);
            if (v1 < 0L) {
                v1 = -1L;
            }
            if (v2 < 0L) {
                v2 = -1L;
            }
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }

    protected class CellRendererImpl
    extends EntryTableCellRenderer {
        private static final long serialVersionUID = -1719266047960238908L;

        public CellRendererImpl() {
            this.label.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            MediaTableEntry entry;
            long v;
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            String text = null;
            if (value != null && value instanceof MediaTableEntry && (v = EntryZeroCrossingsTableColumnProvider.this.getZeroCrossings(entry = (MediaTableEntry)value)) >= 0L) {
                text = Long.toString(v);
            }
            if (text == null) {
                text = "";
            }
            this.label.setText(text);
            return comp;
        }
    }
}

