/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media;

import com.spacekiller.util.media.AbstractMediaCrate;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaLibrary;
import java.io.IOException;

public abstract class AbstractMediaContext
implements MediaContext {
    protected final MediaContext parent;

    public AbstractMediaContext(MediaContext parent) {
        this.parent = parent;
    }

    @Override
    public final MediaContext getParent() {
        return this.parent;
    }

    @Override
    public MediaLibrary getMediaLibrary(String libraryId) throws IOException {
        if (this.parent != null) {
            return this.parent.getMediaLibrary(libraryId);
        }
        return null;
    }

    @Override
    public void registerMediaLibrary(MediaLibrary library) throws IOException {
        if (this.parent != null) {
            this.parent.registerMediaLibrary(library);
        }
    }

    @Override
    public void unregisterMediaLibrary(MediaLibrary library) throws IOException {
        if (this.parent != null) {
            this.parent.unregisterMediaLibrary(library);
        }
    }

    protected void setCrateId(AbstractMediaCrate crate, String id) {
        crate.setId(id);
    }
}

