/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media;

import com.spacekiller.util.ListenerList;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaCrateEntryListener;
import com.spacekiller.util.media.MediaCrateListener;
import com.spacekiller.util.media.MediaLibrary;

public abstract class AbstractMediaCrate
implements MediaCrate {
    private AbstractMediaCrate parent;
    private String id;
    private String name;
    private String description;
    private transient ListenerList<MediaCrateListener> crateListeners;
    private transient ListenerList<MediaCrateEntryListener> entryListeners;

    public AbstractMediaCrate(String id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public MediaLibrary getLibrary() {
        AbstractMediaCrate p = this.parent;
        if (p != null) {
            return p.getLibrary();
        }
        return null;
    }

    @Override
    public MediaCrate getParent() {
        return this.parent;
    }

    protected void setParent(AbstractMediaCrate parent) {
        this.parent = parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setChildParent(AbstractMediaCrate crate, AbstractMediaCrate parent) {
        crate.setParent(parent);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        if (this.name == name) {
            return;
        }
        this.name = name;
        this.fireCrateUpdated(this);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        if (this.description == description) {
            return;
        }
        this.description = description;
        this.fireCrateUpdated(this);
    }

    @Override
    public synchronized void addMediaCrateListener(MediaCrateListener listener) {
        if (listener == null) {
            return;
        }
        if (this.crateListeners == null) {
            this.crateListeners = new ListenerList(MediaCrateListener.class);
        }
        this.crateListeners.add((Object)listener);
    }

    @Override
    public synchronized void removeMediaCrateListener(MediaCrateListener listener) {
        if (listener == null) {
            return;
        }
        if (this.crateListeners == null) {
            return;
        }
        this.crateListeners.remove((Object)listener);
    }

    @Override
    public synchronized void addMediaCrateEntryListener(MediaCrateEntryListener listener) {
        if (listener == null) {
            return;
        }
        if (this.entryListeners == null) {
            this.entryListeners = new ListenerList(MediaCrateEntryListener.class);
        }
        this.entryListeners.add((Object)listener);
    }

    @Override
    public synchronized void removeMediaCrateEntryListener(MediaCrateEntryListener listener) {
        if (listener == null) {
            return;
        }
        if (this.entryListeners == null) {
            return;
        }
        this.entryListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStructureChanged(MediaCrate crate) {
        AbstractMediaCrate p;
        MediaCrateListener[] arr = null;
        AbstractMediaCrate abstractMediaCrate = this;
        synchronized (abstractMediaCrate) {
            if (this.crateListeners != null) {
                arr = (MediaCrateListener[])this.crateListeners.array();
            }
        }
        if (arr != null) {
            for (MediaCrateListener l : arr) {
                l.structureChanged(crate);
            }
        }
        if ((p = this.parent) != null) {
            p.fireStructureChanged(crate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCrateInserted(MediaCrate crate, MediaCrate child, int index) {
        AbstractMediaCrate p;
        MediaCrateListener[] arr = null;
        AbstractMediaCrate abstractMediaCrate = this;
        synchronized (abstractMediaCrate) {
            if (this.crateListeners != null) {
                arr = (MediaCrateListener[])this.crateListeners.array();
            }
        }
        if (arr != null) {
            for (MediaCrateListener l : arr) {
                l.crateInserted(crate, child, index);
            }
        }
        if ((p = this.parent) != null) {
            p.fireCrateInserted(crate, child, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCrateRemoved(MediaCrate crate, MediaCrate child, int index) {
        AbstractMediaCrate p;
        MediaCrateListener[] arr = null;
        AbstractMediaCrate abstractMediaCrate = this;
        synchronized (abstractMediaCrate) {
            if (this.crateListeners != null) {
                arr = (MediaCrateListener[])this.crateListeners.array();
            }
        }
        if (arr != null) {
            for (MediaCrateListener l : arr) {
                l.crateRemoved(crate, child, index);
            }
        }
        if ((p = this.parent) != null) {
            p.fireCrateRemoved(crate, child, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCrateUpdated(MediaCrate crate) {
        AbstractMediaCrate p;
        MediaCrateListener[] arr = null;
        AbstractMediaCrate abstractMediaCrate = this;
        synchronized (abstractMediaCrate) {
            if (this.crateListeners != null) {
                arr = (MediaCrateListener[])this.crateListeners.array();
            }
        }
        if (arr != null) {
            for (MediaCrateListener l : arr) {
                l.crateUpdated(crate);
            }
        }
        if ((p = this.parent) != null) {
            p.fireCrateUpdated(crate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEntryInserted(MediaCrate crate, MediaCrateEntry child, int index) {
        AbstractMediaCrate p;
        MediaCrateEntryListener[] arr = null;
        AbstractMediaCrate abstractMediaCrate = this;
        synchronized (abstractMediaCrate) {
            if (this.entryListeners != null) {
                arr = (MediaCrateEntryListener[])this.entryListeners.array();
            }
        }
        if (arr != null) {
            for (MediaCrateEntryListener l : arr) {
                l.entryInserted(crate, child, index);
            }
        }
        if ((p = this.parent) != null) {
            p.fireEntryInserted(crate, child, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEntriesInserted(MediaCrate crate, int firstIndex, int lastIndex) {
        AbstractMediaCrate p;
        MediaCrateEntryListener[] arr = null;
        AbstractMediaCrate abstractMediaCrate = this;
        synchronized (abstractMediaCrate) {
            if (this.entryListeners != null) {
                arr = (MediaCrateEntryListener[])this.entryListeners.array();
            }
        }
        if (arr != null) {
            for (MediaCrateEntryListener l : arr) {
                l.entriesInserted(crate, firstIndex, lastIndex);
            }
        }
        if ((p = this.parent) != null) {
            p.fireEntriesInserted(crate, firstIndex, lastIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEntryRemoved(MediaCrate crate, MediaCrateEntry child, int index) {
        AbstractMediaCrate p;
        MediaCrateEntryListener[] arr = null;
        AbstractMediaCrate abstractMediaCrate = this;
        synchronized (abstractMediaCrate) {
            if (this.entryListeners != null) {
                arr = (MediaCrateEntryListener[])this.entryListeners.array();
            }
        }
        if (arr != null) {
            for (MediaCrateEntryListener l : arr) {
                l.entryRemoved(crate, child, index);
            }
        }
        if ((p = this.parent) != null) {
            p.fireEntryRemoved(crate, child, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEntriesRemoved(MediaCrate crate, int firstIndex, int lastIndex) {
        AbstractMediaCrate p;
        MediaCrateEntryListener[] arr = null;
        AbstractMediaCrate abstractMediaCrate = this;
        synchronized (abstractMediaCrate) {
            if (this.entryListeners != null) {
                arr = (MediaCrateEntryListener[])this.entryListeners.array();
            }
        }
        if (arr != null) {
            for (MediaCrateEntryListener l : arr) {
                l.entriesRemoved(crate, firstIndex, lastIndex);
            }
        }
        if ((p = this.parent) != null) {
            p.fireEntriesRemoved(crate, firstIndex, lastIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEntryUpdated(MediaCrate crate, MediaCrateEntry child, int index) {
        AbstractMediaCrate p;
        MediaCrateEntryListener[] arr = null;
        AbstractMediaCrate abstractMediaCrate = this;
        synchronized (abstractMediaCrate) {
            if (this.entryListeners != null) {
                arr = (MediaCrateEntryListener[])this.entryListeners.array();
            }
        }
        if (arr != null) {
            for (MediaCrateEntryListener l : arr) {
                l.entryUpdated(crate, child, index);
            }
        }
        if ((p = this.parent) != null) {
            p.fireEntryUpdated(crate, child, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEntriesUpdated(MediaCrate crate, int firstIndex, int lastIndex) {
        AbstractMediaCrate p;
        MediaCrateEntryListener[] arr = null;
        AbstractMediaCrate abstractMediaCrate = this;
        synchronized (abstractMediaCrate) {
            if (this.entryListeners != null) {
                arr = (MediaCrateEntryListener[])this.entryListeners.array();
            }
        }
        if (arr != null) {
            for (MediaCrateEntryListener l : arr) {
                l.entriesUpdated(crate, firstIndex, lastIndex);
            }
        }
        if ((p = this.parent) != null) {
            p.fireEntriesUpdated(crate, firstIndex, lastIndex);
        }
    }

    public String toString() {
        return String.valueOf(this.name);
    }

    protected void checkRecursiveChild(MediaCrate child) throws IllegalArgumentException {
        if (this.isRecursiveChild(child)) {
            throw new IllegalArgumentException("Recursive child detected: " + child);
        }
    }

    protected boolean isRecursiveChild(MediaCrate child) {
        if (child == null) {
            return false;
        }
        for (MediaCrate parent = this; parent != null; parent = parent.getParent()) {
            if (parent != child) continue;
            return true;
        }
        return false;
    }
}

