/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media;

import com.spacekiller.util.ListenerList;
import com.spacekiller.util.media.Player;
import com.spacekiller.util.media.PlayerListener;

public abstract class AbstractPlayer
implements Player {
    private ListenerList<PlayerListener> listeners = new ListenerList(PlayerListener.class);

    @Override
    public boolean isStopped() {
        return this.getState() == 0;
    }

    @Override
    public boolean isPaused() {
        return this.getState() == 2;
    }

    @Override
    public boolean isPlaying() {
        return this.getState() == 1;
    }

    @Override
    public synchronized void addPlayerListener(PlayerListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add((Object)listener);
    }

    @Override
    public synchronized void removePlayerListener(PlayerListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove((Object)listener);
    }

    protected synchronized void fireStateChanged(Player player) {
        for (PlayerListener l : (PlayerListener[])this.listeners.array()) {
            l.stateChanged(player);
        }
    }

    protected synchronized void fireItemChanged(Player player) {
        for (PlayerListener l : (PlayerListener[])this.listeners.array()) {
            l.itemChanged(player);
        }
    }
}

