/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media;

import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaUtil;
import com.spacekiller.util.media.MutableAudioEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.Arrays;

public class DefaultAudioEntry
implements MutableAudioEntry,
Cloneable {
    private static final int VERSION_0 = 0;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int VERSION_3 = 3;
    private static final int VERSION_4 = 4;
    private static final int VERSION = 4;
    private static final short MAX_TEMPO_DATA_LENGTH = 1024;
    private double bpmCustom = 0.0;
    private double bpmImport = 0.0;
    private double bpmStored = 0.0;
    private byte[] tempoData;
    private double rms = Double.NaN;
    private double peakRms = Double.NaN;
    private String audioCodec;
    private int channels = -1;
    private float frameRate = -1.0f;
    private long frameCount = -1L;
    private int bitDepth = -1;
    private double bitRate = -1.0;
    private long zeroCrossings = -1L;
    private double minAmplitude = Double.NaN;
    private double maxAmplitude = Double.NaN;
    private int normalized = 0;
    private double firstSoundMillis = Double.NaN;
    private double lastSoundMillis = Double.NaN;

    @Override
    public double getRms() {
        return this.rms;
    }

    @Override
    public void setRms(double rms) {
        this.rms = rms;
    }

    @Override
    public double getPeakRms() {
        return this.peakRms;
    }

    @Override
    public void setPeakRms(double peakRms) {
        this.peakRms = peakRms;
    }

    @Override
    public int getChannels() {
        return this.channels;
    }

    @Override
    public void setChannels(int channels) {
        this.channels = channels;
    }

    @Override
    public float getFrameRate() {
        return this.frameRate;
    }

    @Override
    public void setFrameRate(float frameRate) {
        this.frameRate = frameRate;
    }

    @Override
    public long getFrameCount() {
        return this.frameCount;
    }

    @Override
    public void setFrameCount(long frameCount) {
        this.frameCount = frameCount;
    }

    @Override
    public int getBitDepth() {
        return this.bitDepth;
    }

    @Override
    public void setBitDepth(int bitDepth) {
        this.bitDepth = bitDepth;
    }

    @Override
    public double getBitRate() {
        return this.bitRate;
    }

    @Override
    public void setBitRate(double bitRate) {
        this.bitRate = bitRate;
    }

    @Override
    public String getAudioCodec() {
        return this.audioCodec;
    }

    @Override
    public void setAudioCodec(String audioCodec) {
        this.audioCodec = audioCodec;
    }

    @Override
    public long getZeroCrossings() {
        return this.zeroCrossings;
    }

    @Override
    public void setZeroCrossings(long zeroCrossings) {
        this.zeroCrossings = zeroCrossings;
    }

    @Override
    public double getMinAmplitude() {
        return this.minAmplitude;
    }

    @Override
    public void setMinAmplitude(double minAmplitude) {
        this.minAmplitude = minAmplitude;
    }

    @Override
    public double getMaxAmplitude() {
        return this.maxAmplitude;
    }

    @Override
    public void setMaxAmplitude(double maxAmplitude) {
        this.maxAmplitude = maxAmplitude;
    }

    @Override
    public int getNormalized() {
        return this.normalized;
    }

    @Override
    public void setNormalized(int normalized) {
        this.normalized = normalized;
    }

    @Override
    public double getFirstSoundMillis() {
        return this.firstSoundMillis;
    }

    @Override
    public void setFirstSoundMillis(double firstSoundMillis) {
        this.firstSoundMillis = firstSoundMillis;
    }

    @Override
    public double getLastSoundMillis() {
        return this.lastSoundMillis;
    }

    @Override
    public void setLastSoundMillis(double lastSoundMillis) {
        this.lastSoundMillis = lastSoundMillis;
    }

    @Override
    public byte[] getTempoData() {
        return this.tempoData;
    }

    @Override
    public void setTempoData(byte[] tempoData) {
        this.tempoData = tempoData;
    }

    @Override
    public void writeEntry(DataOutput out) throws IOException {
        int tempoDataLen;
        out.writeByte(4);
        out.writeDouble(this.bpmStored);
        out.writeDouble(this.rms);
        out.writeDouble(this.peakRms);
        out.writeInt(this.channels);
        out.writeFloat(this.frameRate);
        out.writeLong(this.frameCount);
        out.writeInt(this.bitDepth);
        out.writeDouble(this.bitRate);
        MediaUtil.writeString(this.audioCodec, out);
        out.writeLong(this.zeroCrossings);
        out.writeDouble(this.minAmplitude);
        out.writeDouble(this.maxAmplitude);
        out.writeByte(this.normalized);
        out.writeDouble(this.firstSoundMillis);
        out.writeDouble(this.lastSoundMillis);
        byte[] tempoData = this.tempoData;
        int n = tempoDataLen = tempoData == null ? 0 : tempoData.length;
        if (tempoDataLen < 1) {
            out.writeByte(0);
        } else if (tempoDataLen < 255) {
            out.writeByte((byte)tempoDataLen);
            out.write(tempoData, 0, tempoDataLen);
        } else if (tempoDataLen <= 1024) {
            out.writeByte(255);
            out.writeShort((short)tempoDataLen);
            out.write(tempoData, 0, tempoDataLen);
        } else {
            throw new IllegalArgumentException("Invalid tempoDataLen: " + tempoDataLen + " > " + 1024);
        }
        out.writeDouble(this.bpmCustom);
        out.writeDouble(this.bpmImport);
    }

    @Override
    public void readEntry(DataInput in, MediaContext context) throws IOException {
        int tempoDataLen;
        byte version = in.readByte();
        if (version > 4 || version < 0) {
            throw new StreamCorruptedException("Unsupported version: " + version + " > " + 4);
        }
        this.bpmStored = in.readDouble();
        this.rms = in.readDouble();
        this.peakRms = in.readDouble();
        this.channels = in.readInt();
        this.frameRate = in.readFloat();
        this.frameCount = in.readLong();
        this.bitDepth = in.readInt();
        this.bitRate = in.readDouble();
        this.audioCodec = MediaUtil.readString(in);
        long zCrossings = -1L;
        if (version >= 1) {
            zCrossings = in.readLong();
        }
        this.zeroCrossings = zCrossings;
        double zMinAmplitude = Double.NaN;
        double zMaxAmplitude = Double.NaN;
        byte zNormalized = 0;
        double zFirstSoundMillis = Double.NaN;
        double zLastSoundMillis = Double.NaN;
        if (version >= 2) {
            zMinAmplitude = in.readDouble();
            zMaxAmplitude = in.readDouble();
            zNormalized = in.readByte();
            zFirstSoundMillis = in.readDouble();
            zLastSoundMillis = in.readDouble();
        }
        this.minAmplitude = zMinAmplitude;
        this.maxAmplitude = zMaxAmplitude;
        this.normalized = zNormalized;
        this.firstSoundMillis = zFirstSoundMillis;
        this.lastSoundMillis = zLastSoundMillis;
        byte[] zTempoData = null;
        if (version >= 3 && (tempoDataLen = in.readByte() & 0xFF) > 0) {
            if (tempoDataLen == 255) {
                tempoDataLen = in.readShort();
                if (tempoDataLen < 1) {
                    throw new StreamCorruptedException("Invalid tempoDataLen: " + tempoDataLen);
                }
                if (tempoDataLen > 1024) {
                    throw new StreamCorruptedException("Invalid tempoDataLen: " + tempoDataLen + " > " + 1024);
                }
            }
            zTempoData = new byte[tempoDataLen];
            in.readFully(zTempoData, 0, tempoDataLen);
        }
        this.tempoData = zTempoData;
        double zBpmCustom = 0.0;
        double zBpmImport = 0.0;
        if (version >= 4) {
            zBpmCustom = in.readDouble();
            zBpmImport = in.readDouble();
        }
        this.bpmCustom = zBpmCustom;
        this.bpmImport = zBpmImport;
    }

    @Override
    public AudioEntry cloneEntry() throws CloneNotSupportedException {
        DefaultAudioEntry clone = (DefaultAudioEntry)this.clone();
        return clone;
    }

    @Override
    public boolean mergeEntry(AudioEntry me) {
        byte[] currData;
        byte[] newData;
        String codec;
        long lValue;
        float fValue;
        int iValue;
        if (me == null) {
            return false;
        }
        boolean merged = false;
        double dValue = me.getBpmCustom();
        if (dValue > 0.0 && dValue != this.bpmCustom) {
            this.bpmCustom = dValue;
            merged = true;
        }
        if ((dValue = me.getBpmImport()) > 0.0 && dValue != this.bpmImport) {
            this.bpmImport = dValue;
            merged = true;
        }
        if ((dValue = me.getBpmStored()) > 0.0 && dValue != this.bpmStored) {
            this.bpmStored = dValue;
            merged = true;
        }
        if (!Double.isNaN(dValue = me.getRms()) && dValue != this.rms) {
            this.rms = dValue;
            merged = true;
        }
        if (!Double.isNaN(dValue = me.getPeakRms()) && dValue != this.peakRms) {
            this.peakRms = dValue;
            merged = true;
        }
        if ((iValue = me.getChannels()) > 0 && iValue != this.channels) {
            this.channels = iValue;
            merged = true;
        }
        if ((fValue = me.getFrameRate()) > 0.0f && fValue != this.frameRate) {
            this.frameRate = fValue;
            merged = true;
        }
        if ((iValue = me.getBitDepth()) > 0 && iValue != this.bitDepth) {
            this.bitDepth = iValue;
            merged = true;
        }
        if ((lValue = me.getFrameCount()) >= 0L && lValue != this.frameCount) {
            this.frameCount = lValue;
            merged = true;
        }
        if ((dValue = me.getBitRate()) > 0.0 && dValue != this.bitRate) {
            this.bitRate = dValue;
            merged = true;
        }
        if ((lValue = me.getZeroCrossings()) >= 0L && lValue != this.zeroCrossings) {
            this.zeroCrossings = lValue;
            merged = true;
        }
        if ((codec = me.getAudioCodec()) != null && codec.length() > 0 && !codec.equals(this.audioCodec)) {
            this.audioCodec = codec;
            merged = true;
        }
        if (!Double.isNaN(dValue = me.getMinAmplitude()) && dValue != this.minAmplitude) {
            this.minAmplitude = dValue;
            merged = true;
        }
        if (!Double.isNaN(dValue = me.getMaxAmplitude()) && dValue != this.maxAmplitude) {
            this.maxAmplitude = dValue;
            merged = true;
        }
        if ((iValue = me.getNormalized()) != 0 && iValue != this.normalized) {
            this.normalized = iValue;
            merged = true;
        }
        if (!Double.isNaN(dValue = me.getFirstSoundMillis()) && dValue != this.firstSoundMillis) {
            this.firstSoundMillis = dValue;
            merged = true;
        }
        if (!Double.isNaN(dValue = me.getLastSoundMillis()) && dValue != this.lastSoundMillis) {
            this.lastSoundMillis = dValue;
            merged = true;
        }
        if (!((newData = me.getTempoData()) == null || (currData = this.tempoData) != null && Arrays.equals(newData, currData))) {
            this.tempoData = newData;
            merged = true;
        }
        return merged;
    }

    @Override
    public double getBpmCustom() {
        return this.bpmCustom;
    }

    @Override
    public void setBpmCustom(double bpmCustom) {
        this.bpmCustom = bpmCustom;
    }

    @Override
    public double getBpmImport() {
        return this.bpmImport;
    }

    @Override
    public void setBpmImport(double bpmImport) {
        this.bpmImport = bpmImport;
    }

    @Override
    public double getBpmStored() {
        return this.bpmStored;
    }

    @Override
    public void setBpmStored(double bpmStored) {
        this.bpmStored = bpmStored;
    }

    @Override
    public double getBpm() {
        double bpm = this.bpmCustom;
        if (bpm > 0.0) {
            return bpm;
        }
        bpm = this.bpmImport;
        if (bpm > 0.0) {
            return bpm;
        }
        bpm = this.bpmStored;
        if (bpm > 0.0) {
            return bpm;
        }
        return 0.0;
    }
}

