/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.MediaAnalyzer;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaLibrary;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultMediaAnalyzer
implements MediaAnalyzer {
    private static final Logger logger = Logger.getLogger(DefaultMediaAnalyzer.class.getName());
    private MediaAnalyzer[] analyzers;

    public DefaultMediaAnalyzer(MediaAnalyzer[] analyzers) {
        this.analyzers = analyzers;
    }

    @Override
    public MediaEntry analyzeMediaResource(Resource resource, MediaEntry entry, MediaLibrary library) throws IOException {
        for (MediaAnalyzer s : this.analyzers) {
            try {
                MediaEntry r = s.analyzeMediaResource(resource, entry, library);
                if (r == null || r.getFormat() == null) continue;
                return r;
            }
            catch (Throwable e) {
                if (!logger.isLoggable(Level.INFO)) continue;
                logger.info("Failed to analyze media: analyzer=" + s + ", resource=" + resource + ", message=" + e.getMessage());
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
        return null;
    }
}

