/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media;

import com.spacekiller.util.media.AbstractMediaCrate;
import com.spacekiller.util.media.DefaultMediaCrateEntry;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MutableMediaCrate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DefaultMediaCrate
extends AbstractMediaCrate
implements MutableMediaCrate {
    protected List crates;
    protected List entries;
    protected transient boolean dirty;

    public DefaultMediaCrate(String id, String name) {
        super(id, name);
        this.init();
    }

    protected void init() {
        this.crates = new ArrayList();
        this.entries = new ArrayList();
    }

    @Override
    protected void setId(String id) {
        super.setId(id);
        this.setDirty(true);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setDirty(true);
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
        this.setDirty(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getEntries(Collection dst) {
        if (dst != null) {
            List list = this.entries;
            synchronized (list) {
                dst.addAll(this.entries);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEntryCount() {
        List list = this.entries;
        synchronized (list) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaCrateEntry getEntryAt(int index) {
        List list = this.entries;
        synchronized (list) {
            return (MediaCrateEntry)this.entries.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEntryIndex(MediaCrateEntry entry) {
        List list = this.entries;
        synchronized (list) {
            return this.entries.indexOf(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(MediaCrateEntry entry) {
        int index;
        if (entry == null) {
            throw new NullPointerException();
        }
        List list = this.entries;
        synchronized (list) {
            index = this.entries.size();
            this.entries.add(entry);
        }
        this.setDirty(true);
        this.fireEntryInserted(this, entry, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertEntryAt(MediaCrateEntry entry, int index) {
        if (entry == null) {
            throw new NullPointerException();
        }
        List list = this.entries;
        synchronized (list) {
            this.entries.add(index, entry);
        }
        this.setDirty(true);
        this.fireEntryInserted(this, entry, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaCrateEntry removeEntryAt(int index) {
        MediaCrateEntry entry;
        List list = this.entries;
        synchronized (list) {
            entry = (MediaCrateEntry)this.entries.remove(index);
        }
        this.setDirty(true);
        this.fireEntryRemoved(this, entry, index);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeEntry(MediaCrateEntry entry) {
        int index;
        List list = this.entries;
        synchronized (list) {
            index = this.entries.indexOf(entry);
            if (index >= 0) {
                this.entries.remove(index);
            }
        }
        if (index >= 0) {
            this.setDirty(true);
            this.fireEntryRemoved(this, entry, index);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCrates(Collection dst) {
        if (dst != null) {
            List list = this.crates;
            synchronized (list) {
                dst.addAll(this.crates);
            }
        }
    }

    @Override
    public boolean isLeafCrate() {
        return this.getCrateCount() < 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCrateCount() {
        List list = this.crates;
        synchronized (list) {
            return this.crates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaCrate getCrateAt(int index) {
        List list = this.crates;
        synchronized (list) {
            return (MediaCrate)this.crates.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCrateIndex(MediaCrate crate) {
        List list = this.crates;
        synchronized (list) {
            return this.crates.indexOf(crate);
        }
    }

    @Override
    public MediaCrate newCrate(String id, String name) {
        return new DefaultMediaCrate(id, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCrate(MediaCrate crate) {
        if (crate != null && crate instanceof AbstractMediaCrate) {
            int index;
            AbstractMediaCrate child;
            AbstractMediaCrate abstractMediaCrate = child = (AbstractMediaCrate)crate;
            synchronized (abstractMediaCrate) {
                MediaCrate p = child.getParent();
                if (p != null) {
                    throw new IllegalArgumentException("Crate has already a parent: child=" + child + ", parent=" + p);
                }
                this.checkRecursiveChild(child);
                child.setParent(this);
            }
            List list = this.crates;
            synchronized (list) {
                index = this.crates.size();
                this.crates.add(child);
            }
            this.setDirty(true);
            this.fireCrateInserted(this, child, index);
            return;
        }
        throw new IllegalArgumentException("Unsupported child crate: " + crate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertCrateAt(MediaCrate crate, int index) {
        if (crate != null && crate instanceof AbstractMediaCrate) {
            AbstractMediaCrate child = (AbstractMediaCrate)crate;
            Object object = child;
            synchronized (object) {
                MediaCrate p = child.getParent();
                if (p != null) {
                    throw new IllegalArgumentException("Crate has already a parent: child=" + child + ", parent=" + p);
                }
                this.checkRecursiveChild(child);
                child.setParent(this);
            }
            object = this.crates;
            synchronized (object) {
                this.crates.add(index, child);
            }
            this.setDirty(true);
            this.fireCrateInserted(this, child, index);
            return;
        }
        throw new IllegalArgumentException("Unsupported child crate: " + crate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeCrate(MediaCrate crate) {
        int index;
        AbstractMediaCrate child = null;
        Object object = this.crates;
        synchronized (object) {
            index = this.crates.indexOf(crate);
            if (index >= 0) {
                child = (AbstractMediaCrate)this.crates.remove(index);
            }
        }
        if (child != null) {
            object = child;
            synchronized (object) {
                if (child.getParent() == this) {
                    child.setParent(null);
                }
            }
            this.setDirty(true);
            this.fireCrateRemoved(this, child, index);
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaCrate removeCrateAt(int index) {
        AbstractMediaCrate child;
        Object object = this.crates;
        synchronized (object) {
            child = (AbstractMediaCrate)this.crates.remove(index);
        }
        if (child != null) {
            object = child;
            synchronized (object) {
                if (child.getParent() == this) {
                    child.setParent(null);
                }
            }
            this.setDirty(true);
            this.fireCrateRemoved(this, child, index);
        }
        return child;
    }

    @Override
    public void refresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadAll() {
        if (this.crates != null) {
            int index = 0;
            while (true) {
                AbstractMediaCrate crate;
                List list = this.crates;
                synchronized (list) {
                    if (index >= this.crates.size()) {
                        break;
                    }
                    crate = (AbstractMediaCrate)this.crates.get(index);
                }
                crate.loadAll();
                ++index;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaCrate cloneMediaCrate() throws CloneNotSupportedException {
        List cloneEntries;
        List list;
        DefaultMediaCrate clone = (DefaultMediaCrate)this.clone();
        clone.init();
        clone.setParent(null);
        List cloneCrates = clone.crates;
        if (cloneCrates != null) {
            list = this.crates;
            synchronized (list) {
                for (MediaCrate subCrate : this.crates) {
                    MediaCrate subClone = subCrate.cloneMediaCrate();
                    if (subClone instanceof AbstractMediaCrate) {
                        AbstractMediaCrate amc = (AbstractMediaCrate)subClone;
                        amc.setParent(clone);
                    }
                    cloneCrates.add(subClone);
                }
            }
        }
        if ((cloneEntries = clone.entries) != null) {
            list = this.entries;
            synchronized (list) {
                for (MediaCrateEntry mce : this.entries) {
                    cloneEntries.add(new DefaultMediaCrateEntry(clone, mce.getResource()));
                }
            }
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirty() {
        DefaultMediaCrate defaultMediaCrate = this;
        synchronized (defaultMediaCrate) {
            if (this.dirty) {
                return true;
            }
        }
        if (this.crates != null) {
            List list = this.crates;
            synchronized (list) {
                int num = this.crates.size();
                for (int i = 0; i < num; ++i) {
                    AbstractMediaCrate crate = (AbstractMediaCrate)this.crates.get(i);
                    if (!crate.isDirty()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDirty(boolean dirty) {
        DefaultMediaCrate defaultMediaCrate = this;
        synchronized (defaultMediaCrate) {
            this.dirty = dirty;
        }
        if (dirty) {
            return;
        }
        if (this.crates != null) {
            List list = this.crates;
            synchronized (list) {
                int num = this.crates.size();
                for (int i = 0; i < num; ++i) {
                    AbstractMediaCrate crate = (AbstractMediaCrate)this.crates.get(i);
                    crate.setDirty(false);
                }
            }
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

