/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultAudioEntry;
import com.spacekiller.util.media.DefaultPictureEntry;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaUtil;
import com.spacekiller.util.media.MutableAudioEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.MutablePictureEntry;
import com.spacekiller.util.media.PictureEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StreamCorruptedException;

public class DefaultMediaEntry
implements MutableMediaEntry,
Cloneable {
    private static final int VERSION_0 = 0;
    private static final int VERSION_1 = 1;
    private static final int VERSION_3 = 3;
    private static final int VERSION_4 = 4;
    private static final int VERSION_5 = 5;
    private static final int VERSION_6 = 6;
    private static final int VERSION_7 = 7;
    private static final int VERSION = 7;
    private static final int MAX_MARKER_COUNT = 1000;
    private transient Resource resource;
    private boolean existing;
    private long fileSize;
    private long lastModified;
    private long firstScanned;
    private long lastScanned;
    private int lastScannerChecksum;
    private long lastAnalyzed;
    private int lastAnalyzerChecksum;
    private String format;
    private String title;
    private String artist;
    private String album;
    private String albumArtist;
    private int albumTrack;
    private String genre;
    private String year;
    private double duration = -1.0;
    private double userRating = Double.NaN;
    private String userComment;
    private MediaMarker[] markers;
    private AudioEntry audioEntry;
    private PictureEntry pictureEntry;
    private int flags;

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Override
    public boolean isExisting() {
        return this.existing;
    }

    @Override
    public void setExisting(boolean existing) {
        this.existing = existing;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public long getFirstScanned() {
        return this.firstScanned;
    }

    @Override
    public void setFirstScanned(long firstScanned) {
        this.firstScanned = firstScanned;
    }

    @Override
    public long getLastScanned() {
        return this.lastScanned;
    }

    @Override
    public void setLastScanned(long lastScanned) {
        this.lastScanned = lastScanned;
    }

    @Override
    public int getLastScannerChecksum() {
        return this.lastScannerChecksum;
    }

    @Override
    public void setLastScannerChecksum(int lastScannerChecksum) {
        this.lastScannerChecksum = lastScannerChecksum;
    }

    @Override
    public long getLastAnalyzed() {
        return this.lastAnalyzed;
    }

    @Override
    public void setLastAnalyzed(long lastAnalyzed) {
        this.lastAnalyzed = lastAnalyzed;
    }

    @Override
    public int getLastAnalyzerChecksum() {
        return this.lastAnalyzerChecksum;
    }

    @Override
    public void setLastAnalyzerChecksum(int lastAnalyzerChecksum) {
        this.lastAnalyzerChecksum = lastAnalyzerChecksum;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getArtist() {
        return this.artist;
    }

    @Override
    public void setArtist(String artist) {
        this.artist = artist;
    }

    @Override
    public String getAlbum() {
        return this.album;
    }

    @Override
    public void setAlbum(String album) {
        this.album = album;
    }

    @Override
    public String getAlbumArtist() {
        return this.albumArtist;
    }

    @Override
    public void setAlbumArtist(String albumArtist) {
        this.albumArtist = albumArtist;
    }

    @Override
    public int getAlbumTrack() {
        return this.albumTrack;
    }

    @Override
    public void setAlbumTrack(int albumTrack) {
        this.albumTrack = albumTrack;
    }

    @Override
    public String getGenre() {
        return this.genre;
    }

    @Override
    public void setGenre(String genre) {
        this.genre = genre;
    }

    @Override
    public String getYear() {
        return this.year;
    }

    @Override
    public void setYear(String year) {
        this.year = year;
    }

    @Override
    public double getDuration() {
        return this.duration;
    }

    @Override
    public void setDuration(double duration) {
        this.duration = duration;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public double getUserRating() {
        return this.userRating;
    }

    @Override
    public void setUserRating(double userRating) {
        this.userRating = userRating;
    }

    @Override
    public String getUserComment() {
        return this.userComment;
    }

    @Override
    public void setUserComment(String userComment) {
        this.userComment = userComment;
    }

    @Override
    public MediaMarker[] getMarkers() {
        return this.markers;
    }

    @Override
    public void setMarkers(MediaMarker[] markers) {
        this.markers = markers;
    }

    @Override
    public AudioEntry getAudioEntry() {
        return this.audioEntry;
    }

    @Override
    public void setAudioEntry(AudioEntry audioEntry) {
        this.audioEntry = audioEntry;
    }

    @Override
    public PictureEntry getPictureEntry() {
        return this.pictureEntry;
    }

    @Override
    public void setPictureEntry(PictureEntry pictureEntry) {
        this.pictureEntry = pictureEntry;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public boolean isCorrupted() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isInfinite() {
        return (this.flags & 2) != 0;
    }

    @Override
    public void writeEntry(DataOutput out) throws IOException {
        this.writeEntry(out, this.resource);
    }

    @Override
    public void writeEntry(DataOutput out, Resource resource) throws IOException {
        PictureEntry pe;
        int markerCount;
        out.writeByte(7);
        MediaUtil.writeResource(resource, out);
        out.writeBoolean(this.existing);
        out.writeLong(this.fileSize);
        out.writeLong(this.lastModified);
        MediaUtil.writeString(this.format, out);
        MediaUtil.writeString(this.title, out);
        MediaUtil.writeString(this.artist, out);
        MediaUtil.writeString(this.album, out);
        MediaUtil.writeString(this.albumArtist, out);
        out.writeInt(this.albumTrack);
        MediaUtil.writeString(this.genre, out);
        MediaUtil.writeString(this.year, out);
        out.writeDouble(this.duration);
        MediaMarker[] markers = this.markers;
        int n = markerCount = markers == null ? 0 : markers.length;
        if (markerCount > 1000) {
            markerCount = 1000;
        }
        out.writeInt(markerCount);
        for (int i = 0; i < markerCount; ++i) {
            MediaMarker marker = markers[i];
            MediaUtil.writeMediaMarker(marker, out);
        }
        out.writeDouble(this.userRating);
        out.writeLong(this.firstScanned);
        out.writeLong(this.lastScanned);
        out.writeInt(this.lastScannerChecksum);
        out.writeLong(this.lastAnalyzed);
        out.writeInt(this.lastAnalyzerChecksum);
        MediaUtil.writeString(this.userComment, out);
        out.writeByte(this.flags);
        AudioEntry ae = this.audioEntry;
        if (ae != null) {
            if (ae.getClass() == DefaultAudioEntry.class) {
                DefaultAudioEntry dae = (DefaultAudioEntry)ae;
                out.writeInt(42);
                this.writeDefaultAudioEntry(dae, out);
            } else {
                throw new IOException("Unsupported audio entry type: " + ae.getClass());
            }
        }
        if ((pe = this.pictureEntry) != null) {
            if (pe.getClass() == DefaultPictureEntry.class) {
                DefaultPictureEntry dpe = (DefaultPictureEntry)pe;
                out.writeInt(47);
                this.writeDefaultPictureEntry(dpe, out);
            } else {
                throw new IOException("Unsupported picture entry type: " + pe.getClass());
            }
        }
        out.writeInt(0);
    }

    @Override
    public void readEntry(DataInput in, MediaContext context) throws IOException {
        byte version = in.readByte();
        if (version > 7 || version < 0) {
            throw new StreamCorruptedException("Unsupported version: " + version + " > " + 7);
        }
        this.resource = MediaUtil.readResource(in, context);
        this.existing = in.readBoolean();
        this.fileSize = in.readLong();
        this.lastModified = in.readLong();
        this.format = MediaUtil.readString(in);
        this.title = MediaUtil.readString(in);
        this.artist = MediaUtil.readString(in);
        this.album = MediaUtil.readString(in);
        this.albumArtist = MediaUtil.readString(in);
        this.albumTrack = in.readInt();
        this.genre = MediaUtil.readString(in);
        this.year = MediaUtil.readString(in);
        this.duration = in.readDouble();
        MediaMarker[] newMarkers = null;
        if (version >= 1) {
            int markerCount = in.readInt();
            if (markerCount < 0 || markerCount > 1000) {
                throw new StreamCorruptedException("Invalid number of markers: " + markerCount);
            }
            if (markerCount > 0) {
                newMarkers = new MediaMarker[markerCount];
                for (int i = 0; i < markerCount; ++i) {
                    newMarkers[i] = MediaUtil.readMediaMarker(in);
                }
            }
        }
        this.markers = newMarkers;
        double newUserRating = Double.NaN;
        if (version >= 3) {
            newUserRating = in.readDouble();
        }
        this.userRating = newUserRating;
        if (version >= 4) {
            this.firstScanned = in.readLong();
            this.lastScanned = in.readLong();
            this.lastScannerChecksum = in.readInt();
            this.lastAnalyzed = in.readLong();
            this.lastAnalyzerChecksum = in.readInt();
        }
        String newUserComment = null;
        if (version >= 6) {
            newUserComment = MediaUtil.readString(in);
        }
        this.userComment = newUserComment;
        int newFlags = 0;
        if (version >= 7) {
            newFlags = in.readByte() & 0xFF;
        }
        this.flags = newFlags;
        if (version < 5 && this.getClass() == DefaultMediaEntry.class) {
            this.audioEntry = this.readDefaultAudioEntry(in, context);
        }
        if (version >= 5) {
            int type;
            block5: while ((type = in.readInt()) != 0) {
                switch (type) {
                    case 42: {
                        this.audioEntry = this.readDefaultAudioEntry(in, context);
                        continue block5;
                    }
                    case 47: {
                        this.pictureEntry = this.readDefaultPictureEntry(in, context);
                        continue block5;
                    }
                }
                throw new StreamCorruptedException("Invalid entry sub-type: " + type);
            }
        }
    }

    protected DefaultAudioEntry readDefaultAudioEntry(DataInput in, MediaContext context) throws IOException {
        DefaultAudioEntry ae = new DefaultAudioEntry();
        ae.readEntry(in, context);
        return ae;
    }

    protected void writeDefaultAudioEntry(DefaultAudioEntry ae, DataOutput out) throws IOException {
        ae.writeEntry(out);
    }

    protected DefaultPictureEntry readDefaultPictureEntry(DataInput in, MediaContext context) throws IOException {
        DefaultPictureEntry pe = new DefaultPictureEntry();
        pe.readEntry(in, context);
        return pe;
    }

    protected void writeDefaultPictureEntry(DefaultPictureEntry pe, DataOutput out) throws IOException {
        pe.writeEntry(out);
    }

    @Override
    public MediaEntry cloneEntry() throws CloneNotSupportedException {
        int num;
        DefaultMediaEntry clone = (DefaultMediaEntry)this.clone();
        MediaMarker[] cloneMarkers = null;
        MediaMarker[] origMarkers = this.markers;
        if (origMarkers != null && (num = origMarkers.length) > 0) {
            cloneMarkers = new MediaMarker[num];
            for (int i = 0; i < num; ++i) {
                MediaMarker marker = origMarkers[i];
                if (marker == null) continue;
                cloneMarkers[i] = marker.cloneMarker();
            }
        }
        clone.markers = cloneMarkers;
        AudioEntry ae = this.audioEntry;
        if (ae != null) {
            ae = ae.cloneEntry();
        }
        clone.audioEntry = ae;
        PictureEntry pe = this.pictureEntry;
        if (pe != null) {
            pe = pe.cloneEntry();
        }
        clone.pictureEntry = pe;
        return clone;
    }

    @Override
    public boolean mergeEntry(MediaEntry me) {
        MediaMarker[] mm;
        PictureEntry pe;
        AudioEntry ae;
        double dValue;
        int iValue;
        if (me == null) {
            return false;
        }
        boolean merged = false;
        String s = this.mergeString(this.format, me.getFormat());
        if (!this.compareString(this.format, s)) {
            this.format = s;
            merged = true;
        }
        if (!this.compareString(this.title, s = this.mergeString(this.title, me.getTitle()))) {
            this.title = s;
            merged = true;
        }
        if (!this.compareString(this.artist, s = this.mergeString(this.artist, me.getArtist()))) {
            this.artist = s;
            merged = true;
        }
        if (!this.compareString(this.album, s = this.mergeString(this.album, me.getAlbum()))) {
            this.album = s;
            merged = true;
        }
        if (!this.compareString(this.albumArtist, s = this.mergeString(this.albumArtist, me.getAlbumArtist()))) {
            this.albumArtist = s;
            merged = true;
        }
        if (!this.compareString(this.genre, s = this.mergeString(this.genre, me.getGenre()))) {
            this.genre = s;
            merged = true;
        }
        if (!this.compareString(this.year, s = this.mergeString(this.year, me.getYear()))) {
            this.year = s;
            merged = true;
        }
        if (!this.compareString(this.userComment, s = this.mergeString(this.userComment, me.getUserComment()))) {
            this.userComment = s;
            merged = true;
        }
        if ((iValue = me.getAlbumTrack()) > 0 && iValue != this.albumTrack) {
            this.albumTrack = iValue;
            merged = true;
        }
        if ((dValue = me.getDuration()) >= 0.0 && dValue != this.duration) {
            this.duration = dValue;
            merged = true;
        }
        if (!Double.isNaN(dValue = me.getUserRating()) && dValue != this.userRating && (dValue != 0.0 || Double.isNaN(this.userRating))) {
            this.userRating = dValue;
            merged = true;
        }
        if (me.isCorrupted() && !this.isCorrupted()) {
            this.flags |= 1;
            merged = true;
        }
        if (me.isInfinite() && !this.isInfinite()) {
            this.flags |= 2;
            merged = true;
        }
        if ((ae = me.getAudioEntry()) != null) {
            AudioEntry old = this.audioEntry;
            if (old != null && old instanceof MutableAudioEntry) {
                MutableAudioEntry oae = (MutableAudioEntry)old;
                if (oae.mergeEntry(ae)) {
                    merged = true;
                }
            } else {
                try {
                    this.audioEntry = ae.cloneEntry();
                    merged = true;
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
            }
        }
        if ((pe = me.getPictureEntry()) != null) {
            PictureEntry old = this.pictureEntry;
            if (old != null && old instanceof MutablePictureEntry) {
                MutablePictureEntry ope = (MutablePictureEntry)old;
                if (ope.mergeEntry(pe)) {
                    merged = true;
                }
            } else {
                try {
                    this.pictureEntry = pe.cloneEntry();
                    merged = true;
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
            }
        }
        if ((mm = me.getMarkers()) == null || mm.length > 0) {
            // empty if block
        }
        return merged;
    }

    protected String mergeString(String a, String b) {
        if (b == null || b.length() < 1) {
            return a;
        }
        return b;
    }

    protected boolean compareString(String a, String b) {
        return a == null ? a == b : a.equals(b);
    }
}

