/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media;

import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MutablePictureEntry;
import com.spacekiller.util.media.PictureEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.StreamCorruptedException;

public class DefaultPictureEntry
implements MutablePictureEntry,
Cloneable {
    private static final int VERSION_0 = 0;
    private static final int VERSION_1 = 1;
    private static final int VERSION = 1;
    private int width = -1;
    private int height = -1;
    private int imageType = -1;
    private boolean hasAlpha;
    private int transparency = -1;
    private int pixelSize = -1;
    private int colorSpace = -1;

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getImageType() {
        return this.imageType;
    }

    @Override
    public void setImageType(int imageType) {
        this.imageType = imageType;
    }

    @Override
    public boolean isHasAlpha() {
        return this.hasAlpha;
    }

    @Override
    public void setHasAlpha(boolean hasAlpha) {
        this.hasAlpha = hasAlpha;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }

    @Override
    public void setTransparency(int transparency) {
        this.transparency = transparency;
    }

    @Override
    public int getPixelSize() {
        return this.pixelSize;
    }

    @Override
    public void setPixelSize(int pixelSize) {
        this.pixelSize = pixelSize;
    }

    @Override
    public int getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public void setColorSpace(int colorSpace) {
        this.colorSpace = colorSpace;
    }

    @Override
    public void writeEntry(DataOutput out) throws IOException {
        out.writeByte(1);
        out.writeInt(this.width);
        out.writeInt(this.height);
        out.writeInt(this.imageType);
        out.writeBoolean(this.hasAlpha);
        out.writeInt(this.transparency);
        out.writeInt(this.pixelSize);
        out.writeInt(this.colorSpace);
    }

    @Override
    public void readEntry(DataInput in, MediaContext context) throws IOException {
        byte version = in.readByte();
        if (version > 1 || version < 0) {
            throw new StreamCorruptedException("Unsupported version: " + version + " > " + 1);
        }
        this.width = in.readInt();
        this.height = in.readInt();
        if (version < 1) {
            return;
        }
        this.imageType = in.readInt();
        this.hasAlpha = in.readBoolean();
        this.transparency = in.readInt();
        this.pixelSize = in.readInt();
        this.colorSpace = in.readInt();
    }

    @Override
    public PictureEntry cloneEntry() throws CloneNotSupportedException {
        DefaultPictureEntry clone = (DefaultPictureEntry)this.clone();
        return clone;
    }

    @Override
    public boolean mergeEntry(PictureEntry entry) {
        if (entry == null) {
            return false;
        }
        boolean merged = false;
        int iValue = entry.getWidth();
        if (iValue >= 0 && iValue != this.width) {
            this.width = iValue;
            merged = true;
        }
        if ((iValue = entry.getHeight()) >= 0 && iValue != this.height) {
            this.height = iValue;
            merged = true;
        }
        if ((iValue = entry.getImageType()) >= 0 && iValue != this.imageType) {
            this.imageType = iValue;
            merged = true;
        }
        if (entry.isHasAlpha() != this.hasAlpha) {
            this.hasAlpha = entry.isHasAlpha();
            merged = true;
        }
        if ((iValue = entry.getTransparency()) >= 0 && iValue != this.transparency) {
            this.transparency = iValue;
            merged = true;
        }
        if ((iValue = entry.getPixelSize()) >= 0 && iValue != this.pixelSize) {
            this.pixelSize = iValue;
            merged = true;
        }
        if ((iValue = entry.getColorSpace()) >= 0 && iValue != this.colorSpace) {
            this.colorSpace = iValue;
            merged = true;
        }
        return merged;
    }
}

