/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media;

import com.spacekiller.util.media.AbstractMediaCrate;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaCrateEntry;
import com.spacekiller.util.media.MediaLibrary;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DirectoryMediaCrate
extends AbstractMediaCrate {
    private final String path;
    private final boolean recursive;
    private transient List crates;
    private transient List entries;
    private transient Thread crateInitThread;
    private transient Thread entryInitThread;

    public DirectoryMediaCrate(String id, String name, String path, boolean recursive) {
        super(id, name);
        this.path = path;
        this.recursive = recursive;
    }

    public DirectoryMediaCrate(AbstractMediaCrate parent, String id, String name, String path, boolean recursive) {
        this(id, name, path, recursive);
        this.setParent(parent);
    }

    @Override
    protected void setId(String id) {
        super.setId(id);
    }

    @Override
    public void getEntries(Collection dst) {
        this.lazyInitEntries(dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEntryCount() {
        this.lazyInitEntries(null);
        List list = this.entries;
        synchronized (list) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaCrateEntry getEntryAt(int index) {
        this.lazyInitEntries(null);
        List list = this.entries;
        synchronized (list) {
            return (MediaCrateEntry)this.entries.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEntryIndex(MediaCrateEntry entry) {
        this.lazyInitEntries(null);
        List list = this.entries;
        synchronized (list) {
            return this.entries.indexOf(entry);
        }
    }

    @Override
    public void getCrates(Collection dst) {
        this.lazyInitCrates(dst);
    }

    @Override
    public boolean isLeafCrate() {
        return this.getCrateCount() < 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCrateCount() {
        this.lazyInitCrates(null);
        List list = this.crates;
        synchronized (list) {
            return this.crates.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaCrate getCrateAt(int index) {
        this.lazyInitCrates(null);
        List list = this.crates;
        synchronized (list) {
            return (MediaCrate)this.crates.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCrateIndex(MediaCrate crate) {
        this.lazyInitCrates(null);
        List list = this.crates;
        synchronized (list) {
            return this.crates.indexOf(crate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInitCrates(Collection dst) {
        if (this.crates != null) {
            if (dst != null) {
                List list = this.crates;
                synchronized (list) {
                    dst.addAll(this.crates);
                }
            }
            return;
        }
        Thread thread = Thread.currentThread();
        DirectoryMediaCrate directoryMediaCrate = this;
        synchronized (directoryMediaCrate) {
            if (this.crates != null) {
                if (dst != null) {
                    List list = this.crates;
                    synchronized (list) {
                        dst.addAll(this.crates);
                    }
                }
                return;
            }
            if (thread == this.crateInitThread) {
                throw new IllegalStateException("Recursive invocation !");
            }
            while (this.crateInitThread != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.crates != null) {
                if (dst != null) {
                    List e = this.crates;
                    synchronized (e) {
                        dst.addAll(this.crates);
                    }
                }
                return;
            }
            this.crateInitThread = thread;
        }
        ArrayList listCrates = new ArrayList();
        try {
            MediaContext context;
            MediaLibrary library;
            if (this.recursive && (library = this.getLibrary()) != null && (context = library.getContext()) != null) {
                context.enumerateDirectoryMediaCrates(this, listCrates);
                if (dst != null) {
                    dst.addAll(listCrates);
                }
            }
        }
        finally {
            DirectoryMediaCrate directoryMediaCrate2 = this;
            synchronized (directoryMediaCrate2) {
                this.crates = listCrates;
                this.crateInitThread = null;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lazyInitEntries(Collection dst) {
        if (this.entries != null) {
            if (dst != null) {
                List list = this.entries;
                synchronized (list) {
                    dst.addAll(this.entries);
                }
            }
            return;
        }
        Thread thread = Thread.currentThread();
        DirectoryMediaCrate directoryMediaCrate = this;
        synchronized (directoryMediaCrate) {
            if (this.entries != null) {
                if (dst != null) {
                    List list = this.entries;
                    synchronized (list) {
                        dst.addAll(this.entries);
                    }
                }
                return;
            }
            if (thread == this.entryInitThread) {
                throw new IllegalStateException("Recursive invocation !");
            }
            while (this.entryInitThread != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.entries != null) {
                if (dst != null) {
                    List e = this.entries;
                    synchronized (e) {
                        dst.addAll(this.entries);
                    }
                }
                return;
            }
            this.entryInitThread = thread;
        }
        ArrayList listEntries = new ArrayList();
        try {
            MediaContext context;
            MediaLibrary library = this.getLibrary();
            if (library != null && (context = library.getContext()) != null) {
                context.enumerateDirectoryMediaCrateEntries(this, listEntries);
                if (dst != null) {
                    dst.addAll(listEntries);
                }
            }
        }
        finally {
            DirectoryMediaCrate directoryMediaCrate2 = this;
            synchronized (directoryMediaCrate2) {
                this.entries = listEntries;
                this.entryInitThread = null;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        DirectoryMediaCrate directoryMediaCrate = this;
        synchronized (directoryMediaCrate) {
            this.crates = null;
            this.entries = null;
            this.fireStructureChanged(this);
        }
    }

    @Override
    public void loadAll() {
    }

    @Override
    public String toString() {
        return String.valueOf(this.path);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setDirty(true);
    }

    @Override
    public void setDescription(String description) {
        super.setDescription(description);
        this.setDirty(true);
    }

    @Override
    public MediaCrate cloneMediaCrate() throws CloneNotSupportedException {
        DirectoryMediaCrate clone = (DirectoryMediaCrate)this.clone();
        clone.setParent(null);
        clone.crates = null;
        clone.entries = null;
        clone.crateInitThread = null;
        clone.entryInitThread = null;
        return clone;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
    }
}

