/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media;

import com.spacekiller.util.FileResource;
import com.spacekiller.util.Resource;
import com.spacekiller.util.URIResource;
import com.spacekiller.util.URLResource;
import com.spacekiller.util.media.DefaultMediaMarker;
import com.spacekiller.util.media.MediaConst;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaEndpoint;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaResource;
import com.spacekiller.util.media.ZOldMuellerObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;

public class MediaUtil
implements MediaConst {
    public static final int NULL = 0;
    public static final int STRING = 7;
    public static final int FILE = 11;
    public static final int URL = 17;
    public static final int URI = 21;
    public static final int MEDIA = 32;
    private static final int ENDPOINT_VERSION_0 = 0;
    private static final int ENDPOINT_VERSION = 0;
    private static final int AUDIOFORMAT_VERSION_0 = 0;
    private static final int AUDIOFORMAT_VERSION = 0;
    private static final Map encodingMap = new HashMap();

    private MediaUtil() {
    }

    public static void writeString(String s, DataOutput out) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else {
            out.writeByte(7);
            out.writeUTF(s);
        }
    }

    public static String readString(DataInput in) throws IOException {
        byte x = in.readByte();
        switch (x) {
            case 0: {
                return null;
            }
            case 7: {
                return in.readUTF();
            }
        }
        throw new StreamCorruptedException("Invalid string prefix: " + x);
    }

    public static void writeResource(Resource r, DataOutput out) throws IOException {
        if (r == null) {
            out.writeByte(0);
            return;
        }
        String s = r.toString();
        if (s == null) {
            out.writeByte(0);
            return;
        }
        if (r instanceof FileResource) {
            out.writeByte(11);
            out.writeUTF(s);
            return;
        }
        if (r instanceof URLResource) {
            out.writeByte(17);
            out.writeUTF(s);
            return;
        }
        if (r instanceof URIResource) {
            out.writeByte(21);
            out.writeUTF(s);
            return;
        }
        if (r instanceof MediaResource) {
            String libraryId;
            MediaResource mr = (MediaResource)r;
            MediaLibrary library = mr.getLibrary();
            String string = libraryId = library == null ? null : library.getId();
            if (libraryId == null) {
                libraryId = "";
            }
            out.writeByte(32);
            out.writeUTF(libraryId);
            out.writeUTF(s);
            return;
        }
        throw new IllegalArgumentException("Unsupported resource type: " + r.getClass());
    }

    public static Resource readResource(DataInput in, MediaContext context) throws IOException {
        byte kind = in.readByte();
        switch (kind) {
            case 0: {
                return null;
            }
            case 11: {
                String path = in.readUTF();
                return new FileResource(new File(path));
            }
            case 17: {
                String url = in.readUTF();
                return new URLResource(new URL(url));
            }
            case 21: {
                String uri = in.readUTF();
                try {
                    return new URIResource(new URI(uri));
                }
                catch (URISyntaxException e) {
                    throw new IOException("URISyntaxException: " + e);
                }
            }
            case 32: {
                String libraryId = in.readUTF();
                String path = in.readUTF();
                MediaLibrary library = context.getMediaLibrary(libraryId);
                if (library != null) {
                    return new MediaResource(library, path);
                }
                throw new IOException("MediaLibrary not found: id=" + libraryId);
            }
        }
        throw new StreamCorruptedException("Unsupported resource type: " + kind);
    }

    public static void writeMediaMarker(MediaMarker marker, DataOutput out) throws IOException {
        int markerIndex = -1;
        double markerPos = 0.0;
        String markerName = null;
        int markerType = 0;
        if (marker != null) {
            markerIndex = marker.getIndex();
            markerPos = marker.getPosition();
            markerName = marker.getName();
            markerType = marker.getType();
        }
        out.writeInt(markerType);
        out.writeInt(markerIndex);
        out.writeDouble(markerPos);
        MediaUtil.writeString(markerName, out);
    }

    public static MediaMarker readMediaMarker(DataInput in) throws IOException {
        int markerType = in.readInt();
        int markerIndex = in.readInt();
        double markerPos = in.readDouble();
        String markerName = MediaUtil.readString(in);
        return new DefaultMediaMarker(markerType, markerIndex, markerPos, markerName);
    }

    public static void writeEndpoint(MediaEndpoint endpoint, DataOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(endpoint);
        oos.flush();
        byte[] data = baos.toByteArray();
        oos.close();
        out.writeInt(0);
        out.writeInt(data.length);
        out.write(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaEndpoint readEndpoint(DataInput in) throws IOException, ClassNotFoundException {
        int ver = in.readInt();
        if (ver < 0 || ver > 0) {
            throw new StreamCorruptedException("Unsupported endpoint version: " + ver + " (current=" + 0 + ")");
        }
        int len = in.readInt();
        byte[] data = new byte[len];
        in.readFully(data);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ZOldMuellerObjectInputStream ois = new ZOldMuellerObjectInputStream(bais);
        try {
            Object obj = ois.readObject();
            if (obj != null && obj instanceof MediaEndpoint) {
                MediaEndpoint mediaEndpoint = (MediaEndpoint)obj;
                return mediaEndpoint;
            }
            MediaEndpoint mediaEndpoint = null;
            return mediaEndpoint;
        }
        finally {
            ois.close();
        }
    }

    public static void writeAudioFormat(AudioFormat format, DataOutput out) throws IOException {
        out.writeInt(0);
        out.writeInt(format.getChannels());
        out.writeInt(format.getSampleSizeInBits());
        out.writeInt(format.getFrameSize());
        out.writeFloat(format.getSampleRate());
        out.writeBoolean(format.isBigEndian());
        AudioFormat.Encoding encoding = format.getEncoding();
        out.writeUTF(String.valueOf(encoding));
    }

    public static AudioFormat readAudioFormat(DataInput in) throws IOException {
        AudioFormat.Encoding encoding;
        int ver = in.readInt();
        if (ver < 0 || ver > 0) {
            throw new StreamCorruptedException("Unsupported audio format version: " + ver + " (current=" + 0 + ")");
        }
        int channels = in.readInt();
        int bitDepth = in.readInt();
        int frameSize = in.readInt();
        float sampleRate = in.readFloat();
        boolean bigEndian = in.readBoolean();
        String encodingName = in.readUTF();
        if ("null".equals(encodingName)) {
            encoding = null;
        } else {
            encoding = MediaUtil.getEncoding(encodingName);
            if (encoding == null) {
                throw new IOException("Unknown audio encoding: " + encodingName);
            }
        }
        float frameRate = sampleRate;
        return new AudioFormat(encoding, sampleRate, bitDepth, channels, frameSize, frameRate, bigEndian);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AudioFormat.Encoding getEncoding(String name) {
        Map map = encodingMap;
        synchronized (map) {
            return (AudioFormat.Encoding)encodingMap.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean registerEncoding(String name, AudioFormat.Encoding encoding) {
        if (name == null || encoding == null) {
            return false;
        }
        Map map = encodingMap;
        synchronized (map) {
            if (encodingMap.containsKey(name)) {
                return false;
            }
            encodingMap.put(name, encoding);
            return true;
        }
    }

    protected static void registerDefaultEncodings() {
        MediaUtil.registerEncoding("PCM_SIGNED", AudioFormat.Encoding.PCM_SIGNED);
        MediaUtil.registerEncoding("PCM_UNSIGNED", AudioFormat.Encoding.PCM_UNSIGNED);
        MediaUtil.registerEncoding("ALAW", AudioFormat.Encoding.ALAW);
        MediaUtil.registerEncoding("ULAW", AudioFormat.Encoding.ULAW);
    }

    static {
        MediaUtil.registerDefaultEncodings();
    }
}

