/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.plugin;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Plugin;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.heap.DefaultHeapManager;
import com.spacekiller.util.heap.DefaultHeapOptimizer;
import com.spacekiller.util.heap.HeapManager;
import com.spacekiller.util.heap.HeapOptimizer;
import com.spacekiller.util.lock.LockFactory;
import com.spacekiller.util.lock.LockManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeapManagerPlugin
extends Plugin {
    private static final Logger logger = Logger.getLogger(HeapManagerPlugin.class.getName());
    public static final String HEAP_MANAGER_PLUGIN_ID = "com.spacekiller.util.heap.plugin";
    private HeapManager heapManager;

    public static HeapManagerPlugin getInstance() throws Exception {
        return (HeapManagerPlugin)Platform.getInstance().getPlugin(HEAP_MANAGER_PLUGIN_ID);
    }

    protected void startup() {
        super.startup();
    }

    protected void shutdown() {
        super.shutdown();
        this.setHeapManager(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeapManager getHeapManager() {
        if (this.heapManager == null) {
            HeapManagerPlugin heapManagerPlugin = this;
            synchronized (heapManagerPlugin) {
                if (this.heapManager == null) {
                    this.setHeapManager(this.createHeapManager());
                }
            }
        }
        return this.heapManager;
    }

    protected synchronized void setHeapManager(HeapManager heapManager) {
        this.heapManager = heapManager;
    }

    protected HeapManager createHeapManager() {
        boolean fair = false;
        boolean useJna = false;
        boolean unsafe = false;
        try {
            PreferencesRegistry registry = Platform.getInstance().getPreferencesRegistry();
            Preferences prefs = registry.getPreferences("heap-manager");
            if (prefs != null) {
                if (prefs.contains("fairLocking")) {
                    fair = prefs.getBoolean("fairLocking");
                }
                if (prefs.contains("useJnaMemory")) {
                    useJna = prefs.getBoolean("useJnaMemory");
                }
                if (prefs.contains("unsafeMemory")) {
                    unsafe = prefs.getBoolean("unsafeMemory");
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        DefaultHeapOptimizer heapOptimizer = null;
        heapOptimizer = new DefaultHeapOptimizer();
        LockFactory lockFactory = LockManager.getInstance().createLockFactory();
        DefaultHeapManager manager = new DefaultHeapManager((HeapOptimizer)heapOptimizer, lockFactory, fair, useJna, unsafe);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Created heap manager: unsafe=" + unsafe + ", fair=" + fair + ", lockFactory=" + lockFactory);
        }
        return manager;
    }
}

