/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.plugin;

import com.spacekiller.util.Platform;
import com.spacekiller.util.Preferences;
import com.spacekiller.util.PreferencesRegistry;
import com.spacekiller.util.heap.plugin.HeapManagerPreferencesPanel;
import com.spacekiller.util.workbench.AbstractPreferencesPage;
import com.spacekiller.util.workbench.View;
import java.awt.Component;

public class HeapManagerPreferencesPage
extends AbstractPreferencesPage {
    public static final String PREFERENCES_HEAP_MANAGER = "heap-manager";
    public static final String PROPERTY_FAIR_LOCKING = "fairLocking";
    public static final String PROPERTY_JNA_MEMORY = "useJnaMemory";
    public static final String PROPERTY_UNSAFE_MEMORY = "unsafeMemory";
    private PreferencesRegistry registry;
    private HeapManagerPreferencesPanel heapManagerPreferencesPanel;

    protected HeapManagerPreferencesPanel createHeapManagerPreferencesPanel() {
        return new HeapManagerPreferencesPanel();
    }

    public HeapManagerPreferencesPanel getHeapManagerPreferencesPanel() {
        if (this.heapManagerPreferencesPanel == null) {
            this.setHeapManagerPreferencesPanel(this.createHeapManagerPreferencesPanel());
        }
        return this.heapManagerPreferencesPanel;
    }

    public void setHeapManagerPreferencesPanel(HeapManagerPreferencesPanel mediaManagerPreferencesPanel) {
        this.heapManagerPreferencesPanel = mediaManagerPreferencesPanel;
    }

    public Component createComponent() {
        return this.getHeapManagerPreferencesPanel();
    }

    public void refreshPreferences(View view) throws Exception {
        HeapManagerPreferencesPanel panel = this.getHeapManagerPreferencesPanel();
        boolean useFairLocking = false;
        boolean useJnaMemory = false;
        boolean useUnsafeMemory = false;
        Preferences prefs = this.getPreferences();
        if (prefs != null) {
            if (prefs.contains(PROPERTY_FAIR_LOCKING)) {
                useFairLocking = prefs.getBoolean(PROPERTY_FAIR_LOCKING);
            }
            if (prefs.contains(PROPERTY_JNA_MEMORY)) {
                useJnaMemory = prefs.getBoolean(PROPERTY_JNA_MEMORY);
            }
            if (prefs.contains(PROPERTY_UNSAFE_MEMORY)) {
                useUnsafeMemory = prefs.getBoolean(PROPERTY_UNSAFE_MEMORY);
            }
        }
        panel.setUseFairLocking(useFairLocking);
        panel.setUseJnaMemory(useJnaMemory);
        panel.setUseUnsafeMemory(useUnsafeMemory);
    }

    public void resetPreferences(View view) throws Exception {
        this.refreshPreferences(view);
    }

    public void savePreferences(View view) throws Exception {
        Preferences prefs = this.getPreferences();
        if (prefs == null) {
            this.getRegistry().removePreferences(PREFERENCES_HEAP_MANAGER);
            prefs = this.getRegistry().createPreferences(PREFERENCES_HEAP_MANAGER);
        }
        boolean fairLocking = this.getHeapManagerPreferencesPanel().isUseFairLocking();
        prefs.setBoolean(PROPERTY_FAIR_LOCKING, fairLocking);
        boolean useJnaMemory = this.getHeapManagerPreferencesPanel().isUseJnaMemory();
        prefs.setBoolean(PROPERTY_JNA_MEMORY, useJnaMemory);
        boolean unsafeMemory = this.getHeapManagerPreferencesPanel().isUseUnsafeMemory();
        prefs.setBoolean(PROPERTY_UNSAFE_MEMORY, unsafeMemory);
        this.getRegistry().savePreferences(prefs);
    }

    protected PreferencesRegistry createRegistry() {
        return Platform.getInstance().getPreferencesRegistry();
    }

    protected PreferencesRegistry getRegistry() {
        if (this.registry == null) {
            this.setRegistry(this.createRegistry());
        }
        return this.registry;
    }

    protected void setRegistry(PreferencesRegistry registry) {
        this.registry = registry;
    }

    protected Preferences getPreferences() throws Exception {
        return this.getRegistry().getPreferences(PREFERENCES_HEAP_MANAGER);
    }
}

