/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.plugin;

import com.spacekiller.util.heap.AreaInfo;
import com.spacekiller.util.heap.HeapInfo;
import com.spacekiller.util.heap.HeapSummary;

public class JavaHeapInfo
implements HeapInfo {
    private static JavaHeapInfo INSTANCE = null;
    private String name;
    private Runtime runtime;

    public JavaHeapInfo() {
        this("Java-Heap", Runtime.getRuntime());
    }

    public JavaHeapInfo(String name, Runtime runtime) {
        this.name = name;
        this.runtime = runtime;
        if (runtime == null) {
            throw new NullPointerException("runtime is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final JavaHeapInfo getInstance() {
        JavaHeapInfo instance = INSTANCE;
        if (instance != null) return instance;
        Class<JavaHeapInfo> clazz = JavaHeapInfo.class;
        synchronized (JavaHeapInfo.class) {
            instance = INSTANCE;
            if (instance != null) return instance;
            INSTANCE = instance = new JavaHeapInfo();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }

    public String getName() {
        return this.name;
    }

    public long size() {
        return this.runtime.totalMemory();
    }

    public long limit() {
        return this.runtime.maxMemory();
    }

    public long free() {
        return this.runtime.freeMemory();
    }

    public AreaInfo[] getAreaInfo() {
        return null;
    }

    public HeapSummary getHeapSummary(HeapSummary summary) {
        long limit = this.limit();
        long size = this.size();
        long free = this.free();
        if (summary == null) {
            summary = new HeapSummary();
        }
        summary.limit = limit;
        summary.size = size;
        summary.free = free;
        return summary;
    }
}

