/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.view;

import com.spacekiller.util.heap.AreaConfig;
import com.spacekiller.util.heap.DefaultAreaConfig;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DefaultAreaConfigPanel
extends JPanel {
    private static final long serialVersionUID = 2427248341404638703L;
    private static final long MB = 0x100000L;
    private AreaConfig areaConfig;
    private boolean refreshing;
    private JTextField textFieldMaxSize;
    private JTextField textFieldMaxFree;
    private JTextField textFieldMinFree;
    private JLabel lblMaxSize;
    private JLabel lblMinFree;
    private JLabel lblMaxFree;

    public DefaultAreaConfigPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.lblMaxSize = new JLabel("Limit MB:");
        this.lblMaxSize.setToolTipText("Maximum area size in MB");
        GridBagConstraints gbc_lblMaxSize = new GridBagConstraints();
        gbc_lblMaxSize.insets = new Insets(0, 0, 0, 5);
        gbc_lblMaxSize.anchor = 13;
        gbc_lblMaxSize.gridx = 0;
        gbc_lblMaxSize.gridy = 0;
        this.add((Component)this.lblMaxSize, gbc_lblMaxSize);
        this.textFieldMaxSize = new JTextField();
        this.textFieldMaxSize.setToolTipText("Maximum area size in MB");
        GridBagConstraints gbc_textFieldMaxSize = new GridBagConstraints();
        gbc_textFieldMaxSize.weightx = 1.0;
        gbc_textFieldMaxSize.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldMaxSize.fill = 2;
        gbc_textFieldMaxSize.gridx = 1;
        gbc_textFieldMaxSize.gridy = 0;
        this.add((Component)this.textFieldMaxSize, gbc_textFieldMaxSize);
        this.textFieldMaxSize.setColumns(6);
        this.lblMinFree = new JLabel("Min. Free: %");
        this.lblMinFree.setToolTipText("Minimum free space in percent");
        GridBagConstraints gbc_lblMinFree = new GridBagConstraints();
        gbc_lblMinFree.anchor = 13;
        gbc_lblMinFree.insets = new Insets(0, 0, 0, 5);
        gbc_lblMinFree.gridx = 2;
        gbc_lblMinFree.gridy = 0;
        this.add((Component)this.lblMinFree, gbc_lblMinFree);
        this.textFieldMinFree = new JTextField();
        this.textFieldMinFree.setToolTipText("Minimum free space in percent");
        GridBagConstraints gbc_textFieldMinFree = new GridBagConstraints();
        gbc_textFieldMinFree.insets = new Insets(0, 0, 0, 5);
        gbc_textFieldMinFree.fill = 2;
        gbc_textFieldMinFree.gridx = 3;
        gbc_textFieldMinFree.gridy = 0;
        this.add((Component)this.textFieldMinFree, gbc_textFieldMinFree);
        this.textFieldMinFree.setColumns(4);
        this.lblMaxFree = new JLabel("Max. Free: %");
        this.lblMaxFree.setToolTipText("Maximum free space in percent");
        GridBagConstraints gbc_lblMaxFree = new GridBagConstraints();
        gbc_lblMaxFree.insets = new Insets(0, 0, 0, 5);
        gbc_lblMaxFree.anchor = 13;
        gbc_lblMaxFree.gridx = 4;
        gbc_lblMaxFree.gridy = 0;
        this.add((Component)this.lblMaxFree, gbc_lblMaxFree);
        this.textFieldMaxFree = new JTextField();
        this.textFieldMaxFree.setToolTipText("Maximum free space in percent");
        GridBagConstraints gbc_textFieldMaxFree = new GridBagConstraints();
        gbc_textFieldMaxFree.fill = 2;
        gbc_textFieldMaxFree.gridx = 5;
        gbc_textFieldMaxFree.gridy = 0;
        this.add((Component)this.textFieldMaxFree, gbc_textFieldMaxFree);
        this.textFieldMaxFree.setColumns(4);
        this.initDefaultAreaConfigPanel();
    }

    protected void initDefaultAreaConfigPanel() {
        DocumentListener docHandler = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!DefaultAreaConfigPanel.this.refreshing) {
                    DefaultAreaConfigPanel.this.apply();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!DefaultAreaConfigPanel.this.refreshing) {
                    DefaultAreaConfigPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!DefaultAreaConfigPanel.this.refreshing) {
                    DefaultAreaConfigPanel.this.apply();
                }
            }
        };
        this.textFieldMaxSize.getDocument().addDocumentListener(docHandler);
        this.textFieldMinFree.getDocument().addDocumentListener(docHandler);
        this.textFieldMaxFree.getDocument().addDocumentListener(docHandler);
    }

    protected JTextField getTextFieldMaxSize() {
        return this.textFieldMaxSize;
    }

    protected JTextField getTextFieldMinFree() {
        return this.textFieldMinFree;
    }

    protected JTextField getTextFieldMaxFree() {
        return this.textFieldMaxFree;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textFieldMaxSize.setEnabled(enabled);
        this.textFieldMinFree.setEnabled(enabled);
        this.textFieldMaxFree.setEnabled(enabled);
        this.lblMaxSize.setEnabled(enabled);
        this.lblMinFree.setEnabled(enabled);
        this.lblMaxFree.setEnabled(enabled);
    }

    public AreaConfig getAreaConfig() {
        return this.areaConfig;
    }

    public void setAreaConfig(AreaConfig areaConfig) {
        this.areaConfig = areaConfig;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            this.refreshing = true;
            long maxAreaSize = -1L;
            double minFreeFactor = -1.0;
            double maxFreeFactor = -1.0;
            AreaConfig config = this.getAreaConfig();
            if (config != null) {
                maxAreaSize = config.getMaxAreaSize();
                minFreeFactor = config.getMinFreeFactor();
                maxFreeFactor = config.getMaxFreeFactor();
            }
            this.textFieldMaxSize.setText(maxAreaSize < 0L ? "" : String.valueOf(maxAreaSize / 0x100000L));
            this.textFieldMinFree.setText(minFreeFactor < 0.0 ? "" : String.valueOf(minFreeFactor * 100.0));
            this.textFieldMaxFree.setText(maxFreeFactor < 0.0 ? "" : String.valueOf(maxFreeFactor * 100.0));
        }
        finally {
            this.refreshing = false;
        }
    }

    protected synchronized void apply() {
        String text;
        DefaultAreaConfig config = null;
        AreaConfig hc = this.getAreaConfig();
        if (hc != null && hc instanceof DefaultAreaConfig) {
            config = (DefaultAreaConfig)hc;
        }
        if (config == null) {
            return;
        }
        try {
            long maxAreaSize = -1L;
            text = this.textFieldMaxSize.getText().trim();
            if (text.length() > 0 && (maxAreaSize = Long.parseLong(text)) > 0L) {
                maxAreaSize *= 0x100000L;
            }
            config.setMaxAreaSize(maxAreaSize);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            double minFreeFactor = -1.0;
            text = this.textFieldMinFree.getText().trim();
            if (text.length() > 0 && (minFreeFactor = Double.parseDouble(text)) > 0.0) {
                minFreeFactor /= 100.0;
            }
            config.setMinFreeFactor(minFreeFactor);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            double maxFreeFactor = -1.0;
            text = this.textFieldMaxFree.getText().trim();
            if (text.length() > 0 && (maxFreeFactor = Double.parseDouble(text)) > 0.0) {
                maxFreeFactor /= 100.0;
            }
            config.setMaxFreeFactor(maxFreeFactor);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected JLabel getLblMaxSize() {
        return this.lblMaxSize;
    }

    protected JLabel getLblMinFree() {
        return this.lblMinFree;
    }

    protected JLabel getLblMaxFree() {
        return this.lblMaxFree;
    }
}

