/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.view;

import com.spacekiller.util.heap.HeapInfo;
import com.spacekiller.util.heap.HeapManager;
import com.spacekiller.util.heap.plugin.JavaHeapInfo;
import com.spacekiller.util.heap.view.HeapInfoPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HeapManagerPanel
extends JPanel {
    private static final long serialVersionUID = 6806474143090562699L;
    private final HeapManagerChangeHandler heapManagerChangeHandler = new HeapManagerChangeHandler();
    private final RefreshLater refreshLater = new RefreshLater();
    private HeapManager heapManager;
    private boolean includeJavaHeapInfo = true;
    private DefaultListModel heapInfoListModel;
    private boolean refreshing = false;
    private JList listHeaps;
    private HeapInfoPanel heapInfoPanel;

    public HeapManagerPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JPanel panelHeaps = new JPanel();
        panelHeaps.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Heaps", 4, 2, null, null));
        GridBagConstraints gbc_panelHeaps = new GridBagConstraints();
        gbc_panelHeaps.weightx = 1.0;
        gbc_panelHeaps.insets = new Insets(4, 4, 4, 5);
        gbc_panelHeaps.fill = 1;
        gbc_panelHeaps.gridx = 0;
        gbc_panelHeaps.gridy = 0;
        this.add((Component)panelHeaps, gbc_panelHeaps);
        GridBagLayout gbl_panelHeaps = new GridBagLayout();
        gbl_panelHeaps.columnWidths = new int[]{0, 0};
        gbl_panelHeaps.rowHeights = new int[]{0, 0};
        gbl_panelHeaps.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelHeaps.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelHeaps.setLayout(gbl_panelHeaps);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.insets = new Insets(4, 4, 4, 4);
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        panelHeaps.add((Component)scrollPane, gbc_scrollPane);
        this.listHeaps = new JList();
        this.listHeaps.setSelectionMode(0);
        this.listHeaps.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (HeapManagerPanel.this.refreshing) {
                    return;
                }
                HeapManagerPanel.this.refreshHeapDetails();
            }
        });
        scrollPane.setViewportView(this.listHeaps);
        JPanel panelDetails = new JPanel();
        GridBagConstraints gbc_panelDetails = new GridBagConstraints();
        gbc_panelDetails.weighty = 1.0;
        gbc_panelDetails.weightx = 1.0;
        gbc_panelDetails.fill = 1;
        gbc_panelDetails.gridx = 1;
        gbc_panelDetails.gridy = 0;
        this.add((Component)panelDetails, gbc_panelDetails);
        GridBagLayout gbl_panelDetails = new GridBagLayout();
        gbl_panelDetails.columnWidths = new int[]{0, 0};
        gbl_panelDetails.rowHeights = new int[]{0, 0};
        gbl_panelDetails.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panelDetails.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelDetails.setLayout(gbl_panelDetails);
        this.heapInfoPanel = new HeapInfoPanel();
        GridBagConstraints gbc_heapInfoPanel_1 = new GridBagConstraints();
        gbc_heapInfoPanel_1.weighty = 1.0;
        gbc_heapInfoPanel_1.weightx = 1.0;
        gbc_heapInfoPanel_1.fill = 1;
        gbc_heapInfoPanel_1.gridx = 0;
        gbc_heapInfoPanel_1.gridy = 0;
        panelDetails.add((Component)this.heapInfoPanel, gbc_heapInfoPanel_1);
        this.initMemoryMonitorPanel();
    }

    protected void initMemoryMonitorPanel() {
        this.heapInfoListModel = new DefaultListModel();
        this.getListHeaps().setModel(this.heapInfoListModel);
        this.getListHeaps().setCellRenderer(new HeapInfoListCellRenderer());
        this.refresh();
    }

    private HeapManager getHeapManager() {
        return this.heapManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeapManager(HeapManager heapManager) {
        HeapManagerPanel heapManagerPanel = this;
        synchronized (heapManagerPanel) {
            HeapManager oldManager = this.heapManager;
            if (heapManager == oldManager) {
                return;
            }
            this.heapManager = heapManager;
            if (oldManager != null) {
                oldManager.removeChangeListener((ChangeListener)this.heapManagerChangeHandler);
            }
            if (heapManager != null) {
                heapManager.addChangeListener((ChangeListener)this.heapManagerChangeHandler);
            }
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            JavaHeapInfo javaHeapInfo;
            this.refreshing = true;
            HeapInfo[] heapInfos = null;
            HeapManager heapManager = this.getHeapManager();
            if (heapManager != null) {
                heapInfos = heapManager.getHeapInfo();
            }
            int sel = this.getListHeaps().getSelectedIndex();
            this.heapInfoListModel.removeAllElements();
            if (this.includeJavaHeapInfo && (javaHeapInfo = JavaHeapInfo.getInstance()) != null) {
                this.heapInfoListModel.addElement(javaHeapInfo);
            }
            if (heapInfos != null) {
                for (HeapInfo heapInfo : heapInfos) {
                    if (heapInfo == null) continue;
                    this.heapInfoListModel.addElement(heapInfo);
                }
            }
            if (sel < 0) {
                sel = 0;
            }
            if (sel >= this.heapInfoListModel.getSize()) {
                sel = -1;
            }
            this.getListHeaps().setSelectedIndex(sel);
        }
        finally {
            this.refreshing = false;
        }
        this.refreshHeapDetails();
    }

    protected void refreshHeapDetails() {
        int index = -1;
        int[] sel = this.getListHeaps().getSelectedIndices();
        if (sel != null && sel.length == 1) {
            index = sel[0];
        }
        HeapInfo heapInfo = null;
        if (index >= 0) {
            heapInfo = (HeapInfo)this.heapInfoListModel.get(index);
        }
        this.getHeapInfoPanel().setHeapInfo(heapInfo);
    }

    protected HeapInfoPanel createHeapInfoPanel(HeapInfo heapInfo) {
        HeapInfoPanel heapInfoPanel = new HeapInfoPanel();
        heapInfoPanel.setHeapInfo(heapInfo);
        return heapInfoPanel;
    }

    public boolean isIncludeJavaHeapInfo() {
        return this.includeJavaHeapInfo;
    }

    public void setIncludeJavaHeapInfo(boolean includeJavaHeapInfo) {
        this.includeJavaHeapInfo = includeJavaHeapInfo;
        this.refresh();
    }

    private JList getListHeaps() {
        return this.listHeaps;
    }

    private HeapInfoPanel getHeapInfoPanel() {
        return this.heapInfoPanel;
    }

    protected class HeapInfoListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1358354755873274484L;

        protected HeapInfoListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            HeapInfo heapInfo;
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String text = null;
            if (value != null && value instanceof HeapInfo && (heapInfo = (HeapInfo)value) != null) {
                text = heapInfo.getName();
            }
            if (text == null) {
                text = String.valueOf(value);
            }
            this.setText(text);
            return comp;
        }
    }

    protected class RefreshLater
    implements Runnable {
        protected RefreshLater() {
        }

        @Override
        public void run() {
            HeapManagerPanel.this.refresh();
        }
    }

    protected class HeapManagerChangeHandler
    implements ChangeListener {
        protected HeapManagerChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(HeapManagerPanel.this.refreshLater);
        }
    }
}

