/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.heap.view;

public class HeapSummaryUtil {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;

    private HeapSummaryUtil() {
    }

    public static String getHumanByteSizeString(long byteCount, boolean roundUp) {
        if (byteCount >= 0L) {
            if (byteCount < 1024L) {
                return Long.toString(byteCount) + " B";
            }
            if (byteCount < 0x100000L) {
                return HeapSummaryUtil.getStringRound10((double)byteCount / 1024.0, roundUp) + " kB";
            }
            if (byteCount < 0x40000000L) {
                return HeapSummaryUtil.getStringRound10((double)byteCount / 1048576.0, roundUp) + " MB";
            }
            return HeapSummaryUtil.getStringRound10((double)byteCount / 1.073741824E9, roundUp) + " GB";
        }
        return Long.toString(byteCount);
    }

    protected static String getStringRound10(double value, boolean roundUp) {
        double roundedValue = roundUp ? Math.ceil(value * 10.0) / 10.0 : Math.floor(value * 10.0) / 10.0;
        return Double.toString(roundedValue);
    }
}

