/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.swing;

import com.waxmonster.swing.ColorButtonListener;
import com.waxmonster.swing.ColorButtonStyle;
import com.waxmonster.swing.ColorButtonUI;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JToggleButton;
import javax.swing.event.EventListenerList;

public class ColorButton
extends JToggleButton {
    private static final long serialVersionUID = 322659952609734274L;
    private static final ColorButtonUI colorButtonUI = new ColorButtonUI();
    private static ColorButtonStyle defaultStyle;
    private ColorButtonModel colorButtonModel;
    private boolean disarmed = false;
    private boolean toolTipEnabled = true;
    private ColorButtonStyle colorButtonStyle;
    private EventListenerList listenerList;

    public ColorButton() {
        this.initColorButton();
    }

    public ColorButton(String text) {
        super(text);
        this.initColorButton();
    }

    protected void initColorButton() {
        this.listenerList = new EventListenerList();
        this.colorButtonModel = new ColorButtonModel();
        this.setModel(this.colorButtonModel);
        this.colorButtonStyle = ColorButton.getDefaultStyle();
    }

    @Override
    public void updateUI() {
        this.setUI(colorButtonUI);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.toolTipEnabled) {
            return super.getToolTipText(event);
        }
        return null;
    }

    public boolean isToolTipEnabled() {
        return this.toolTipEnabled;
    }

    public void setToolTipEnabled(boolean toolTipEnabled) {
        this.toolTipEnabled = toolTipEnabled;
    }

    public ColorButtonStyle getColorButtonStyle() {
        return this.colorButtonStyle;
    }

    public void setColorButtonStyle(ColorButtonStyle colorButtonStyle) {
        if (this.colorButtonStyle == colorButtonStyle) {
            return;
        }
        this.colorButtonStyle = colorButtonStyle;
        this.repaint();
    }

    public static ColorButtonStyle getDefaultStyle() {
        if (defaultStyle == null) {
            defaultStyle = new ColorButtonStyle(Color.GRAY);
        }
        return defaultStyle;
    }

    public boolean isDisarmed() {
        return this.disarmed;
    }

    public void setDisarmed(boolean disarmed) {
        this.disarmed = disarmed;
    }

    public void addColorButtonListener(ColorButtonListener l) {
        this.listenerList.add(ColorButtonListener.class, l);
    }

    public void removeColorButtonListener(ColorButtonListener l) {
        this.listenerList.remove(ColorButtonListener.class, l);
    }

    protected void fireButtonPressed(ActionEvent event) {
        Object[] list = this.listenerList.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ColorButtonListener)list[i]).buttonPressed(event);
        }
    }

    protected void fireButtonPressed(MouseEvent event) {
        Object[] list = this.listenerList.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ColorButtonListener)list[i]).buttonPressed(event);
        }
    }

    protected void fireButtonReleased(ActionEvent event) {
        Object[] list = this.listenerList.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ColorButtonListener)list[i]).buttonReleased(event);
        }
    }

    protected void fireButtonReleased(MouseEvent event) {
        Object[] list = this.listenerList.getListenerList();
        for (int i = 1; i < list.length; i += 2) {
            ((ColorButtonListener)list[i]).buttonReleased(event);
        }
    }

    protected class ColorButtonModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = 4475662716361579894L;

        protected ColorButtonModel() {
        }

        @Override
        public void setArmed(boolean b) {
            if (ColorButton.this.disarmed) {
                return;
            }
            super.setArmed(b);
        }

        @Override
        public void setSelected(boolean b) {
            super.setSelected(b);
        }
    }
}

