/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.swing;

import com.waxmonster.swing.ColorUtil;
import java.awt.Color;

public class ColorButtonStyle {
    protected Color normalBackground;
    protected Color disabledBackground;
    protected Color selectedBackground;
    protected Color pressedBackground;
    protected Color rolloverBackground;
    protected Color normalShadow;
    protected Color disabledShadow;
    protected Color selectedShadow;
    protected Color normalLight;
    protected Color disabledLight;
    protected Color selectedLight;
    protected Color normalOutline;
    protected Color disabledOutline;
    protected Color focusOutline;
    protected Color rolloverOutline;

    public ColorButtonStyle(Color color) {
        this.applyColor(color);
    }

    protected void applyColor(Color color) {
        this.normalBackground = ColorUtil.tuneColor(color, 0.5f, 0.5f);
        this.disabledBackground = ColorUtil.tuneColor(color, 0.3f, 0.3f);
        this.selectedBackground = color;
        this.pressedBackground = ColorUtil.tuneColor(color, 0.4f, 0.4f);
        this.rolloverBackground = ColorUtil.tuneColor(color, 0.96f, 1.04f);
        this.normalShadow = ColorButtonStyle.shadow(this.normalBackground);
        this.disabledShadow = ColorButtonStyle.shadow(this.disabledBackground);
        this.selectedShadow = ColorButtonStyle.shadow(this.selectedBackground);
        this.normalLight = ColorButtonStyle.light(this.normalBackground);
        this.disabledLight = ColorButtonStyle.light(this.disabledBackground);
        this.selectedLight = ColorButtonStyle.light(this.selectedBackground);
        this.normalOutline = Color.BLACK;
        this.disabledOutline = ColorUtil.tuneColor(color, 1.6f, 0.5f);
        this.rolloverOutline = ColorUtil.tuneColor(color, 0.7f, 0.7f);
        this.focusOutline = Color.WHITE;
    }

    public static Color shadow(Color col) {
        return ColorUtil.tuneColor(col, 1.4f, 0.75f);
    }

    public static Color light(Color col) {
        return ColorUtil.tuneColor(col, 0.8f, 1.1f);
    }

    public Color getNormalBackground() {
        return this.normalBackground;
    }

    public void setNormalBackground(Color normalBackground) {
        this.normalBackground = normalBackground;
    }

    public Color getDisabledBackground() {
        return this.disabledBackground;
    }

    public void setDisabledBackground(Color disabledBackground) {
        this.disabledBackground = disabledBackground;
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color selectedBackground) {
        this.selectedBackground = selectedBackground;
    }

    public Color getPressedBackground() {
        return this.pressedBackground;
    }

    public void setPressedBackground(Color pressedBackground) {
        this.pressedBackground = pressedBackground;
    }

    public Color getRolloverBackground() {
        return this.rolloverBackground;
    }

    public void setRolloverBackground(Color rolloverBackground) {
        this.rolloverBackground = rolloverBackground;
    }

    public Color getNormalShadow() {
        return this.normalShadow;
    }

    public void setNormalShadow(Color normalShadow) {
        this.normalShadow = normalShadow;
    }

    public Color getDisabledShadow() {
        return this.disabledShadow;
    }

    public void setDisabledShadow(Color disabledShadow) {
        this.disabledShadow = disabledShadow;
    }

    public Color getSelectedShadow() {
        return this.selectedShadow;
    }

    public void setSelectedShadow(Color selectedShadow) {
        this.selectedShadow = selectedShadow;
    }

    public Color getNormalLight() {
        return this.normalLight;
    }

    public void setNormalLight(Color normalLight) {
        this.normalLight = normalLight;
    }

    public Color getDisabledLight() {
        return this.disabledLight;
    }

    public void setDisabledLight(Color disabledLight) {
        this.disabledLight = disabledLight;
    }

    public Color getSelectedLight() {
        return this.selectedLight;
    }

    public void setSelectedLight(Color selectedLight) {
        this.selectedLight = selectedLight;
    }

    public Color getNormalOutline() {
        return this.normalOutline;
    }

    public void setNormalOutline(Color normalOutline) {
        this.normalOutline = normalOutline;
    }

    public Color getDisabledOutline() {
        return this.disabledOutline;
    }

    public void setDisabledOutline(Color disabledOutline) {
        this.disabledOutline = disabledOutline;
    }

    public Color getFocusOutline() {
        return this.focusOutline;
    }

    public void setFocusOutline(Color focusOutline) {
        this.focusOutline = focusOutline;
    }

    public Color getRolloverOutline() {
        return this.rolloverOutline;
    }

    public void setRolloverOutline(Color rolloverOutline) {
        this.rolloverOutline = rolloverOutline;
    }
}

