/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.swing;

import com.waxmonster.swing.ColorButton;
import com.waxmonster.swing.ColorButtonStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class ColorButtonUI
extends BasicToggleButtonUI {
    private static final String ACTION_PRESSED = "pressed";
    private static final String ACTION_RELEASED = "released";
    private static Border buttonBorder;

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setBorder(ColorButtonUI.getButtonBorder());
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addMouseListener(new ButtonMouseHandler());
    }

    @Override
    protected void installKeyboardActions(AbstractButton b) {
        super.installKeyboardActions(b);
        ActionMap actionMap = b.getActionMap();
        if (actionMap != null) {
            actionMap.put(ACTION_PRESSED, new ButtonKeyboardAction(actionMap.get(ACTION_PRESSED)));
            actionMap.put(ACTION_RELEASED, new ButtonKeyboardAction(actionMap.get(ACTION_RELEASED)));
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        dim.width += 4;
        dim.height += 4;
        return dim;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        ColorButton button = (ColorButton)c;
        this.paintBackground(g2d, button);
        super.paint(g, c);
    }

    protected void paintBackground(Graphics2D g, ColorButton button) {
        if (button.isContentAreaFilled()) {
            ColorButtonStyle style = button.getColorButtonStyle();
            if (style == null) {
                return;
            }
            ButtonModel model = button.getModel();
            Color col = null;
            if (model.isSelected()) {
                col = style.getSelectedBackground();
            }
            if (col == null) {
                if (model.isEnabled()) {
                    if (model.isPressed()) {
                        col = style.getPressedBackground();
                    }
                    if (col == null) {
                        if (model.isRollover()) {
                            col = style.getRolloverBackground();
                        }
                        if (col == null) {
                            col = style.getNormalBackground();
                        }
                    }
                } else {
                    col = style.getDisabledBackground();
                }
            }
            if (col != null) {
                int w = button.getWidth();
                int h = button.getHeight();
                g.setColor(col);
                g.fillRect(0, 0, w, h);
            }
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        super.paintButtonPressed(g, b);
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        boolean pressed = model.isPressed();
        if (pressed) {
            ++textRect.x;
            ++textRect.y;
        }
        super.paintText(g, b, textRect, text);
    }

    @Override
    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        boolean pressed = model.isPressed();
        if (pressed) {
            ++iconRect.x;
            ++iconRect.y;
        }
        super.paintIcon(g, c, iconRect);
    }

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(new ColorButtonBorder(), new BasicBorders.MarginBorder());
        }
        return buttonBorder;
    }

    protected class ButtonMouseHandler
    extends MouseAdapter {
        private boolean wasPressed = false;

        protected ButtonMouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            ColorButton button = null;
            ButtonModel model = null;
            Object source = e.getSource();
            if (source != null && source instanceof ColorButton) {
                button = (ColorButton)source;
                model = button.getModel();
            }
            if (model == null) {
                return;
            }
            if (model.isPressed() && !this.wasPressed) {
                this.wasPressed = true;
                button.fireButtonPressed(e);
            } else if (!SwingUtilities.isLeftMouseButton(e)) {
                button.fireButtonPressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            ColorButton button = null;
            ButtonModel model = null;
            Object source = e.getSource();
            if (source != null && source instanceof ColorButton) {
                button = (ColorButton)source;
                model = button.getModel();
            }
            if (model == null) {
                return;
            }
            if (!model.isPressed() && this.wasPressed) {
                this.wasPressed = false;
                button.fireButtonReleased(e);
            } else if (!SwingUtilities.isLeftMouseButton(e)) {
                button.fireButtonReleased(e);
            }
        }
    }

    protected class ButtonKeyboardAction
    extends AbstractAction {
        private static final long serialVersionUID = 8648045208610433073L;
        private Action action;

        public ButtonKeyboardAction(Action action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorButton button = null;
            ButtonModel model = null;
            Object source = e.getSource();
            if (source != null && source instanceof ColorButton) {
                button = (ColorButton)source;
                model = button.getModel();
            }
            boolean wasPressed = false;
            if (model != null) {
                wasPressed = model.isPressed();
            }
            if (this.action != null) {
                this.action.actionPerformed(e);
            }
            if (model != null && model.isPressed() != wasPressed) {
                if (wasPressed) {
                    button.fireButtonReleased(e);
                } else {
                    button.fireButtonPressed(e);
                }
            }
        }
    }

    protected static class ColorButtonBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 1812196354719263652L;
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        protected ColorButtonBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color light;
            Color shadow;
            ColorButton button = (ColorButton)c;
            ColorButtonStyle style = button.getColorButtonStyle();
            if (style == null) {
                return;
            }
            ButtonModel model = button.getModel();
            boolean pressed = model.isPressed();
            Color outline = model.isEnabled() ? (button.isFocusOwner() ? style.getFocusOutline() : (model.isRollover() ? style.getRolloverOutline() : style.getNormalOutline())) : style.getDisabledOutline();
            g.setColor(outline);
            g.drawRect(x, y, w - 1, h - 1);
            if (model.isSelected()) {
                shadow = style.getSelectedShadow();
                light = style.getSelectedLight();
            } else if (model.isEnabled()) {
                shadow = style.getNormalShadow();
                light = style.getNormalLight();
            } else {
                shadow = style.getDisabledShadow();
                light = style.getDisabledLight();
            }
            for (int i = 0; i < 2; ++i) {
                Color col;
                ++x;
                ++y;
                w -= 2;
                h -= 2;
                Color color = col = pressed ? shadow : light;
                if (col != null) {
                    g.setColor(col);
                    g.drawLine(x, y, x + w - 1, y);
                    g.drawLine(x, y + 1, x, y + h - 1);
                }
                Color color2 = col = pressed ? light : shadow;
                if (col == null) continue;
                g.setColor(col);
                g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
                g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = ColorButtonBorder.borderInsets.top;
            newInsets.left = ColorButtonBorder.borderInsets.left;
            newInsets.bottom = ColorButtonBorder.borderInsets.bottom;
            newInsets.right = ColorButtonBorder.borderInsets.right;
            return newInsets;
        }
    }
}

