/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.lock.j15;

import com.spacekiller.util.lock.LockSupport;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public final class UnsafeLockSupport
implements LockSupport {
    private static final Logger logger = Logger.getLogger(UnsafeLockSupport.class.getName());
    private static final Unsafe unsafe = UnsafeLockSupport.initUnsafe();

    UnsafeLockSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unsafe initUnsafe() {
        Class<?> classUnsafe = Class.forName("sun.misc.Unsafe");
        Field theUnsafeField = classUnsafe.getDeclaredField("theUnsafe");
        theUnsafeField.setAccessible(true);
        try {
            Unsafe theUnsafe;
            Unsafe unsafe = theUnsafe = (Unsafe)theUnsafeField.get(null);
            theUnsafeField.setAccessible(false);
            return unsafe;
        }
        catch (Throwable throwable) {
            try {
                theUnsafeField.setAccessible(false);
                throw throwable;
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
    }

    public void unpark(Thread thread) {
        if (thread != null) {
            unsafe.unpark(thread);
        }
    }

    public void park() {
        unsafe.park(false, 0L);
    }

    public void park(long nanos) {
        if (nanos > 0L) {
            unsafe.park(false, nanos);
        }
    }
}

