/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.heap.Heap;
import com.spacekiller.util.media.AbstractMediaContext;
import com.spacekiller.util.media.AbstractMediaCrate;
import com.spacekiller.util.media.DirectoryMediaCrate;
import com.spacekiller.util.media.DirectoryMediaIndex;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaCrate;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.sound.SoundSystem;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseMediaContext
extends AbstractMediaContext {
    private static final Logger logger = Logger.getLogger(BaseMediaContext.class.getName());
    private final List libraryList = new ArrayList();
    private final Map libraryMap = new HashMap();
    private final Random random = new Random();
    private final Map crateMap = new HashMap();
    private final DirectoryMediaIndex directoryMediaIndex;
    private final SoundSystem soundSystem;
    private final Heap mediaHeap;
    private final int blockSize;

    public BaseMediaContext(MediaContext parent, DirectoryMediaIndex directoryMediaIndex, SoundSystem soundSystem, Heap mediaHeap, int blockSize) {
        super(parent);
        this.directoryMediaIndex = directoryMediaIndex;
        this.soundSystem = soundSystem;
        this.mediaHeap = mediaHeap;
        this.blockSize = blockSize;
    }

    public synchronized MediaLibrary getMediaLibrary(String libraryId) throws IOException {
        MediaLibrary lib = (MediaLibrary)this.libraryMap.get(libraryId);
        if (lib != null) {
            return lib;
        }
        return super.getMediaLibrary(libraryId);
    }

    public synchronized MediaLibrary[] getMediaLibraryArray() throws IOException {
        LinkedList<MediaLibrary> libList = new LinkedList<MediaLibrary>();
        for (BaseMediaContext context = this; context != null; context = context.getParent()) {
            MediaLibrary[] arr = context.getRegisteredMediaLibraryArray();
            if (arr == null) continue;
            for (MediaLibrary lib : arr) {
                if (lib == null) continue;
                libList.add(lib);
            }
        }
        return libList.toArray(new MediaLibrary[libList.size()]);
    }

    public synchronized MediaLibrary[] getRegisteredMediaLibraryArray() {
        return this.libraryList.toArray(new MediaLibrary[this.libraryList.size()]);
    }

    public synchronized void registerMediaLibrary(MediaLibrary library) throws IOException {
        super.registerMediaLibrary(library);
        String libraryId = library.getId();
        if (this.libraryMap.containsKey(libraryId)) {
            throw new IllegalArgumentException("Duplicate media library id: " + libraryId);
        }
        this.libraryMap.put(libraryId, library);
        this.libraryList.add(library);
    }

    public synchronized void unregisterMediaLibrary(MediaLibrary library) throws IOException {
        this.libraryList.remove(library);
        String libraryId = library.getId();
        MediaLibrary lib = (MediaLibrary)this.libraryMap.get(libraryId);
        if (lib == library) {
            this.libraryMap.remove(libraryId);
        }
        super.unregisterMediaLibrary(library);
    }

    public synchronized String generateUniqueLibraryId() throws IOException {
        String id;
        MediaLibrary lib;
        while ((lib = this.getMediaLibrary(id = this.generateRandomId())) != null) {
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerMediaCrate(MediaCrate crate) {
        if (crate == null) {
            return false;
        }
        String id = crate.getId();
        if ((id == null || id.length() < 1) && crate instanceof AbstractMediaCrate) {
            AbstractMediaCrate amc = (AbstractMediaCrate)crate;
            id = this.generateUniqueCrateId();
            this.setCrateId(amc, id);
        }
        Map map = this.crateMap;
        synchronized (map) {
            this.crateMap.put(id, new WeakReference<MediaCrate>(crate));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterMediaCrate(MediaCrate crate) {
        if (crate == null) {
            return false;
        }
        String id = crate.getId();
        if (id == null || id.length() < 1) {
            return false;
        }
        Map map = this.crateMap;
        synchronized (map) {
            WeakReference weak;
            Object ref = this.crateMap.get(id);
            if (ref != null && (weak = (WeakReference)ref).get() == crate) {
                this.crateMap.remove(id);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String generateUniqueCrateId() {
        Map map = this.crateMap;
        synchronized (map) {
            String id;
            while (this.crateMap.containsKey(id = this.generateRandomId())) {
            }
            return id;
        }
    }

    protected String generateRandomId() {
        long value = this.random.nextLong();
        return Long.toHexString(value);
    }

    public void enumerateDirectoryMediaCrates(DirectoryMediaCrate parent, Collection dstSubCrates) {
        String path = parent.getPath();
        if (path == null) {
            return;
        }
        File parentDir = new File(path);
        if (!parentDir.exists()) {
            return;
        }
        if (!parentDir.isDirectory()) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Enumerate directories: " + parentDir);
        }
        this.directoryMediaIndex.enumerateDirectoryMediaCrates(parentDir, parent, dstSubCrates);
    }

    public void enumerateDirectoryMediaCrateEntries(DirectoryMediaCrate parent, Collection dstCrateEntries) {
        String path = parent.getPath();
        if (path == null) {
            return;
        }
        File parentDir = new File(path);
        if (!parentDir.exists()) {
            return;
        }
        if (!parentDir.isDirectory()) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Enumerate media files: " + parentDir);
        }
        this.directoryMediaIndex.enumerateDirectoryMediaCrateEntries(parentDir, parent, dstCrateEntries);
    }

    protected SoundSystem getSoundSystem() {
        return this.soundSystem;
    }

    protected Heap getMediaHeap() {
        return this.mediaHeap;
    }

    protected int getBlockSize() {
        return this.blockSize;
    }
}

