/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import com.spacekiller.util.Resource;
import com.spacekiller.util.URIResource;
import com.spacekiller.util.URLResource;
import com.spacekiller.util.heap.Heap;
import com.spacekiller.util.media.MediaContext;
import com.spacekiller.util.media.MediaLibrary;
import com.spacekiller.util.media.MediaResource;
import com.spacekiller.util.media.SeekableModel;
import com.spacekiller.util.media.library.BaseMediaContext;
import com.spacekiller.util.media.library.RandomAccessFileInputStream;
import com.spacekiller.util.media.library.SeekableAudioInputStream;
import com.spacekiller.util.media.library.SeekableFileInputModel;
import com.spacekiller.util.media.library.SeekableFileInputStream;
import com.spacekiller.util.media.library.SeekableInputModel;
import com.spacekiller.util.media.library.SeekableInputStream;
import com.spacekiller.util.sound.SoundSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public abstract class BaseMediaLibrary
implements MediaLibrary {
    private static final Logger logger = Logger.getLogger(BaseMediaLibrary.class.getName());
    private final String id;
    private final BaseMediaContext context;

    public BaseMediaLibrary(String id, BaseMediaContext context) {
        this.id = id;
        this.context = context;
    }

    public String toString() {
        return super.toString() + "[" + this.id + "]";
    }

    public final String getId() {
        return this.id;
    }

    public final MediaContext getContext() {
        return this.context;
    }

    public InputStream createInputStream(Resource resource) throws IOException {
        if (resource.isFile()) {
            try {
                File file = resource.getFile();
                if (file != null) {
                    return new RandomAccessFileInputStream(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return resource.createInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream createAudioInputStream(Resource resource) throws IOException, UnsupportedAudioFileException {
        URLResource ur;
        URL url;
        File file;
        InputStream in;
        MediaResource remoteResource;
        MediaLibrary remoteLibrary;
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        if (resource instanceof MediaResource && (remoteLibrary = (remoteResource = (MediaResource)resource).getLibrary()) != this) {
            return remoteLibrary.createAudioInputStream((Resource)remoteResource);
        }
        SoundSystem soundSystem = this.context.getSoundSystem();
        if (soundSystem == null) {
            throw new UnsupportedAudioFileException("Missing SoundSystem!");
        }
        boolean tryStreamFirst = true;
        boolean tryStreamLast = false;
        UnsupportedAudioFileException uafe = null;
        if (tryStreamFirst) {
            boolean done = false;
            in = this.createInputStream(resource);
            try {
                AudioInputStream ais = this.createAudioInputStream(soundSystem, resource, in);
                done = true;
                AudioInputStream audioInputStream = ais;
                return audioInputStream;
            }
            catch (UnsupportedAudioFileException e) {
                uafe = e;
            }
            finally {
                if (!done) {
                    in.close();
                }
            }
        }
        if (resource.isFile() && (file = resource.getFile()) != null) {
            return this.createAudioInputStream(soundSystem, resource, file);
        }
        if (resource instanceof URLResource && (url = (ur = (URLResource)resource).getURL()) != null) {
            return this.createAudioInputStream(soundSystem, resource, url);
        }
        if (resource instanceof URIResource && (url = (ur = (URIResource)resource).getURL()) != null) {
            return this.createAudioInputStream(soundSystem, resource, url);
        }
        if (tryStreamLast) {
            boolean done = false;
            in = this.createInputStream(resource);
            try {
                AudioInputStream ais = this.createAudioInputStream(soundSystem, resource, in);
                done = true;
                AudioInputStream audioInputStream = ais;
                return audioInputStream;
            }
            finally {
                if (!done) {
                    in.close();
                }
            }
        }
        if (uafe == null) {
            uafe = new UnsupportedAudioFileException("Audio resource not supported: " + resource);
        }
        throw uafe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream createAudioInputStream(Resource resource, AudioFormat targetFormat) throws IOException, UnsupportedAudioFileException {
        MediaResource remoteResource;
        MediaLibrary remoteLibrary;
        if (resource == null) {
            throw new NullPointerException("resource");
        }
        if (resource instanceof MediaResource && (remoteLibrary = (remoteResource = (MediaResource)resource).getLibrary()) != this) {
            return remoteLibrary.createAudioInputStream((Resource)remoteResource, targetFormat);
        }
        SoundSystem soundSystem = this.context.getSoundSystem();
        if (soundSystem == null) {
            throw new UnsupportedAudioFileException("Missing SoundSystem!");
        }
        boolean done = false;
        AudioInputStream sourceStream = this.createAudioInputStream(resource);
        try {
            AudioInputStream targetStream = soundSystem.getAudioInputStream(targetFormat, sourceStream);
            if (targetStream != null) {
                done = true;
            }
            AudioInputStream audioInputStream = targetStream;
            return audioInputStream;
        }
        finally {
            if (!done && sourceStream != null) {
                sourceStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream createInputStream(Resource resource, boolean seekable) throws IOException {
        File file;
        if (!seekable) {
            return this.createInputStream(resource);
        }
        if (resource != null && resource.isFile() && (file = resource.getFile()) != null) {
            SeekableFileInputModel model = new SeekableFileInputModel(file);
            return model.createInputStream(0L);
        }
        Heap heap = this.context.getMediaHeap();
        int blockSize = this.context.getBlockSize();
        InputStream is = this.createInputStream(resource);
        boolean done = false;
        SeekableInputModel model = null;
        try {
            boolean autoClose = true;
            model = new SeekableInputModel(is, heap, blockSize, autoClose);
            SeekableInputStream sis = model.createInputStream(0L);
            done = true;
            SeekableInputStream seekableInputStream = sis;
            return seekableInputStream;
        }
        finally {
            if (!done) {
                if (model != null) {
                    model.close();
                }
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream createAudioInputStream(Resource resource, boolean seekable) throws IOException, UnsupportedAudioFileException {
        AudioInputStream ais = this.createAudioInputStream(resource);
        if (!seekable) {
            return ais;
        }
        boolean done = false;
        try {
            AudioInputStream sais = this.createSeekableAudioInputStream(ais);
            done = true;
            AudioInputStream audioInputStream = sais;
            return audioInputStream;
        }
        finally {
            if (!done && ais != null) {
                ais.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream createAudioInputStream(Resource resource, AudioFormat targetFormat, boolean seekable) throws IOException, UnsupportedAudioFileException {
        AudioInputStream ais = this.createAudioInputStream(resource, targetFormat);
        if (!seekable) {
            return ais;
        }
        boolean done = false;
        try {
            AudioInputStream sais = this.createSeekableAudioInputStream(ais);
            done = true;
            AudioInputStream audioInputStream = sais;
            return audioInputStream;
        }
        finally {
            if (!done && ais != null) {
                ais.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AudioInputStream createSeekableAudioInputStream(AudioInputStream ais) throws IOException {
        int frameSize;
        long frameLength = ais.getFrameLength();
        Heap heap = this.context.getMediaHeap();
        int blkSize = this.context.getBlockSize();
        AudioFormat format = ais.getFormat();
        if (format != null && (frameSize = format.getFrameSize()) > 0 && (blkSize = blkSize / frameSize * frameSize) < 1) {
            blkSize = 1;
        }
        boolean done = false;
        SeekableInputModel model = null;
        SeekableInputStream sis = null;
        try {
            boolean autoClose = true;
            model = new SeekableInputModel(ais, heap, blkSize, autoClose);
            sis = model.createInputStream(0L);
            SeekableAudioInputStream sais = new SeekableAudioInputStream(sis, sis, format, frameLength);
            done = true;
            SeekableAudioInputStream seekableAudioInputStream = sais;
            return seekableAudioInputStream;
        }
        finally {
            if (!done) {
                if (sis != null) {
                    sis.close();
                }
                if (model != null) {
                    model.close();
                }
            }
        }
    }

    protected SeekableModel getSeekableModel(InputStream stream) throws IOException {
        if (stream != null) {
            InputStream obj = stream;
            if (obj instanceof SeekableFileInputStream) {
                SeekableFileInputStream fis = (SeekableFileInputStream)obj;
                return fis.getModel();
            }
            if (obj instanceof SeekableAudioInputStream) {
                SeekableAudioInputStream ais = (SeekableAudioInputStream)obj;
                obj = ais.getSeekableStream();
            }
            if (obj instanceof SeekableInputStream) {
                SeekableInputStream sis = (SeekableInputStream)obj;
                return sis.getModel();
            }
        }
        throw new IOException("Input stream is not seekable: " + stream);
    }

    public InputStream createSeekableInputStream(InputStream stream, long pos) throws IOException {
        SeekableModel model = this.getSeekableModel(stream);
        if (model != null) {
            if (model instanceof SeekableInputModel) {
                SeekableInputModel sim = (SeekableInputModel)model;
                return sim.createInputStream(pos);
            }
            if (model instanceof SeekableFileInputModel) {
                SeekableFileInputModel sim = (SeekableFileInputModel)model;
                return sim.createInputStream(pos);
            }
        }
        throw new IllegalArgumentException("Unsupported stream: " + stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream createSeekableAudioInputStream(AudioInputStream stream, long pos) throws IOException {
        SeekableModel model = this.getSeekableModel(stream);
        if (model != null) {
            InputStream sis;
            Object sim;
            long frameLength = stream.getFrameLength();
            AudioFormat format = stream.getFormat();
            SeekableInputStream ss = null;
            SeekableInputStream is = null;
            if (model instanceof SeekableInputModel) {
                sim = (SeekableInputModel)model;
                ss = sis = ((SeekableInputModel)sim).createInputStream(pos);
                is = sis;
            } else if (model instanceof SeekableFileInputModel) {
                sim = (SeekableFileInputModel)model;
                ss = sis = ((SeekableFileInputModel)sim).createInputStream(pos);
                is = sis;
            }
            if (ss != null) {
                boolean done = false;
                try {
                    SeekableAudioInputStream sais = new SeekableAudioInputStream(ss, is, format, frameLength);
                    done = true;
                    SeekableAudioInputStream seekableAudioInputStream = sais;
                    return seekableAudioInputStream;
                }
                finally {
                    if (!done && is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unsupported stream: " + stream);
    }

    protected AudioInputStream createAudioInputStream(SoundSystem soundSystem, Resource resource, InputStream stream) throws IOException, UnsupportedAudioFileException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createAudioInputStream: resource=" + resource + ", stream=" + stream);
        }
        AudioInputStream ais = soundSystem.getAudioInputStream(stream);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createAudioInputStream: resource=" + resource + ", stream=" + stream + ", ais=" + ais);
        }
        return ais;
    }

    protected AudioInputStream createAudioInputStream(SoundSystem soundSystem, Resource resource, File file) throws IOException, UnsupportedAudioFileException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createAudioInputStream: resource=" + resource + ", file=" + file);
        }
        AudioInputStream ais = soundSystem.getAudioInputStream(file);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createAudioInputStream: resource=" + resource + ", file=" + file + ", ais=" + ais);
        }
        return ais;
    }

    protected AudioInputStream createAudioInputStream(SoundSystem soundSystem, Resource resource, URL url) throws IOException, UnsupportedAudioFileException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createAudioInputStream: resource=" + resource + ", url=" + url);
        }
        AudioInputStream ais = soundSystem.getAudioInputStream(url);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createAudioInputStream: resource=" + resource + ", url=" + url + ", ais=" + ais);
        }
        return ais;
    }
}

