/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.library;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CachedRandomAccessFile
extends RandomAccessFile {
    public static final int DEFAULT_CACHE_SIZE = 1024;
    private byte[] buf;
    private int ofs;
    private int len;
    private long fp;
    private int dirtOfs;
    private int dirtEnd;

    public CachedRandomAccessFile(File file, String mode, int cacheSize) throws FileNotFoundException {
        super(file, mode);
        this.initCachedRandomAccessFile(cacheSize);
    }

    public CachedRandomAccessFile(String name, String mode, int cacheSize) throws FileNotFoundException {
        super(name, mode);
        this.initCachedRandomAccessFile(cacheSize);
    }

    protected void initCachedRandomAccessFile(int cacheSize) {
        this.fp = 0L;
        this.len = 0;
        this.buf = new byte[cacheSize];
    }

    @Override
    public int read() throws IOException {
        if (this.ofs < this.len) {
            return this.buf[this.ofs++] & 0xFF;
        }
        if (this.dirtOfs < this.dirtEnd) {
            this.flush();
        }
        long pos = this.fp + (long)this.len;
        int num = (int)Math.min((long)this.buf.length, super.length() - pos);
        if (num < 1) {
            this.len = 0;
            this.ofs = 0;
            this.fp = pos;
            throw new EOFException("End of file: pos=" + pos);
        }
        this.load(pos, num);
        return this.buf[this.ofs++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int num) throws IOException {
        if (num < 0) {
            throw new IllegalArgumentException("Invalid number of bytes: " + num);
        }
        if (this.ofs + num <= this.len) {
            System.arraycopy(this.buf, this.ofs, b, off, num);
            this.ofs += num;
            return num;
        }
        for (int i = 0; i < num; ++i) {
            b[off++] = (byte)this.read();
        }
        return num;
    }

    private void touch(int num) {
        if (this.ofs < this.dirtOfs || this.dirtOfs == this.dirtEnd) {
            this.dirtOfs = this.ofs;
            this.ofs = this.dirtEnd = this.ofs + num;
        } else {
            this.ofs += num;
        }
        if (this.ofs > this.dirtEnd) {
            this.dirtEnd = this.ofs;
        }
    }

    @Override
    public void write(int b) throws IOException {
        int num;
        long pos;
        if (this.ofs < this.len) {
            this.buf[this.ofs] = (byte)b;
            this.touch(1);
            return;
        }
        if (this.len < this.buf.length) {
            ++this.len;
            this.buf[this.ofs] = (byte)b;
            this.touch(1);
            return;
        }
        if (this.dirtOfs < this.dirtEnd) {
            this.flush();
        }
        if ((pos = this.fp + (long)this.len) > super.length()) {
            super.seek(pos);
        }
        if ((num = (int)Math.min((long)this.buf.length, super.length() - pos)) < 0) {
            num = 0;
        }
        this.load(pos, num);
        if (this.ofs < this.len) {
            this.buf[this.ofs] = (byte)b;
            this.touch(1);
            return;
        }
        ++this.len;
        this.buf[this.ofs] = (byte)b;
        this.touch(1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int num) throws IOException {
        if (this.ofs + num <= this.len) {
            System.arraycopy(b, off, this.buf, this.ofs, num);
            this.touch(num);
            return;
        }
        for (int i = 0; i < num; ++i) {
            this.write(b[off++] & 0xFF);
        }
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.fp + (long)this.ofs;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos >= this.fp && pos < this.fp + (long)this.len) {
            this.ofs = (int)(pos - this.fp);
            return;
        }
        this.flush();
        this.len = 0;
        this.ofs = 0;
        this.fp = pos;
        super.seek(pos);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        this.flush();
        this.len = 0;
        this.ofs = 0;
        if (this.fp > newLength) {
            this.fp = newLength;
        }
        super.setLength(newLength);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }

    private void load(long pos, int num) throws IOException {
        this.len = 0;
        this.ofs = 0;
        this.fp = pos;
        if (num > 0) {
            this.seek(pos);
            super.read(this.buf, 0, num);
            this.len = num;
        }
    }

    public void flush() throws IOException {
        if (this.dirtOfs < this.dirtEnd) {
            super.seek(this.fp + (long)this.dirtOfs);
            super.write(this.buf, this.dirtOfs, this.dirtEnd - this.dirtOfs);
            this.dirtEnd = 0;
            this.dirtOfs = 0;
        }
    }
}

